/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.dialect.AnsiSqlDialect;
import org.apache.calcite.sql.dialect.HiveSqlDialect;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.flink.annotation.Internal;
import org.apache.flink.sql.parser.validate.FlinkSqlConformance;
import org.apache.flink.table.api.SqlDialect;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.FunctionCatalog;
import org.apache.flink.table.module.ModuleManager;
import org.apache.flink.table.planner.calcite.CalciteConfig;
import org.apache.flink.table.planner.calcite.CalciteConfig$;
import org.apache.flink.table.planner.calcite.FlinkContext;
import org.apache.flink.table.planner.calcite.FlinkContextImpl;
import org.apache.flink.table.planner.calcite.FlinkConvertletTable;
import org.apache.flink.table.planner.calcite.FlinkPlannerImpl;
import org.apache.flink.table.planner.calcite.FlinkRelBuilder;
import org.apache.flink.table.planner.calcite.FlinkRelFactories;
import org.apache.flink.table.planner.calcite.FlinkRelOptClusterFactory;
import org.apache.flink.table.planner.calcite.FlinkRexBuilder;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.calcite.FlinkTypeSystem;
import org.apache.flink.table.planner.calcite.RexFactory;
import org.apache.flink.table.planner.catalog.FunctionCatalogOperatorTable;
import org.apache.flink.table.planner.codegen.ExpressionReducer;
import org.apache.flink.table.planner.delegation.FlinkSqlParserFactories;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.hint.FlinkHintStrategies;
import org.apache.flink.table.planner.parse.CalciteParser;
import org.apache.flink.table.planner.plan.FlinkCalciteCatalogReader;
import org.apache.flink.table.planner.plan.cost.FlinkCostFactory;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.planner.utils.TableConfigUtils;

@Internal
public class PlannerContext {
    private final RelDataTypeSystem typeSystem = FlinkTypeSystem.INSTANCE;
    private final FlinkTypeFactory typeFactory;
    private final RelOptCluster cluster;
    private final FlinkContext context;
    private final CalciteSchema rootSchema;
    private final List<RelTraitDef> traitDefs;
    private final FrameworkConfig frameworkConfig;

    public PlannerContext(boolean isBatchMode, TableConfig tableConfig, ModuleManager moduleManager, FunctionCatalog functionCatalog, CatalogManager catalogManager, CalciteSchema rootSchema, List<RelTraitDef> traitDefs, ClassLoader classLoader) {
        this.typeFactory = new FlinkTypeFactory(classLoader, this.typeSystem);
        this.context = new FlinkContextImpl(isBatchMode, tableConfig, moduleManager, functionCatalog, catalogManager, new RexFactory(this.typeFactory, this::createFlinkPlanner, this::getCalciteSqlDialect, this::createRelBuilder), classLoader);
        this.rootSchema = rootSchema;
        this.traitDefs = traitDefs;
        this.frameworkConfig = this.createFrameworkConfig();
        VolcanoPlanner planner = new VolcanoPlanner(this.frameworkConfig.getCostFactory(), this.frameworkConfig.getContext());
        planner.setExecutor(this.frameworkConfig.getExecutor());
        for (RelTraitDef traitDef : this.frameworkConfig.getTraitDefs()) {
            planner.addRelTraitDef(traitDef);
        }
        this.cluster = FlinkRelOptClusterFactory.create(planner, new FlinkRexBuilder(this.typeFactory));
    }

    public RexFactory getRexFactory() {
        return this.context.getRexFactory();
    }

    public FrameworkConfig createFrameworkConfig() {
        return Frameworks.newConfigBuilder().defaultSchema(this.rootSchema.plus()).parserConfig(this.getSqlParserConfig()).costFactory(new FlinkCostFactory()).typeSystem(this.typeSystem).convertletTable(FlinkConvertletTable.INSTANCE).sqlToRelConverterConfig(this.getSqlToRelConverterConfig()).operatorTable(this.getSqlOperatorTable(this.getCalciteConfig())).executor(new ExpressionReducer(this.context.getTableConfig(), this.context.getClassLoader(), false)).context(this.context).traitDefs(this.traitDefs).build();
    }

    public FlinkTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    public FlinkContext getFlinkContext() {
        return this.context;
    }

    public FlinkRelBuilder createRelBuilder() {
        FlinkPlannerImpl planner = this.createFlinkPlanner();
        return this.createRelBuilder(planner);
    }

    public FlinkPlannerImpl createFlinkPlanner() {
        return new FlinkPlannerImpl(this.createFrameworkConfig(), this::createCatalogReader, this.typeFactory, this.cluster);
    }

    public CalciteParser createCalciteParser() {
        return new CalciteParser(this.getSqlParserConfig());
    }

    public FlinkCalciteCatalogReader createCatalogReader(boolean lenientCaseSensitivity) {
        SqlParser.Config sqlParserConfig = this.getSqlParserConfig();
        boolean caseSensitive = lenientCaseSensitivity ? false : sqlParserConfig.caseSensitive();
        SqlParser.Config newSqlParserConfig = SqlParser.configBuilder(sqlParserConfig).setCaseSensitive(caseSensitive).build();
        SchemaPlus finalRootSchema = this.getRootSchema(this.rootSchema.plus());
        CatalogManager catalogManager = this.context.getCatalogManager();
        return new FlinkCalciteCatalogReader(CalciteSchema.from(finalRootSchema), Arrays.asList(Arrays.asList(catalogManager.getCurrentCatalog(), catalogManager.getCurrentDatabase()), Collections.singletonList(catalogManager.getCurrentCatalog())), (RelDataTypeFactory)this.typeFactory, CalciteConfig$.MODULE$.connectionConfig(newSqlParserConfig));
    }

    public RelOptCluster getCluster() {
        return this.cluster;
    }

    private FlinkRelBuilder createRelBuilder(FlinkPlannerImpl planner) {
        FlinkCalciteCatalogReader calciteCatalogReader = this.createCatalogReader(false);
        Context chain = Contexts.of(this.context, planner.createToRelContext());
        return FlinkRelBuilder.of(chain, this.cluster, calciteCatalogReader);
    }

    private SchemaPlus getRootSchema(SchemaPlus schema) {
        if (schema.getParentSchema() == null) {
            return schema;
        }
        return this.getRootSchema(schema.getParentSchema());
    }

    private CalciteConfig getCalciteConfig() {
        return TableConfigUtils.getCalciteConfig(this.context.getTableConfig());
    }

    private SqlParser.Config getSqlParserConfig() {
        return JavaScalaConversionUtil.toJava(this.getCalciteConfig().getSqlParserConfig()).orElseGet(() -> {
            FlinkSqlConformance conformance = this.getSqlConformance();
            return SqlParser.config().withParserFactory(FlinkSqlParserFactories.create(conformance)).withConformance(conformance).withLex(Lex.JAVA).withIdentifierMaxLength(256);
        });
    }

    private org.apache.calcite.sql.SqlDialect getCalciteSqlDialect() {
        SqlDialect sqlDialect = this.context.getTableConfig().getSqlDialect();
        switch (sqlDialect) {
            case HIVE: {
                return HiveSqlDialect.DEFAULT;
            }
            case DEFAULT: {
                return AnsiSqlDialect.DEFAULT;
            }
        }
        throw new TableException("Unsupported SQL dialect: " + sqlDialect);
    }

    private FlinkSqlConformance getSqlConformance() {
        SqlDialect sqlDialect = this.context.getTableConfig().getSqlDialect();
        switch (sqlDialect) {
            case HIVE: {
                return FlinkSqlConformance.HIVE;
            }
            case DEFAULT: {
                return FlinkSqlConformance.DEFAULT;
            }
        }
        throw new TableException("Unsupported SQL dialect: " + sqlDialect);
    }

    private SqlToRelConverter.Config getSqlToRelConverterConfig() {
        return JavaScalaConversionUtil.toJava(this.getCalciteConfig().getSqlToRelConverterConfig()).orElseGet(() -> SqlToRelConverter.config().withTrimUnusedFields(false).withHintStrategyTable(FlinkHintStrategies.createHintStrategyTable()).withInSubQueryThreshold(Integer.MAX_VALUE).withExpand(false).withRelBuilderFactory(FlinkRelFactories.FLINK_REL_BUILDER()));
    }

    private SqlOperatorTable getSqlOperatorTable(CalciteConfig calciteConfig) {
        return JavaScalaConversionUtil.toJava(calciteConfig.getSqlOperatorTable()).map(operatorTable -> {
            if (calciteConfig.replacesSqlOperatorTable()) {
                return operatorTable;
            }
            return SqlOperatorTables.chain(this.getBuiltinSqlOperatorTable(), operatorTable);
        }).orElseGet(this::getBuiltinSqlOperatorTable);
    }

    private SqlOperatorTable getBuiltinSqlOperatorTable() {
        return SqlOperatorTables.chain(new FunctionCatalogOperatorTable(this.context.getFunctionCatalog(), this.context.getCatalogManager().getDataTypeFactory(), this.typeFactory, this.context.getRexFactory()), FlinkSqlOperatorTable.instance());
    }
}

