/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch;

import java.util.Collections;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.streaming.api.operators.SimpleOperatorFactory;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.sort.ComparatorCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.InputSortedExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.SortUtil;
import org.apache.flink.table.runtime.operators.sort.RankOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecRank
extends ExecNodeBase<RowData>
implements InputSortedExecNode<RowData> {
    private final int[] partitionFields;
    private final int[] sortFields;
    private final long rankStart;
    private final long rankEnd;
    private final boolean outputRankNumber;

    public BatchExecRank(ReadableConfig tableConfig, int[] partitionFields, int[] sortFields, long rankStart, long rankEnd, boolean outputRankNumber, InputProperty inputProperty, RowType outputType, String description) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecRank.class), ExecNodeContext.newPersistedConfig(BatchExecRank.class, tableConfig), Collections.singletonList(inputProperty), (LogicalType)outputType, description);
        this.partitionFields = partitionFields;
        this.sortFields = sortFields;
        this.rankStart = rankStart;
        this.rankEnd = rankEnd;
        this.outputRankNumber = outputRankNumber;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputType = (RowType)inputEdge.getOutputType();
        RankOperator operator = new RankOperator(ComparatorCodeGenerator.gen(config, planner.getFlinkContext().getClassLoader(), "PartitionByComparator", inputType, SortUtil.getAscendingSortSpec(this.partitionFields)), ComparatorCodeGenerator.gen(config, planner.getFlinkContext().getClassLoader(), "OrderByComparator", inputType, SortUtil.getAscendingSortSpec(this.sortFields)), this.rankStart, this.rankEnd, this.outputRankNumber);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationName(config), this.createTransformationDescription(config), SimpleOperatorFactory.of((StreamOperator)operator), InternalTypeInfo.of((RowType)((RowType)this.getOutputType())), inputTransform.getParallelism());
    }
}

