/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.stream;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.flink.FlinkVersion;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.agg.AggsHandlerCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeMetadata;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.stream.StreamExecAggregateBase;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.planner.plan.utils.AggregateInfoList;
import org.apache.flink.table.planner.plan.utils.AggregateUtil;
import org.apache.flink.table.planner.plan.utils.KeySelectorUtil;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil;
import org.apache.flink.table.runtime.generated.GeneratedAggsHandleFunction;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.aggregate.MiniBatchLocalGroupAggFunction;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.operators.bundle.MapBundleOperator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;

@ExecNodeMetadata(name="stream-exec-local-group-aggregate", version=1, consumedOptions={"table.exec.mini-batch.enabled", "table.exec.mini-batch.size"}, producedTransformations={"local-group-aggregate"}, minPlanVersion=FlinkVersion.v1_15, minStateVersion=FlinkVersion.v1_15)
public class StreamExecLocalGroupAggregate
extends StreamExecAggregateBase {
    public static final String LOCAL_GROUP_AGGREGATE_TRANSFORMATION = "local-group-aggregate";
    @JsonProperty(value="grouping")
    private final int[] grouping;
    @JsonProperty(value="aggCalls")
    private final AggregateCall[] aggCalls;
    @JsonProperty(value="aggCallNeedRetractions")
    private final boolean[] aggCallNeedRetractions;
    @JsonProperty(value="needRetraction")
    private final boolean needRetraction;

    public StreamExecLocalGroupAggregate(ReadableConfig tableConfig, int[] grouping, AggregateCall[] aggCalls, boolean[] aggCallNeedRetractions, boolean needRetraction, InputProperty inputProperty, RowType outputType, String description) {
        this(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(StreamExecLocalGroupAggregate.class), ExecNodeContext.newPersistedConfig(StreamExecLocalGroupAggregate.class, tableConfig), grouping, aggCalls, aggCallNeedRetractions, needRetraction, Collections.singletonList(inputProperty), outputType, description);
    }

    @JsonCreator
    public StreamExecLocalGroupAggregate(@JsonProperty(value="id") int id, @JsonProperty(value="type") ExecNodeContext context, @JsonProperty(value="configuration") ReadableConfig persistedConfig, @JsonProperty(value="grouping") int[] grouping, @JsonProperty(value="aggCalls") AggregateCall[] aggCalls, @JsonProperty(value="aggCallNeedRetractions") boolean[] aggCallNeedRetractions, @JsonProperty(value="needRetraction") boolean needRetraction, @JsonProperty(value="inputProperties") List<InputProperty> inputProperties, @JsonProperty(value="outputType") RowType outputType, @JsonProperty(value="description") String description) {
        super(id, context, persistedConfig, inputProperties, (LogicalType)outputType, description);
        this.grouping = (int[])Preconditions.checkNotNull((Object)grouping);
        this.aggCalls = (AggregateCall[])Preconditions.checkNotNull((Object)aggCalls);
        this.aggCallNeedRetractions = (boolean[])Preconditions.checkNotNull((Object)aggCallNeedRetractions);
        Preconditions.checkArgument((aggCalls.length == aggCallNeedRetractions.length ? 1 : 0) != 0);
        this.needRetraction = needRetraction;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge inputEdge = this.getInputEdges().get(0);
        Transformation<?> inputTransform = inputEdge.translateToPlan(planner);
        RowType inputRowType = (RowType)inputEdge.getOutputType();
        AggsHandlerCodeGenerator generator = new AggsHandlerCodeGenerator(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader()), planner.createRelBuilder(), JavaScalaConversionUtil.toScala(inputRowType.getChildren()), true);
        generator.needAccumulate().needMerge(0, true, null);
        if (this.needRetraction) {
            generator.needRetract();
        }
        AggregateInfoList aggInfoList = AggregateUtil.transformToStreamAggregateInfoList(planner.getTypeFactory(), inputRowType, JavaScalaConversionUtil.toScala(Arrays.asList(this.aggCalls)), this.aggCallNeedRetractions, this.needRetraction, false, true);
        GeneratedAggsHandleFunction aggsHandler = generator.generateAggsHandler("GroupAggsHandler", aggInfoList);
        MiniBatchLocalGroupAggFunction aggFunction = new MiniBatchLocalGroupAggFunction(aggsHandler);
        RowDataKeySelector selector = KeySelectorUtil.getRowDataSelector(planner.getFlinkContext().getClassLoader(), this.grouping, (InternalTypeInfo<RowData>)((InternalTypeInfo)inputTransform.getOutputType()));
        MapBundleOperator operator = new MapBundleOperator((MapBundleFunction)aggFunction, AggregateUtil.createMiniBatchTrigger(config), (KeySelector)selector);
        return ExecNodeUtil.createOneInputTransformation(inputTransform, this.createTransformationMeta(LOCAL_GROUP_AGGREGATE_TRANSFORMATION, config), operator, InternalTypeInfo.of((LogicalType)this.getOutputType()), inputTransform.getParallelism());
    }
}

