/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.rules.physical.batch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.abilities.SupportsDynamicFiltering;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalCalc;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalDynamicFilteringDataCollector;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalDynamicFilteringTableSourceScan;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalExchange;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalJoinBase;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalRel;
import org.apache.flink.table.planner.plan.nodes.physical.batch.BatchPhysicalTableSourceScan;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.utils.DynamicPartitionPruningUtils;

public abstract class DynamicPartitionPruningRule
extends RelRule<RelRule.Config> {
    public static final RuleSet DYNAMIC_PARTITION_PRUNING_RULES = RuleSets.ofList(DynamicPartitionPruningFactInRightRule.Config.DEFAULT.toRule(), DynamicPartitionPruningFactInLeftRule.Config.DEFAULT.toRule(), DynamicPartitionPruningFactInRightWithExchangeRule.Config.DEFAULT.toRule(), DynamicPartitionPruningFactInLeftWithExchangeRule.Config.DEFAULT.toRule(), DynamicPartitionPruningFactInRightWithCalcRule.Config.DEFAULT.toRule(), DynamicPartitionPruningFactInLeftWithCalcRule.Config.DEFAULT.toRule(), DynamicPartitionPruningFactInRightWithExchangeAndCalcRule.Config.DEFAULT.toRule(), DynamicPartitionPruningFactInLeftWithExchangeAndCalcRule.Config.DEFAULT.toRule());

    protected DynamicPartitionPruningRule(RelRule.Config config) {
        super(config);
    }

    private static List<Integer> getAcceptedFieldIndices(List<Integer> factJoinKeys, @Nullable BatchPhysicalCalc factCalc, BatchPhysicalTableSourceScan factScan, DynamicTableSource tableSource) {
        List<String> candidateFields;
        if (factCalc == null) {
            candidateFields = factJoinKeys.stream().map(i -> factScan.getRowType().getFieldNames().get((int)i)).collect(Collectors.toList());
        } else {
            RexProgram program = factCalc.getProgram();
            ArrayList<Integer> joinKeysIndexInFactTable = new ArrayList<Integer>();
            for (int joinKeyIdx : factJoinKeys) {
                RexNode node = program.expandLocalRef(program.getProjectList().get(joinKeyIdx));
                if (!(node instanceof RexInputRef)) continue;
                joinKeysIndexInFactTable.add(((RexInputRef)node).getIndex());
            }
            if (joinKeysIndexInFactTable.isEmpty()) {
                return Collections.emptyList();
            }
            candidateFields = joinKeysIndexInFactTable.stream().map(i -> factScan.getRowType().getFieldNames().get((int)i)).collect(Collectors.toList());
        }
        List<String> acceptedFilterFields = DynamicPartitionPruningUtils.getSuitableDynamicFilteringFieldsInFactSide(tableSource, candidateFields);
        ((SupportsDynamicFiltering)tableSource).applyDynamicFiltering(acceptedFilterFields);
        if (factCalc == null) {
            return acceptedFilterFields.stream().map(f -> factScan.getRowType().getFieldNames().indexOf(f)).collect(Collectors.toList());
        }
        return DynamicPartitionPruningRule.getAcceptedFieldsIndicesInCalc(acceptedFilterFields, factJoinKeys, factCalc, factScan);
    }

    private static List<Integer> getAcceptedFieldsIndicesInCalc(List<String> acceptedFields, List<Integer> factJoinKeys, BatchPhysicalCalc factCalc, BatchPhysicalTableSourceScan factScan) {
        List acceptedFieldsIndicesInFactScan = acceptedFields.stream().map(f -> factScan.getRowType().getFieldNames().indexOf(f)).collect(Collectors.toList());
        RexProgram program = factCalc.getProgram();
        ArrayList<Integer> acceptedFieldsIndicesInCalc = new ArrayList<Integer>();
        for (int joinKeyIdx : factJoinKeys) {
            RexNode node = program.expandLocalRef(program.getProjectList().get(joinKeyIdx));
            if (!(node instanceof RexInputRef) || !acceptedFieldsIndicesInFactScan.contains(((RexInputRef)node).getIndex())) continue;
            acceptedFieldsIndicesInCalc.add(joinKeyIdx);
        }
        return acceptedFieldsIndicesInCalc;
    }

    protected BatchPhysicalDynamicFilteringTableSourceScan createDynamicFilteringTableSourceScan(BatchPhysicalTableSourceScan factScan, BatchPhysicalRel dimSide, BatchPhysicalJoinBase join, @Nullable BatchPhysicalCalc factCalc, boolean factInLeft) {
        JoinInfo joinInfo = join.analyzeCondition();
        TableSourceTable tableSourceTable = factScan.getTable().unwrap(TableSourceTable.class);
        DynamicTableSource tableSource = tableSourceTable.tableSource();
        ImmutableIntList factJoinKeys = factInLeft ? joinInfo.leftKeys : joinInfo.rightKeys;
        ImmutableIntList dimJoinKeys = factInLeft ? joinInfo.rightKeys : joinInfo.leftKeys;
        List<Integer> acceptedFieldIndices = DynamicPartitionPruningRule.getAcceptedFieldIndices(factJoinKeys, factCalc, factScan, tableSource);
        ArrayList<Integer> dynamicFilteringFieldIndices = new ArrayList<Integer>();
        for (int i = 0; i < joinInfo.leftKeys.size(); ++i) {
            if (!acceptedFieldIndices.contains(factJoinKeys.get(i))) continue;
            dynamicFilteringFieldIndices.add((Integer)dimJoinKeys.get(i));
        }
        BatchPhysicalDynamicFilteringDataCollector dynamicFilteringDataCollector = this.createDynamicFilteringConnector(dimSide, dynamicFilteringFieldIndices);
        return new BatchPhysicalDynamicFilteringTableSourceScan(factScan.getCluster(), factScan.getTraitSet(), factScan.getHints(), factScan.tableSourceTable(), dynamicFilteringDataCollector);
    }

    private BatchPhysicalDynamicFilteringDataCollector createDynamicFilteringConnector(RelNode dimSide, List<Integer> dynamicFilteringFieldIndices) {
        RelDataType outputType = ((FlinkTypeFactory)dimSide.getCluster().getTypeFactory()).projectStructType(dimSide.getRowType(), dynamicFilteringFieldIndices.stream().mapToInt(i -> i).toArray());
        return new BatchPhysicalDynamicFilteringDataCollector(dimSide.getCluster(), dimSide.getTraitSet(), this.ignoreExchange(dimSide), outputType, dynamicFilteringFieldIndices.stream().mapToInt(i -> i).toArray());
    }

    private RelNode ignoreExchange(RelNode dimSide) {
        if (dimSide instanceof Exchange) {
            return dimSide.getInput(0);
        }
        return dimSide;
    }

    protected static class DynamicPartitionPruningFactInLeftWithExchangeAndCalcRule
    extends DynamicPartitionPruningRule {
        public DynamicPartitionPruningFactInLeftWithExchangeAndCalcRule(RelRule.Config config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            return DynamicPartitionPruningUtils.supportDynamicPartitionPruning(join, true);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            BatchPhysicalExchange exchange = (BatchPhysicalExchange)call.rel(1);
            BatchPhysicalCalc factCalc = (BatchPhysicalCalc)call.rel(2);
            BatchPhysicalTableSourceScan factScan = (BatchPhysicalTableSourceScan)call.rel(3);
            BatchPhysicalRel dimSide = (BatchPhysicalRel)call.rel(4);
            BatchPhysicalDynamicFilteringTableSourceScan newFactScan = this.createDynamicFilteringTableSourceScan(factScan, dimSide, join, factCalc, true);
            BatchPhysicalCalc newCalc = (BatchPhysicalCalc)factCalc.copy(factCalc.getTraitSet(), newFactScan, factCalc.getProgram());
            BatchPhysicalExchange newExchange = (BatchPhysicalExchange)exchange.copy(exchange.getTraitSet(), Collections.singletonList(newCalc));
            RelNode newJoin = join.copy(join.getTraitSet(), (List)Arrays.asList(newExchange, dimSide));
            call.transformTo(newJoin);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(BatchPhysicalJoinBase.class).inputs(l -> l.operand(BatchPhysicalExchange.class).oneInput(e -> e.operand(BatchPhysicalCalc.class).oneInput(f -> f.operand(BatchPhysicalTableSourceScan.class).noInputs())), r -> r.operand(BatchPhysicalRel.class).anyInputs())).as(Config.class);

            @Override
            default public DynamicPartitionPruningFactInLeftWithExchangeAndCalcRule toRule() {
                return new DynamicPartitionPruningFactInLeftWithExchangeAndCalcRule(this);
            }
        }
    }

    protected static class DynamicPartitionPruningFactInRightWithExchangeAndCalcRule
    extends DynamicPartitionPruningRule {
        public DynamicPartitionPruningFactInRightWithExchangeAndCalcRule(RelRule.Config config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            return DynamicPartitionPruningUtils.supportDynamicPartitionPruning(join, false);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            BatchPhysicalRel dimSide = (BatchPhysicalRel)call.rel(1);
            BatchPhysicalExchange exchange = (BatchPhysicalExchange)call.rel(2);
            BatchPhysicalCalc factCalc = (BatchPhysicalCalc)call.rel(3);
            BatchPhysicalTableSourceScan factScan = (BatchPhysicalTableSourceScan)call.rel(4);
            BatchPhysicalDynamicFilteringTableSourceScan newFactScan = this.createDynamicFilteringTableSourceScan(factScan, dimSide, join, factCalc, false);
            BatchPhysicalCalc newCalc = (BatchPhysicalCalc)factCalc.copy(factCalc.getTraitSet(), newFactScan, factCalc.getProgram());
            BatchPhysicalExchange newExchange = (BatchPhysicalExchange)exchange.copy(exchange.getTraitSet(), Collections.singletonList(newCalc));
            RelNode newJoin = join.copy(join.getTraitSet(), (List)Arrays.asList(dimSide, newExchange));
            call.transformTo(newJoin);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(BatchPhysicalJoinBase.class).inputs(l -> l.operand(BatchPhysicalRel.class).anyInputs(), r -> r.operand(BatchPhysicalExchange.class).oneInput(e -> e.operand(BatchPhysicalCalc.class).oneInput(f -> f.operand(BatchPhysicalTableSourceScan.class).noInputs())))).as(Config.class);

            @Override
            default public DynamicPartitionPruningFactInRightWithExchangeAndCalcRule toRule() {
                return new DynamicPartitionPruningFactInRightWithExchangeAndCalcRule(this);
            }
        }
    }

    protected static class DynamicPartitionPruningFactInLeftWithCalcRule
    extends DynamicPartitionPruningRule {
        public DynamicPartitionPruningFactInLeftWithCalcRule(RelRule.Config config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            return DynamicPartitionPruningUtils.supportDynamicPartitionPruning(join, true);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            BatchPhysicalCalc factCalc = (BatchPhysicalCalc)call.rel(1);
            BatchPhysicalTableSourceScan factScan = (BatchPhysicalTableSourceScan)call.rel(2);
            BatchPhysicalRel dimSide = (BatchPhysicalRel)call.rel(3);
            BatchPhysicalDynamicFilteringTableSourceScan newFactScan = this.createDynamicFilteringTableSourceScan(factScan, dimSide, join, factCalc, true);
            BatchPhysicalCalc newCalc = (BatchPhysicalCalc)factCalc.copy(factCalc.getTraitSet(), newFactScan, factCalc.getProgram());
            RelNode newJoin = join.copy(join.getTraitSet(), (List)Arrays.asList(newCalc, dimSide));
            call.transformTo(newJoin);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(BatchPhysicalJoinBase.class).inputs(l -> l.operand(BatchPhysicalCalc.class).oneInput(f -> f.operand(BatchPhysicalTableSourceScan.class).noInputs()), r -> r.operand(BatchPhysicalRel.class).anyInputs())).as(Config.class);

            @Override
            default public DynamicPartitionPruningFactInLeftWithCalcRule toRule() {
                return new DynamicPartitionPruningFactInLeftWithCalcRule(this);
            }
        }
    }

    protected static class DynamicPartitionPruningFactInRightWithCalcRule
    extends DynamicPartitionPruningRule {
        public DynamicPartitionPruningFactInRightWithCalcRule(RelRule.Config config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            return DynamicPartitionPruningUtils.supportDynamicPartitionPruning(join, false);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            BatchPhysicalRel dimSide = (BatchPhysicalRel)call.rel(1);
            BatchPhysicalCalc factCalc = (BatchPhysicalCalc)call.rel(2);
            BatchPhysicalTableSourceScan factScan = (BatchPhysicalTableSourceScan)call.rel(3);
            BatchPhysicalDynamicFilteringTableSourceScan newFactScan = this.createDynamicFilteringTableSourceScan(factScan, dimSide, join, factCalc, false);
            BatchPhysicalCalc newCalc = (BatchPhysicalCalc)factCalc.copy(factCalc.getTraitSet(), newFactScan, factCalc.getProgram());
            RelNode newJoin = join.copy(join.getTraitSet(), (List)Arrays.asList(dimSide, newCalc));
            call.transformTo(newJoin);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(BatchPhysicalJoinBase.class).inputs(l -> l.operand(BatchPhysicalRel.class).anyInputs(), r -> r.operand(BatchPhysicalCalc.class).oneInput(f -> f.operand(BatchPhysicalTableSourceScan.class).noInputs()))).as(Config.class);

            @Override
            default public DynamicPartitionPruningFactInRightWithCalcRule toRule() {
                return new DynamicPartitionPruningFactInRightWithCalcRule(this);
            }
        }
    }

    protected static class DynamicPartitionPruningFactInLeftWithExchangeRule
    extends DynamicPartitionPruningRule {
        public DynamicPartitionPruningFactInLeftWithExchangeRule(RelRule.Config config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            return DynamicPartitionPruningUtils.supportDynamicPartitionPruning(join, true);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            BatchPhysicalExchange exchange = (BatchPhysicalExchange)call.rel(1);
            BatchPhysicalTableSourceScan factScan = (BatchPhysicalTableSourceScan)call.rel(2);
            BatchPhysicalRel dimSide = (BatchPhysicalRel)call.rel(3);
            BatchPhysicalDynamicFilteringTableSourceScan newFactScan = this.createDynamicFilteringTableSourceScan(factScan, dimSide, join, null, true);
            BatchPhysicalExchange newExchange = (BatchPhysicalExchange)exchange.copy(exchange.getTraitSet(), Collections.singletonList(newFactScan));
            RelNode newJoin = join.copy(join.getTraitSet(), (List)Arrays.asList(newExchange, dimSide));
            call.transformTo(newJoin);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(BatchPhysicalJoinBase.class).inputs(l -> l.operand(BatchPhysicalExchange.class).oneInput(e -> e.operand(BatchPhysicalTableSourceScan.class).noInputs()), r -> r.operand(BatchPhysicalRel.class).anyInputs())).as(Config.class);

            @Override
            default public DynamicPartitionPruningFactInLeftWithExchangeRule toRule() {
                return new DynamicPartitionPruningFactInLeftWithExchangeRule(this);
            }
        }
    }

    protected static class DynamicPartitionPruningFactInRightWithExchangeRule
    extends DynamicPartitionPruningRule {
        public DynamicPartitionPruningFactInRightWithExchangeRule(RelRule.Config config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            return DynamicPartitionPruningUtils.supportDynamicPartitionPruning(join, false);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            BatchPhysicalRel dimSide = (BatchPhysicalRel)call.rel(1);
            BatchPhysicalExchange exchange = (BatchPhysicalExchange)call.rel(2);
            BatchPhysicalTableSourceScan factScan = (BatchPhysicalTableSourceScan)call.rel(3);
            BatchPhysicalDynamicFilteringTableSourceScan newFactScan = this.createDynamicFilteringTableSourceScan(factScan, dimSide, join, null, false);
            BatchPhysicalExchange newExchange = (BatchPhysicalExchange)exchange.copy(exchange.getTraitSet(), Collections.singletonList(newFactScan));
            RelNode newJoin = join.copy(join.getTraitSet(), (List)Arrays.asList(dimSide, newExchange));
            call.transformTo(newJoin);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(BatchPhysicalJoinBase.class).inputs(l -> l.operand(BatchPhysicalRel.class).anyInputs(), r -> r.operand(BatchPhysicalExchange.class).oneInput(e -> e.operand(BatchPhysicalTableSourceScan.class).noInputs()))).as(Config.class);

            @Override
            default public DynamicPartitionPruningFactInRightWithExchangeRule toRule() {
                return new DynamicPartitionPruningFactInRightWithExchangeRule(this);
            }
        }
    }

    protected static class DynamicPartitionPruningFactInLeftRule
    extends DynamicPartitionPruningRule {
        public DynamicPartitionPruningFactInLeftRule(RelRule.Config config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            return DynamicPartitionPruningUtils.supportDynamicPartitionPruning(join, true);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            BatchPhysicalTableSourceScan factScan = (BatchPhysicalTableSourceScan)call.rel(1);
            BatchPhysicalRel dimSide = (BatchPhysicalRel)call.rel(2);
            BatchPhysicalDynamicFilteringTableSourceScan newFactScan = this.createDynamicFilteringTableSourceScan(factScan, dimSide, join, null, true);
            RelNode newJoin = join.copy(join.getTraitSet(), (List)Arrays.asList(newFactScan, dimSide));
            call.transformTo(newJoin);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(BatchPhysicalJoinBase.class).inputs(l -> l.operand(BatchPhysicalTableSourceScan.class).noInputs(), r -> r.operand(BatchPhysicalRel.class).anyInputs())).as(Config.class);

            @Override
            default public DynamicPartitionPruningFactInLeftRule toRule() {
                return new DynamicPartitionPruningFactInLeftRule(this);
            }
        }
    }

    protected static class DynamicPartitionPruningFactInRightRule
    extends DynamicPartitionPruningRule {
        public DynamicPartitionPruningFactInRightRule(RelRule.Config config) {
            super(config);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            return DynamicPartitionPruningUtils.supportDynamicPartitionPruning(join, false);
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            BatchPhysicalJoinBase join = (BatchPhysicalJoinBase)call.rel(0);
            BatchPhysicalRel dimSide = (BatchPhysicalRel)call.rel(1);
            BatchPhysicalTableSourceScan factScan = (BatchPhysicalTableSourceScan)call.rel(2);
            BatchPhysicalDynamicFilteringTableSourceScan newFactScan = this.createDynamicFilteringTableSourceScan(factScan, dimSide, join, null, false);
            RelNode newJoin = join.copy(join.getTraitSet(), (List)Arrays.asList(dimSide, newFactScan));
            call.transformTo(newJoin);
        }

        public static interface Config
        extends RelRule.Config {
            public static final Config DEFAULT = EMPTY.withOperandSupplier(b0 -> b0.operand(BatchPhysicalJoinBase.class).inputs(l -> l.operand(BatchPhysicalRel.class).anyInputs(), r -> r.operand(BatchPhysicalTableSourceScan.class).noInputs())).as(Config.class);

            @Override
            default public DynamicPartitionPruningFactInRightRule toRule() {
                return new DynamicPartitionPruningFactInRightRule(this);
            }
        }
    }
}

