/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate;

import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.RowDataUtil;
import org.apache.flink.table.runtime.dataview.PerKeyStateDataViewStore;
import org.apache.flink.table.runtime.generated.GeneratedTableAggsHandleFunction;
import org.apache.flink.table.runtime.generated.TableAggsHandleFunction;
import org.apache.flink.table.runtime.operators.aggregate.RecordCounter;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.StateTtlConfigUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;

public class GroupTableAggFunction
extends KeyedProcessFunction<RowData, RowData, RowData> {
    private static final long serialVersionUID = 1L;
    private final GeneratedTableAggsHandleFunction genAggsHandler;
    private final LogicalType[] accTypes;
    private final RecordCounter recordCounter;
    private final boolean generateUpdateBefore;
    private final long stateRetentionTime;
    private transient TableAggsHandleFunction function = null;
    private transient ValueState<RowData> accState = null;

    public GroupTableAggFunction(GeneratedTableAggsHandleFunction genAggsHandler, LogicalType[] accTypes, int indexOfCountStar, boolean generateUpdateBefore, long stateRetentionTime) {
        this.genAggsHandler = genAggsHandler;
        this.accTypes = accTypes;
        this.recordCounter = RecordCounter.of(indexOfCountStar);
        this.generateUpdateBefore = generateUpdateBefore;
        this.stateRetentionTime = stateRetentionTime;
    }

    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        StateTtlConfig ttlConfig = StateTtlConfigUtil.createTtlConfig(this.stateRetentionTime);
        this.function = (TableAggsHandleFunction)this.genAggsHandler.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        this.function.open(new PerKeyStateDataViewStore(this.getRuntimeContext(), ttlConfig));
        InternalTypeInfo<RowData> accTypeInfo = InternalTypeInfo.ofFields(this.accTypes);
        ValueStateDescriptor accDesc = new ValueStateDescriptor("accState", accTypeInfo);
        if (ttlConfig.isEnabled()) {
            accDesc.enableTimeToLive(ttlConfig);
        }
        this.accState = this.getRuntimeContext().getState(accDesc);
    }

    public void processElement(RowData input, KeyedProcessFunction.Context ctx, Collector<RowData> out) throws Exception {
        boolean firstRow;
        RowData currentKey = (RowData)ctx.getCurrentKey();
        RowData accumulators = (RowData)this.accState.value();
        if (null == accumulators) {
            firstRow = true;
            accumulators = this.function.createAccumulators();
        } else {
            firstRow = false;
        }
        this.function.setAccumulators(accumulators);
        if (!firstRow && this.generateUpdateBefore) {
            this.function.emitValue(out, currentKey, true);
        }
        if (RowDataUtil.isAccumulateMsg(input)) {
            this.function.accumulate(input);
        } else {
            this.function.retract(input);
        }
        accumulators = this.function.getAccumulators();
        if (!this.recordCounter.recordCountIsZero(accumulators)) {
            this.function.emitValue(out, currentKey, false);
            this.accState.update((Object)accumulators);
        } else {
            this.accState.clear();
            this.function.cleanup();
        }
    }

    public void close() throws Exception {
        if (this.function != null) {
            this.function.close();
        }
    }
}

