/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.common;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;

public final class ResourceLocator {
    private ResourceLocator() {
    }

    public static Iterable<URL> findNamedResources(String name) {
        URI nameUri = URI.create(name);
        if (!ResourceLocator.isClasspath(nameUri)) {
            throw new IllegalArgumentException("unsupported or missing schema <" + nameUri.getScheme() + "> classpath: schema is supported.");
        }
        return ResourceLocator.urlClassPathResource(nameUri);
    }

    public static URL findNamedResource(String name) {
        URI nameUri = URI.create(name);
        if (ResourceLocator.isClasspath(nameUri)) {
            Iterable<URL> resources = ResourceLocator.urlClassPathResource(nameUri);
            return ResourceLocator.firstElementOrNull(resources);
        }
        try {
            if (nameUri.isAbsolute()) {
                return nameUri.toURL();
            }
            return new URL("file:" + name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static boolean isClasspath(URI nameUri) {
        String scheme = nameUri.getScheme();
        if (scheme == null) {
            return false;
        }
        return scheme.equalsIgnoreCase("classpath");
    }

    private static Iterable<URL> urlClassPathResource(URI uri) {
        ClassLoader cl = ResourceLocator.firstNonNull(Thread.currentThread().getContextClassLoader(), ResourceLocator.class.getClassLoader());
        try {
            Enumeration<URL> enumeration = cl.getResources(uri.getSchemeSpecificPart());
            return ResourceLocator.asIterable(enumeration);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static URL firstElementOrNull(Iterable<URL> urls) {
        Iterator<URL> iterator = urls.iterator();
        if (iterator.hasNext()) {
            URL url = iterator.next();
            return url;
        }
        return null;
    }

    private static <T> Iterable<T> asIterable(final Enumeration<T> enumeration) {
        return () -> new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    private static <T> T firstNonNull(T a, T b) {
        return a != null ? a : b;
    }
}

