/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.common.json;

import java.util.Objects;

public final class NamespaceNamePair {
    private final String namespace;
    private final String name;

    public static NamespaceNamePair from(String namespaceAndName) {
        Objects.requireNonNull(namespaceAndName);
        int pos = namespaceAndName.lastIndexOf("/");
        if (pos <= 0 || pos == namespaceAndName.length() - 1) {
            throw new IllegalArgumentException(namespaceAndName + " does not conform to the <namespace>/<name> format");
        }
        String namespace = namespaceAndName.substring(0, pos);
        String name = namespaceAndName.substring(pos + 1);
        return new NamespaceNamePair(namespace, name);
    }

    private NamespaceNamePair(String namespace, String name) {
        this.namespace = Objects.requireNonNull(namespace);
        this.name = Objects.requireNonNull(name);
    }

    public String namespace() {
        return this.namespace;
    }

    public String name() {
        return this.name;
    }
}

