/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.common.json;

import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonPointer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.statefun.flink.common.json.MissingKeyException;
import org.apache.flink.statefun.flink.common.json.WrongTypeException;
import org.apache.flink.util.TimeUtils;

public final class Selectors {
    public static Optional<ObjectNode> optionalObjectAt(JsonNode node, JsonPointer pointer) {
        if ((node = node.at(pointer)).isMissingNode()) {
            return Optional.empty();
        }
        if (!node.isObject()) {
            throw new WrongTypeException(pointer, "not an object");
        }
        return Optional.of((ObjectNode)node);
    }

    public static String textAt(JsonNode node, JsonPointer pointer) {
        if (!(node = Selectors.dereference(node, pointer)).isTextual()) {
            throw new WrongTypeException(pointer, "not a string");
        }
        return node.asText();
    }

    public static Optional<String> optionalTextAt(JsonNode node, JsonPointer pointer) {
        if ((node = node.at(pointer)).isMissingNode()) {
            return Optional.empty();
        }
        if (!node.isTextual()) {
            throw new WrongTypeException(pointer, "not a string");
        }
        return Optional.of(node.asText());
    }

    public static Duration durationAt(JsonNode node, JsonPointer pointer) {
        if (!(node = Selectors.dereference(node, pointer)).isTextual()) {
            throw new WrongTypeException(pointer, "not a duration");
        }
        try {
            return TimeUtils.parseDuration((String)node.asText());
        }
        catch (IllegalArgumentException ignore) {
            throw new WrongTypeException(pointer, "not a duration");
        }
    }

    public static Optional<Duration> optionalDurationAt(JsonNode node, JsonPointer pointer) {
        if ((node = node.at(pointer)).isMissingNode()) {
            return Optional.empty();
        }
        if (!node.isTextual()) {
            throw new WrongTypeException(pointer, "not a duration");
        }
        try {
            Duration duration = TimeUtils.parseDuration((String)node.asText());
            return Optional.of(duration);
        }
        catch (IllegalArgumentException ignore) {
            throw new WrongTypeException(pointer, "not a duration");
        }
    }

    public static int integerAt(JsonNode node, JsonPointer pointer) {
        if (!(node = Selectors.dereference(node, pointer)).isInt()) {
            throw new WrongTypeException(pointer, "not an integer");
        }
        return node.asInt();
    }

    public static long longAt(JsonNode node, JsonPointer pointer) {
        if (!(node = Selectors.dereference(node, pointer)).isLong() && !node.isInt()) {
            throw new WrongTypeException(pointer, "not a long");
        }
        return node.asLong();
    }

    public static OptionalLong optionalLongAt(JsonNode node, JsonPointer pointer) {
        if ((node = node.at(pointer)).isMissingNode()) {
            return OptionalLong.empty();
        }
        if (!node.isLong() && !node.isInt()) {
            throw new WrongTypeException(pointer, "not a long");
        }
        return OptionalLong.of(node.asLong());
    }

    public static OptionalInt optionalIntegerAt(JsonNode node, JsonPointer pointer) {
        if ((node = node.at(pointer)).isMissingNode()) {
            return OptionalInt.empty();
        }
        if (!node.isInt()) {
            throw new WrongTypeException(pointer, "not an integer");
        }
        return OptionalInt.of(node.asInt());
    }

    public static Iterable<? extends JsonNode> listAt(JsonNode node, JsonPointer pointer) {
        if ((node = node.at(pointer)).isMissingNode()) {
            return Collections.emptyList();
        }
        if (!node.isArray()) {
            throw new WrongTypeException(pointer, "not a list");
        }
        return node;
    }

    public static List<String> textListAt(JsonNode node, JsonPointer pointer) {
        if ((node = node.at(pointer)).isMissingNode()) {
            return Collections.emptyList();
        }
        if (!node.isArray()) {
            throw new WrongTypeException(pointer, "not a list");
        }
        return StreamSupport.stream(node.spliterator(), false).filter(JsonNode::isTextual).map(JsonNode::asText).collect(Collectors.toList());
    }

    public static Map<String, String> propertiesAt(JsonNode node, JsonPointer pointer) {
        if ((node = node.at(pointer)).isMissingNode()) {
            return Collections.emptyMap();
        }
        if (!node.isArray()) {
            throw new WrongTypeException(pointer, "not a key-value list");
        }
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        for (JsonNode listElement : node) {
            Iterator fields = listElement.fields();
            if (!fields.hasNext()) {
                throw new WrongTypeException(pointer, "not a key-value list");
            }
            Map.Entry field = (Map.Entry)fields.next();
            properties.put((String)field.getKey(), ((JsonNode)field.getValue()).asText());
        }
        return properties;
    }

    public static Map<String, Long> longPropertiesAt(JsonNode node, JsonPointer pointer) {
        if ((node = node.at(pointer)).isMissingNode()) {
            return Collections.emptyMap();
        }
        if (!node.isArray()) {
            throw new WrongTypeException(pointer, "not a key-value list");
        }
        LinkedHashMap<String, Long> longProperties = new LinkedHashMap<String, Long>();
        for (JsonNode listElement : node) {
            Iterator fields = listElement.fields();
            if (!fields.hasNext()) {
                throw new WrongTypeException(pointer, "not a key-value list");
            }
            Map.Entry field = (Map.Entry)fields.next();
            if (!((JsonNode)field.getValue()).isLong() && !((JsonNode)field.getValue()).isInt()) {
                throw new WrongTypeException(pointer, "value for key-value pair at " + (String)field.getKey() + " is not a long: " + field.getValue());
            }
            longProperties.put((String)field.getKey(), ((JsonNode)field.getValue()).asLong());
        }
        return longProperties;
    }

    private static JsonNode dereference(JsonNode node, JsonPointer pointer) {
        if ((node = node.at(pointer)).isMissingNode()) {
            throw new MissingKeyException(pointer);
        }
        return node;
    }
}

