/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.common.json;

import java.io.IOException;
import java.time.Duration;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.Module;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.flink.statefun.sdk.TypeName;
import org.apache.flink.util.TimeUtils;

public final class StateFunObjectMapper {
    public static ObjectMapper create() {
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule("statefun");
        module.addDeserializer(Duration.class, (JsonDeserializer)new DurationJsonDeserializer());
        module.addDeserializer(TypeName.class, (JsonDeserializer)new TypeNameJsonDeserializer());
        mapper.registerModule((Module)module);
        return mapper;
    }

    private static final class TypeNameJsonDeserializer
    extends JsonDeserializer<TypeName> {
        private TypeNameJsonDeserializer() {
        }

        public TypeName deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return TypeName.parseFrom((String)jsonParser.getText());
        }
    }

    private static final class DurationJsonDeserializer
    extends JsonDeserializer<Duration> {
        private DurationJsonDeserializer() {
        }

        public Duration deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return TimeUtils.parseDuration((String)jsonParser.getText());
        }
    }
}

