/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.common.protobuf;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.core.memory.DataInputView;

@NotThreadSafe
final class InputStreamView
extends InputStream {
    private int limit;
    private DataInputView source;

    InputStreamView() {
    }

    void set(DataInputView source, int serializedSize) {
        this.source = source;
        this.limit = serializedSize;
    }

    void done() {
        this.source = null;
        this.limit = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.limit <= 0) {
            return -1;
        }
        --this.limit;
        return this.source.readByte();
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        if (this.limit <= 0) {
            return -1;
        }
        int result = this.source.read(b, off, len = Math.min(len, this.limit));
        if (result >= 0) {
            this.limit -= result;
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        int min = (int)Math.min(n, (long)this.limit);
        long result = this.source.skipBytes(min);
        if (result >= 0L) {
            this.limit = (int)((long)this.limit - result);
        }
        return result;
    }

    @Override
    public synchronized void mark(int unused) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void reset() {
        throw new UnsupportedOperationException();
    }
}

