/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.common.protobuf;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public final class ProtobufReflectionUtil {
    private ProtobufReflectionUtil() {
    }

    public static <M extends Message> Parser<M> protobufParser(Class<M> messageClass) {
        Object parser = ProtobufReflectionUtil.getParserFromGeneratedMessage(messageClass);
        if (!(parser instanceof Parser)) {
            throw new IllegalStateException("was expecting a protobuf parser to be return from the static parser() method on the type  " + messageClass + " but instead got " + parser);
        }
        return (Parser)parser;
    }

    static DescriptorProtos.FileDescriptorSet protoFileDescriptorSet(Descriptors.Descriptor descriptor) {
        HashSet<Descriptors.FileDescriptor> descriptors = new HashSet<Descriptors.FileDescriptor>();
        descriptors.add(descriptor.getFile());
        ProtobufReflectionUtil.addDependenciesRecursively(descriptors, descriptor.getFile());
        DescriptorProtos.FileDescriptorSet.Builder fileDescriptorSet = DescriptorProtos.FileDescriptorSet.newBuilder();
        for (Descriptors.FileDescriptor d : descriptors) {
            fileDescriptorSet.addFile(d.toProto());
        }
        return fileDescriptorSet.build();
    }

    static <M extends Message> Descriptors.Descriptor protobufDescriptor(Class<M> type) {
        try {
            Method getDescriptor = type.getDeclaredMethod("getDescriptor", new Class[0]);
            return (Descriptors.Descriptor)getDescriptor.invoke(type, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("unable to obtain protobuf type fileDescriptorSet for " + type, e);
        }
    }

    private static <M extends Message> Object getParserFromGeneratedMessage(Class<M> messageClass) {
        try {
            Method parserMethod = messageClass.getDeclaredMethod("parser", new Class[0]);
            return parserMethod.invoke((Object)parserMethod, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static void addDependenciesRecursively(Set<Descriptors.FileDescriptor> visited, Descriptors.FileDescriptor descriptor) {
        for (Descriptors.FileDescriptor dependency : descriptor.getDependencies()) {
            if (!visited.add(dependency)) continue;
            ProtobufReflectionUtil.addDependenciesRecursively(visited, dependency.getFile());
        }
    }
}

