/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.common.protobuf;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.statefun.flink.common.generated.ProtobufSerializerSnapshot;
import org.apache.flink.statefun.flink.common.protobuf.InputStreamView;
import org.apache.flink.statefun.flink.common.protobuf.OutputStreamView;
import org.apache.flink.statefun.flink.common.protobuf.ProtobufReflectionUtil;

@NotThreadSafe
public final class ProtobufSerializer<M extends Message> {
    private final OutputStreamView output;
    private final CodedOutputStream codedOutputStream;
    private final InputStreamView input;
    private final CodedInputStream codedInputStream;
    private final Parser<M> parser;
    private final ProtobufSerializerSnapshot snapshot;

    public static <M extends Message> ProtobufSerializer<M> forMessageGeneratedClass(Class<M> type) {
        Objects.requireNonNull(type);
        Parser<M> parser = ProtobufReflectionUtil.protobufParser(type);
        ProtobufSerializerSnapshot snapshot = ProtobufSerializer.createSnapshot(type);
        return new ProtobufSerializer<M>(parser, snapshot);
    }

    private ProtobufSerializer(Parser<M> parser, ProtobufSerializerSnapshot snapshot) {
        this.parser = Objects.requireNonNull(parser);
        this.snapshot = Objects.requireNonNull(snapshot);
        this.input = new InputStreamView();
        this.output = new OutputStreamView();
        this.codedInputStream = CodedInputStream.newInstance((InputStream)this.input);
        this.codedOutputStream = CodedOutputStream.newInstance((OutputStream)this.output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(M record, DataOutputView target) throws IOException {
        int size = record.getSerializedSize();
        target.writeInt(size);
        this.output.set(target);
        try {
            record.writeTo(this.codedOutputStream);
            this.codedOutputStream.flush();
        }
        finally {
            this.output.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public M deserialize(DataInputView source) throws IOException {
        int serializedSize = source.readInt();
        this.input.set(source, serializedSize);
        this.codedInputStream.resetSizeCounter();
        try {
            Message message = (Message)this.parser.parseFrom(this.codedInputStream);
            return (M)message;
        }
        finally {
            this.input.done();
        }
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int serializedSize = source.readInt();
        target.writeInt(serializedSize);
        target.write(source, serializedSize);
    }

    ProtobufSerializerSnapshot snapshot() {
        return this.snapshot;
    }

    public ProtobufSerializer<M> duplicate() {
        return new ProtobufSerializer<M>(this.parser, this.snapshot);
    }

    private static <M extends Message> ProtobufSerializerSnapshot createSnapshot(Class<M> type) {
        Descriptors.Descriptor messageDescriptor = ProtobufReflectionUtil.protobufDescriptor(type);
        DescriptorProtos.FileDescriptorSet dependencies = ProtobufReflectionUtil.protoFileDescriptorSet(messageDescriptor);
        return ProtobufSerializerSnapshot.newBuilder().setMessageName(messageDescriptor.getFullName()).setGeneratedJavaName(type.getName()).setDescriptorSet(dependencies).build();
    }
}

