/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.common.protobuf;

import com.google.protobuf.Message;
import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.statefun.flink.common.protobuf.ProtobufTypeSerializer;

public class ProtobufTypeInformation<M extends Message>
extends TypeInformation<M> {
    private static final long serialVersionUID = 1L;
    private final Class<M> messageTypeClass;

    public ProtobufTypeInformation(Class<M> messageTypeClass) {
        this.messageTypeClass = Objects.requireNonNull(messageTypeClass);
    }

    public boolean isBasicType() {
        return false;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 0;
    }

    public int getTotalFields() {
        return 0;
    }

    public Class<M> getTypeClass() {
        return this.messageTypeClass;
    }

    public boolean isKeyType() {
        return false;
    }

    public TypeSerializer<M> createSerializer(ExecutionConfig config) {
        return new ProtobufTypeSerializer<M>(this.messageTypeClass);
    }

    public String toString() {
        return "ProtobufTypeInformation(" + this.messageTypeClass + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ProtobufTypeInformation that = (ProtobufTypeInformation)((Object)o);
        return this.messageTypeClass.equals(that.messageTypeClass);
    }

    public int hashCode() {
        return Objects.hashCode(this.messageTypeClass);
    }

    public boolean canEqual(Object obj) {
        return obj instanceof ProtobufTypeInformation;
    }
}

