/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.common.protobuf;

import com.google.protobuf.Message;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.statefun.flink.common.protobuf.ProtobufSerializer;
import org.apache.flink.statefun.flink.common.protobuf.ProtobufTypeSerializerSnapshot;

public final class ProtobufTypeSerializer<M extends Message>
extends TypeSerializer<M> {
    private static final long serialVersionUID = 1L;
    private final Class<M> typeClass;
    private transient ProtobufSerializer<M> underlyingSerializer;
    private transient ProtobufTypeSerializerSnapshot<M> snapshot;

    ProtobufTypeSerializer(Class<M> typeClass) {
        this(typeClass, ProtobufSerializer.forMessageGeneratedClass(typeClass));
    }

    private ProtobufTypeSerializer(Class<M> typeClass, ProtobufSerializer<M> protobufSerializer) {
        this.typeClass = Objects.requireNonNull(typeClass);
        this.underlyingSerializer = Objects.requireNonNull(protobufSerializer);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.underlyingSerializer = ProtobufSerializer.forMessageGeneratedClass(this.typeClass);
    }

    public TypeSerializer<M> duplicate() {
        return new ProtobufTypeSerializer<M>(this.typeClass, this.underlyingSerializer.duplicate());
    }

    public boolean isImmutableType() {
        return true;
    }

    public M createInstance() {
        return null;
    }

    public M copy(M from) {
        return (M)from.toBuilder().build();
    }

    public M copy(M from, M reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(M record, DataOutputView target) throws IOException {
        this.underlyingSerializer.serialize(record, target);
    }

    public M deserialize(DataInputView source) throws IOException {
        return this.underlyingSerializer.deserialize(source);
    }

    public M deserialize(M reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.underlyingSerializer.copy(source, target);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        Class<?> aClass = obj.getClass();
        return ((Object)((Object)this)).getClass().equals(aClass);
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public TypeSerializerSnapshot<M> snapshotConfiguration() {
        ProtobufTypeSerializerSnapshot<M> snapshot = this.snapshot;
        if (snapshot == null) {
            this.snapshot = snapshot = new ProtobufTypeSerializerSnapshot<M>(this.typeClass, this.underlyingSerializer.snapshot());
        }
        return snapshot;
    }

    Class<M> getTypeClass() {
        return this.typeClass;
    }
}

