/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.common.protobuf;

import com.google.protobuf.Message;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.statefun.flink.common.generated.ProtobufSerializerSnapshot;
import org.apache.flink.statefun.flink.common.protobuf.ProtobufTypeSerializer;

public final class ProtobufTypeSerializerSnapshot<M extends Message>
implements TypeSerializerSnapshot<M> {
    private static final int VERSION = 1;
    @Nullable
    private ProtobufSerializerSnapshot snapshotData;
    @Nullable
    private Class<M> typeClass;

    public ProtobufTypeSerializerSnapshot() {
    }

    ProtobufTypeSerializerSnapshot(Class<M> messageType, ProtobufSerializerSnapshot snapshotData) {
        this.typeClass = Objects.requireNonNull(messageType);
        this.snapshotData = Objects.requireNonNull(snapshotData);
    }

    private static <M extends Message> Class<M> classForName(ClassLoader userCodeClassLoader, ProtobufSerializerSnapshot snapshotData) {
        try {
            return Class.forName(snapshotData.getGeneratedJavaName(), false, userCodeClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to restore the protobuf serializer since the generated java class is not found. previously the generated java class was at " + snapshotData.getGeneratedJavaName() + " with " + snapshotData.getMessageName(), e);
        }
    }

    public int getCurrentVersion() {
        return 1;
    }

    public void writeSnapshot(DataOutputView out) throws IOException {
        if (this.snapshotData == null) {
            throw new IllegalStateException();
        }
        out.writeInt(this.snapshotData.getSerializedSize());
        out.write(this.snapshotData.toByteArray());
    }

    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        int snapshotSize = in.readInt();
        byte[] snapshotBytes = new byte[snapshotSize];
        in.readFully(snapshotBytes);
        this.snapshotData = ProtobufSerializerSnapshot.parseFrom(snapshotBytes);
        this.typeClass = ProtobufTypeSerializerSnapshot.classForName(userCodeClassLoader, this.snapshotData);
    }

    public TypeSerializer<M> restoreSerializer() {
        Objects.requireNonNull(this.typeClass);
        return new ProtobufTypeSerializer<M>(this.typeClass);
    }

    public TypeSerializerSchemaCompatibility<M> resolveSchemaCompatibility(TypeSerializer<M> newSerializer) {
        if (!(newSerializer instanceof ProtobufTypeSerializer)) {
            return TypeSerializerSchemaCompatibility.incompatible();
        }
        ProtobufTypeSerializer casted = (ProtobufTypeSerializer)newSerializer;
        return this.resolveSchemaCompatibility(casted);
    }

    private TypeSerializerSchemaCompatibility<M> resolveSchemaCompatibility(ProtobufTypeSerializer<?> newSerializer) {
        Class<?> otherTypeClass = newSerializer.getTypeClass();
        if (otherTypeClass == this.typeClass) {
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }
}

