/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cli;

import com.google.common.base.Preconditions;
import com.lmax.disruptor.RingBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hive.common.CompressionUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cli.LlapOptionsProcessor;
import org.apache.hadoop.hive.llap.configuration.LlapDaemonConfiguration;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.io.api.impl.LlapInputFormat;
import org.apache.hadoop.hive.llap.tezplugins.LlapTezUtils;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.ResourceUri;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.ResourceDownloader;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.NDC;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.slf4j.Log4jLogger;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapServiceDriver {
    protected static final Logger LOG = LoggerFactory.getLogger((String)LlapServiceDriver.class.getName());
    private static final String[] DEFAULT_AUX_CLASSES = new String[]{"org.apache.hive.hcatalog.data.JsonSerDe"};
    private static final String HBASE_SERDE_CLASS = "org.apache.hadoop.hive.hbase.HBaseSerDe";
    private static final String[] NEEDED_CONFIGS = LlapDaemonConfiguration.DAEMON_CONFIGS;
    private static final String[] OPTIONAL_CONFIGS = LlapDaemonConfiguration.SSL_DAEMON_CONFIGS;
    private static final String CONFIG_CLUSTER_NAME = "private.hive.llap.servicedriver.cluster.name";
    private final Configuration conf;

    public LlapServiceDriver() {
        SessionState ss = SessionState.get();
        this.conf = ss != null ? ss.getConf() : new HiveConf(SessionState.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        LOG.info("LLAP service driver invoked with arguments={}", (Object[])args);
        int ret = 0;
        try {
            new LlapServiceDriver().run(args);
        }
        catch (Throwable t) {
            System.err.println("Failed: " + t.getMessage());
            t.printStackTrace();
            ret = 3;
        }
        finally {
            LOG.info("LLAP service driver finished");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Completed processing - exiting with " + ret);
        }
        System.exit(ret);
    }

    private static Configuration resolve(Configuration configured, Properties direct, Properties hiveconf) {
        Configuration conf = new Configuration(false);
        LlapServiceDriver.populateConf(configured, conf, hiveconf, "CLI hiveconf");
        LlapServiceDriver.populateConf(configured, conf, direct, "CLI direct");
        return conf;
    }

    private static void populateConf(Configuration configured, Configuration target, Properties properties, String source) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            String val = configured.get(key);
            if (val == null) continue;
            target.set(key, val, source);
        }
    }

    static void populateConfWithLlapProperties(Configuration conf, Properties properties) {
        for (Map.Entry<Object, Object> props : properties.entrySet()) {
            String key = (String)props.getKey();
            if (HiveConf.getLlapDaemonConfVars().contains(key)) {
                conf.set(key, (String)props.getValue());
                continue;
            }
            if (key.startsWith("llap.") || key.startsWith("hive.llap.")) {
                LOG.warn("Adding key [{}] even though it is not in the set of known llap-server keys");
                conf.set(key, (String)props.getValue());
                continue;
            }
            LOG.warn("Ignoring unknown llap server parameter: [{}]", (Object)key);
        }
    }

    private void run(String[] args) throws Exception {
        String string;
        String java_home;
        String auxJars;
        URL logger;
        LlapOptionsProcessor optionsProcessor = new LlapOptionsProcessor();
        LlapOptionsProcessor.LlapOptions options = optionsProcessor.processOptions(args);
        Properties propsDirectOptions = new Properties();
        if (options == null) {
            return;
        }
        Path tmpDir = new Path(options.getDirectory());
        if (this.conf == null) {
            throw new Exception("Cannot load any configuration to run command");
        }
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        FileSystem lfs = FileSystem.getLocal((Configuration)this.conf).getRawFileSystem();
        for (String f : NEEDED_CONFIGS) {
            this.conf.addResource(f);
            if (this.conf.getResource(f) != null) continue;
            throw new Exception("Unable to find required config file: " + f);
        }
        for (String f : OPTIONAL_CONFIGS) {
            this.conf.addResource(f);
        }
        this.conf.reloadConfiguration();
        LlapServiceDriver.populateConfWithLlapProperties(this.conf, options.getConfig());
        if (options.getName() != null) {
            this.conf.set(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.varname, "@" + options.getName());
            propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS.varname, "@" + options.getName());
        }
        if (options.getSize() != -1L) {
            if (options.getCache() != -1L) {
                if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_MAPPED)) {
                    Preconditions.checkArgument((options.getCache() < options.getSize() ? 1 : 0) != 0, (Object)"Cache has to be smaller than the container sizing");
                } else if (options.getCache() < options.getSize()) {
                    LOG.warn("Note that this might need YARN physical memory monitoring to be turned off (yarn.nodemanager.pmem-check-enabled=false)");
                }
            }
            if (options.getXmx() != -1L) {
                Preconditions.checkArgument((options.getXmx() < options.getSize() ? 1 : 0) != 0, (Object)"Working memory has to be smaller than the container sizing");
            }
            if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT) && !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_MAPPED)) {
                Preconditions.checkArgument((options.getXmx() + options.getCache() < options.getSize() ? 1 : 0) != 0, (Object)"Working memory + cache has to be smaller than the container sizing ");
            }
        }
        long minAlloc = this.conf.getInt("yarn.scheduler.minimum-allocation-mb", -1);
        long containerSize = -1L;
        if (options.getSize() != -1L) {
            containerSize = options.getSize() / 0x100000L;
            Preconditions.checkArgument((containerSize >= minAlloc ? 1 : 0) != 0, (String)"Container size should be greater than minimum allocation(%s)", (Object[])new Object[]{minAlloc + "m"});
            this.conf.setLong(HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB.varname, containerSize);
            propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB.varname, String.valueOf(containerSize));
        }
        if (options.getExecutors() != -1) {
            this.conf.setLong(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS.varname, (long)options.getExecutors());
            propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS.varname, String.valueOf(options.getExecutors()));
        }
        if (options.getIoThreads() != -1) {
            this.conf.setLong(HiveConf.ConfVars.LLAP_IO_THREADPOOL_SIZE.varname, (long)options.getIoThreads());
            propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_IO_THREADPOOL_SIZE.varname, String.valueOf(options.getIoThreads()));
        }
        long cache = -1L;
        long xmx = -1L;
        if (options.getCache() != -1L) {
            cache = options.getCache();
            this.conf.set(HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE.varname, Long.toString(cache));
            propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE.varname, Long.toString(cache));
        }
        if (options.getXmx() != -1L) {
            xmx = options.getXmx();
            long xmxMb = xmx / 0x100000L;
            this.conf.setLong(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB.varname, xmxMb);
            propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB.varname, String.valueOf(xmxMb));
        }
        if (options.getLlapQueueName() != null && !options.getLlapQueueName().isEmpty()) {
            this.conf.set(HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME.varname, options.getLlapQueueName());
            propsDirectOptions.setProperty(HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME.varname, options.getLlapQueueName());
        }
        if (null == (logger = this.conf.getResource("llap-daemon-log4j2.properties"))) {
            throw new Exception("Unable to find required config file: llap-daemon-log4j2.properties");
        }
        Path home = new Path(System.getenv("HIVE_HOME"));
        Path scripts = new Path(new Path(new Path(home, "scripts"), "llap"), "bin");
        if (!lfs.exists(home)) {
            throw new Exception("Unable to find HIVE_HOME:" + home);
        }
        if (!lfs.exists(scripts)) {
            LOG.warn("Unable to find llap scripts:" + scripts);
        }
        Path libDir = new Path(tmpDir, "lib");
        Path tezDir = new Path(libDir, "tez");
        Path udfDir = new Path(libDir, "udfs");
        String tezLibs = this.conf.get("tez.lib.uris");
        if (tezLibs == null) {
            LOG.warn("Missing tez.lib.uris in tez-site.xml");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Copying tez libs from " + tezLibs);
        }
        lfs.mkdirs(tezDir);
        fs.copyToLocalFile(new Path(tezLibs), new Path(libDir, "tez.tar.gz"));
        CompressionUtils.unTar((String)new Path(libDir, "tez.tar.gz").toString(), (String)tezDir.toString(), (boolean)true);
        lfs.delete(new Path(libDir, "tez.tar.gz"), false);
        Class[] dependencies = new Class[]{LlapDaemonProtocolProtos.class, LlapTezUtils.class, LlapInputFormat.class, HiveInputFormat.class, SslSocketConnector.class, RingBuffer.class, org.apache.logging.log4j.Logger.class, Appender.class, Log4jLogger.class, NDC.class};
        for (Class c : dependencies) {
            Path jarPath = new Path(Utilities.jarFinderGetJar((Class)c));
            lfs.copyFromLocalFile(jarPath, libDir);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Copying " + jarPath + " to " + libDir);
        }
        for (String className : DEFAULT_AUX_CLASSES) {
            this.localizeJarForClass(lfs, libDir, className, false);
        }
        if (options.getIsHBase()) {
            try {
                this.localizeJarForClass(lfs, libDir, HBASE_SERDE_CLASS, true);
                Job fakeJob = new Job((Configuration)new JobConf());
                TableMapReduceUtil.addDependencyJars((Job)fakeJob);
                Collection hbaseJars = fakeJob.getConfiguration().getStringCollection("tmpjars");
                for (String jarPath : hbaseJars) {
                    if (jarPath.isEmpty()) continue;
                    lfs.copyFromLocalFile(new Path(jarPath), libDir);
                }
            }
            catch (Throwable t) {
                String err = "Failed to add HBase jars. Use --auxhbase=false to avoid localizing them";
                LOG.error(err);
                System.err.println(err);
                throw new RuntimeException(t);
            }
        }
        if ((auxJars = options.getAuxJars()) != null && !auxJars.isEmpty()) {
            String[] jarPaths;
            for (String jarPath : jarPaths = auxJars.split(",")) {
                if (jarPath.isEmpty()) continue;
                lfs.copyFromLocalFile(new Path(jarPath), libDir);
            }
        }
        Set<Object> allowedUdfs = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOW_PERMANENT_FNS) ? this.downloadPermanentFunctions(this.conf, udfDir) : Collections.emptySet();
        if (options.getJavaPath() == null || options.getJavaPath().isEmpty()) {
            java_home = System.getenv("JAVA_HOME");
            String jre_home = System.getProperty("java.home");
            if (java_home == null) {
                java_home = jre_home;
            } else if (!java_home.equals(jre_home)) {
                LOG.warn("Java versions might not match : JAVA_HOME=[{}],process jre=[{}]", (Object)java_home, (Object)jre_home);
            }
        } else {
            java_home = options.getJavaPath();
        }
        if (java_home == null || java_home.isEmpty()) {
            throw new RuntimeException("Could not determine JAVA_HOME from command line parameters, environment or system properties");
        }
        LOG.info("Using [{}] for JAVA_HOME", (Object)java_home);
        Path confPath = new Path(tmpDir, "conf");
        lfs.mkdirs(confPath);
        for (String f : NEEDED_CONFIGS) {
            this.copyConfig(lfs, confPath, f);
        }
        for (String f : OPTIONAL_CONFIGS) {
            try {
                this.copyConfig(lfs, confPath, f);
            }
            catch (Throwable t) {
                LOG.info("Error getting an optional config " + f + "; ignoring: " + t.getMessage());
            }
        }
        this.createLlapDaemonConfig(lfs, confPath, this.conf, propsDirectOptions, options.getConfig());
        InputStream loggerContent = logger.openStream();
        IOUtils.copyBytes((InputStream)loggerContent, (OutputStream)lfs.create(new Path(confPath, "llap-daemon-log4j2.properties"), true), (Configuration)this.conf, (boolean)true);
        String metricsFile = "hadoop-metrics2-llapdaemon.properties";
        URL metrics2 = this.conf.getResource(metricsFile);
        if (metrics2 == null) {
            LOG.warn("hadoop-metrics2-llapdaemon.properties cannot be found. Looking for hadoop-metrics2.properties");
            metricsFile = "hadoop-metrics2.properties";
            metrics2 = this.conf.getResource(metricsFile);
        }
        if (metrics2 != null) {
            InputStream metrics2FileStream = metrics2.openStream();
            IOUtils.copyBytes((InputStream)metrics2FileStream, (OutputStream)lfs.create(new Path(confPath, metricsFile), true), (Configuration)this.conf, (boolean)true);
            LOG.info("Copied hadoop metrics2 properties file from " + metrics2);
        } else {
            LOG.warn("Cannot find hadoop-metrics2-llapdaemon.properties or hadoop-metrics2.properties in classpath.");
        }
        PrintWriter udfStream = new PrintWriter((OutputStream)lfs.create(new Path(confPath, "llap-udfs.lst")));
        for (String string2 : allowedUdfs) {
            udfStream.println(string2);
        }
        udfStream.close();
        JSONObject configs = new JSONObject();
        configs.put("java.home", (Object)java_home);
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB.varname, HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_YARN_CONTAINER_MB.varname, containerSize);
        configs.put(HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE.varname, HiveConf.getSizeVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE));
        configs.put(HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT.varname, HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_ALLOCATOR_DIRECT));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB.varname, HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_MEMORY_PER_INSTANCE_MB));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_VCPUS_PER_INSTANCE.varname, HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_VCPUS_PER_INSTANCE));
        configs.put(HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS.varname, HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_NUM_EXECUTORS));
        if (HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME) != null) {
            configs.put(HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME.varname, (Object)HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME));
        }
        if (!StringUtils.isEmpty((CharSequence)(string = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS))) && string.startsWith("@") && string.length() > 1) {
            configs.put(CONFIG_CLUSTER_NAME, (Object)string.substring(1));
        }
        configs.put("yarn.scheduler.minimum-allocation-mb", this.conf.getInt("yarn.scheduler.minimum-allocation-mb", -1));
        configs.put("yarn.scheduler.minimum-allocation-vcores", this.conf.getInt("yarn.scheduler.minimum-allocation-vcores", -1));
        long maxDirect = xmx > 0L && cache > 0L && (double)xmx < (double)cache * 1.25 ? (long)((double)cache * 1.25) : -1L;
        configs.put("max_direct_memory", (Object)Long.toString(maxDirect));
        FSDataOutputStream os = lfs.create(new Path(tmpDir, "config.json"));
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)os);
        configs.write((Writer)w);
        w.close();
        os.close();
        lfs.close();
        fs.close();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Exiting successfully");
        }
    }

    private Set<String> downloadPermanentFunctions(Configuration conf, Path udfDir) throws HiveException, URISyntaxException, IOException {
        HashMap<String, String> udfs = new HashMap<String, String>();
        Hive hive = Hive.get((boolean)false);
        ResourceDownloader resourceDownloader = new ResourceDownloader(conf, udfDir.toUri().normalize().getPath());
        List fns = hive.getAllFunctions();
        HashSet<URI> srcUris = new HashSet<URI>();
        for (Function fn : fns) {
            String fqfn = fn.getDbName() + "." + fn.getFunctionName();
            if (udfs.containsKey(fn.getClassName())) {
                LOG.warn("Duplicate function names found for " + fn.getClassName() + " with " + fqfn + " and " + (String)udfs.get(fn.getClassName()));
            }
            udfs.put(fn.getClassName(), fqfn);
            List resources = fn.getResourceUris();
            if (resources == null || resources.isEmpty()) {
                LOG.warn("Missing resources for " + fqfn);
                continue;
            }
            for (ResourceUri resource : resources) {
                srcUris.add(ResourceDownloader.createURI((String)resource.getUri()));
            }
        }
        for (URI srcUri : srcUris) {
            List localUris = resourceDownloader.downloadExternal(srcUri, null, false);
            for (URI dst : localUris) {
                LOG.warn("Downloaded " + dst + " from " + srcUri);
            }
        }
        return udfs.keySet();
    }

    private void localizeJarForClass(FileSystem lfs, Path libDir, String className, boolean doThrow) throws IOException {
        String jarPath = null;
        boolean hasException = false;
        try {
            Class<?> auxClass = Class.forName(className);
            jarPath = Utilities.jarFinderGetJar(auxClass);
        }
        catch (Throwable t) {
            if (doThrow) {
                throw t instanceof IOException ? (IOException)t : new IOException(t);
            }
            hasException = true;
            String err = "Cannot find a jar for [" + className + "] due to an exception (" + t.getMessage() + "); not packaging the jar";
            LOG.error(err, t);
            System.err.println(err);
        }
        if (jarPath != null) {
            lfs.copyFromLocalFile(new Path(jarPath), libDir);
        } else if (!hasException) {
            String err = "Cannot find a jar for [" + className + "]; not packaging the jar";
            if (doThrow) {
                throw new IOException(err);
            }
            LOG.error(err);
            System.err.println(err);
        }
    }

    private void createLlapDaemonConfig(FileSystem lfs, Path confPath, Configuration configured, Properties direct, Properties hiveconf) throws IOException {
        FSDataOutputStream confStream = lfs.create(new Path(confPath, "llap-daemon-site.xml"));
        Configuration llapDaemonConf = LlapServiceDriver.resolve(configured, direct, hiveconf);
        llapDaemonConf.writeXml((OutputStream)confStream);
        confStream.close();
    }

    private void copyConfig(FileSystem lfs, Path confPath, String f) throws IOException {
        HiveConf.getBoolVar((Configuration)new Configuration(false), (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_CLIENT_CONSISTENT_SPLITS);
        lfs.copyFromLocalFile(new Path(this.conf.getResource(f).toString()), confPath);
    }
}

