/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.io.Serializable;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.ReplicationUtils$;
import kafka.utils.ZkUtils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\u0001\u0003\u0001\u001d\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u000f!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011qBE\u0007\u0002!)\u0011\u0011\u0003B\u0001\u0006kRLGn]\u0005\u0003'A\u0011q\u0001T8hO&tw\r\u0003\u0005\u0004\u0001\t\u0005\t\u0015!\u0003\u0016!\t1r#D\u0001\u0003\u0013\tA\"AA\bLC\u001a\\\u0017mQ8oiJ|G\u000e\\3s\u0011\u0015Q\u0002\u0001\"\u0001\u001c\u0003\u0019a\u0014N\\5u}Q\u0011A$\b\t\u0003-\u0001AQaA\rA\u0002UAqa\b\u0001C\u0002\u0013%\u0001%A\td_:$(o\u001c7mKJ\u001cuN\u001c;fqR,\u0012!\t\t\u0003-\tJ!a\t\u0002\u0003#\r{g\u000e\u001e:pY2,'oQ8oi\u0016DH\u000f\u0003\u0004&\u0001\u0001\u0006I!I\u0001\u0013G>tGO]8mY\u0016\u00148i\u001c8uKb$\b\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002\u0019\r|g\u000e\u001e:pY2,'/\u00133\u0016\u0003%\u0002\"!\u0003\u0016\n\u0005-R!aA%oi\"1Q\u0006\u0001Q\u0001\n%\nQbY8oiJ|G\u000e\\3s\u0013\u0012\u0004\u0003bB\u0018\u0001\u0005\u0004%I\u0001M\u0001\bu.,F/\u001b7t+\u0005\t\u0004CA\b3\u0013\t\u0019\u0004CA\u0004[WV#\u0018\u000e\\:\t\rU\u0002\u0001\u0015!\u00032\u0003!Q8.\u0016;jYN\u0004\u0003bB\u001c\u0001\u0005\u0004%I\u0001O\u0001\re\u0016\u0004H.[2b'R\fG/Z\u000b\u0002sA!!hP!E\u001b\u0005Y$B\u0001\u001f>\u0003\u001diW\u000f^1cY\u0016T!A\u0010\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002Aw\t\u0019Q*\u00199\u0011\u0005Y\u0011\u0015BA\"\u0003\u0005M\u0001\u0016M\u001d;ji&|g.\u00118e%\u0016\u0004H.[2b!\t1R)\u0003\u0002G\u0005\ta!+\u001a9mS\u000e\f7\u000b^1uK\"1\u0001\n\u0001Q\u0001\ne\nQB]3qY&\u001c\u0017m\u0015;bi\u0016\u0004\u0003b\u0002&\u0001\u0005\u0004%IaS\u0001\u0013EJ|7.\u001a:SKF,Xm\u001d;CCR\u001c\u0007.F\u0001M!\t1R*\u0003\u0002O\u0005\ta2i\u001c8ue>dG.\u001a:Ce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007B\u0002)\u0001A\u0003%A*A\nce>\\WM\u001d*fcV,7\u000f\u001e\"bi\u000eD\u0007\u0005C\u0004S\u0001\t\u0007I\u0011B*\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/F\u0001U!\t)\u0006L\u0004\u0002\u0017-&\u0011qKA\u0001\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe&\u0011\u0011L\u0017\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014(BA,\u0003\u0011\u0019a\u0006\u0001)A\u0005)\u0006\u00112\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:!\u0011\u0015q\u0006\u0001\"\u0001`\u0003\u001d\u0019H/\u0019:ukB$\u0012\u0001\u0019\t\u0003\u0013\u0005L!A\u0019\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006I\u0002!\taX\u0001\tg\",H\u000fZ8x]\")a\r\u0001C\u0001O\u0006\u0011\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3t)\u0011\u0001\u0007N\u001c9\t\u000b%,\u0007\u0019\u00016\u0002\u0011I,\u0007\u000f\\5dCN\u00042a\u001b7B\u001b\u0005i\u0014BA7>\u0005\r\u0019V\r\u001e\u0005\u0006_\u0016\u0004\r\u0001R\u0001\fi\u0006\u0014x-\u001a;Ti\u0006$X\rC\u0004rKB\u0005\t\u0019\u0001:\u0002\u0013\r\fG\u000e\u001c2bG.\u001c\bC\u0001\ft\u0013\t!(AA\u0005DC2d'-Y2lg\")a\u000f\u0001C\u0001o\u0006\t\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3\u0015\t\u0001D(p\u001f\u0005\u0006sV\u0004\r!Q\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000e\u001a*fa2L7-\u0019\u0005\u0006_V\u0004\r\u0001\u0012\u0005\u0006cV\u0004\rA\u001d\u0005\u0006{\u0002!\tA`\u0001\u001eCJ,\u0017\t\u001c7SKBd\u0017nY1t\r>\u0014Hk\u001c9jG\u0012+G.\u001a;fIR\u0019q0!\u0002\u0011\u0007%\t\t!C\u0002\u0002\u0004)\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\bq\u0004\r!!\u0003\u0002\u000bQ|\u0007/[2\u0011\t\u0005-\u0011\u0011\u0004\b\u0005\u0003\u001b\t)\u0002E\u0002\u0002\u0010)i!!!\u0005\u000b\u0007\u0005Ma!\u0001\u0004=e>|GOP\u0005\u0004\u0003/Q\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001c\u0005u!AB*ue&twMC\u0002\u0002\u0018)Aq!!\t\u0001\t\u0003\t\u0019#A\u0015jg\u0006#H*Z1ti>sWMU3qY&\u001c\u0017-\u00138EK2,G/[8o'R\f'\u000f^3e'R\fG/\u001a\u000b\u0004\u007f\u0006\u0015\u0002\u0002CA\u0004\u0003?\u0001\r!!\u0003\t\u000f\u0005%\u0002\u0001\"\u0001\u0002,\u0005y!/\u001a9mS\u000e\f7/\u00138Ti\u0006$X\rF\u0003k\u0003[\ty\u0003\u0003\u0005\u0002\b\u0005\u001d\u0002\u0019AA\u0005\u0011\u001d\t\t$a\nA\u0002\u0011\u000bQa\u001d;bi\u0016Dq!!\u000e\u0001\t\u0003\t9$A\njg\u0006s\u0017PU3qY&\u001c\u0017-\u00138Ti\u0006$X\rF\u0003\u0000\u0003s\tY\u0004\u0003\u0005\u0002\b\u0005M\u0002\u0019AA\u0005\u0011\u001d\t\t$a\rA\u0002\u0011Cq!a\u0010\u0001\t\u0003\t\t%\u0001\rsKBd\u0017nY1t\u0013:$U\r\\3uS>t7\u000b^1uKN$2A[A\"\u0011!\t9!!\u0010A\u0002\u0005%\u0001bBA$\u0001\u0011%\u0011\u0011J\u0001\u0016CN\u001cXM\u001d;WC2LG\r\u0016:b]NLG/[8o)\u0015\u0001\u00171JA'\u0011\u0019I\u0018Q\ta\u0001\u0003\"1q.!\u0012A\u0002\u0011Ca!!\u0015\u0001\t\u0013y\u0016AF5oSRL\u0017\r\\5{KJ+\u0007\u000f\\5dCN#\u0018\r^3\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X\u0005Q\u0002/\u0019:uSRLwN\\:BgNLwM\\3e)>\u0014%o\\6feR1\u0011\u0011LA6\u0003c\u0002Ra[A.\u0003?J1!!\u0018>\u0005\r\u0019V-\u001d\t\u0005\u0003C\n9'\u0004\u0002\u0002d)\u0019\u0011Q\r\u0003\u0002\r\r|W.\\8o\u0013\u0011\tI'a\u0019\u0003#Q{\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002n\u0005M\u0003\u0019AA8\u0003\u0019!x\u000e]5dgB)1.a\u0017\u0002\n!9\u00111OA*\u0001\u0004I\u0013\u0001\u00032s_.,'/\u00133\t\u0013\u0005]\u0004!%A\u0005\u0002\u0005e\u0014\u0001\b5b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$C-\u001a4bk2$HeM\u000b\u0003\u0003wR3A]A?W\t\ty\b\u0005\u0003\u0002\u0002\u0006-UBAAB\u0015\u0011\t))a\"\u0002\u0013Ut7\r[3dW\u0016$'bAAE\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u00055\u00151\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class ReplicaStateMachine
implements Logging {
    private final KafkaController controller;
    private final ControllerContext controllerContext;
    private final int controllerId;
    private final ZkUtils zkUtils;
    private final Map<PartitionAndReplica, ReplicaState> replicaState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final KafkaController.StateChangeLogger stateChangeLogger;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    private ZkUtils zkUtils() {
        return this.zkUtils;
    }

    private Map<PartitionAndReplica, ReplicaState> replicaState() {
        return this.replicaState;
    }

    private ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    private KafkaController.StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializeReplicaState();
        this.handleStateChanges(this.controllerContext().allLiveReplicas(), OnlineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started replica state machine with initial state -> " + this.replicaState().toString());
    }

    public void shutdown() {
        this.replicaState().clear();
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped replica state machine");
    }

    public void handleStateChanges(Set<PartitionAndReplica> replicas, ReplicaState targetState, Callbacks callbacks) {
        block2: {
            if (!replicas.nonEmpty()) break block2;
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Invoking state change to %s for replicas %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState, replicas.mkString(",")})));
            try {
                this.brokerRequestBatch().newBatch();
                replicas.foreach((Function1 & Serializable & scala.Serializable)r -> {
                    this.handleStateChange(r, targetState, callbacks);
                    return BoxedUnit.UNIT;
                });
                this.brokerRequestBatch().sendRequestsToBrokers(this.controller.epoch());
            }
            catch (Throwable e) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Error while moving some replicas to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            }
        }
    }

    public void handleStateChange(PartitionAndReplica partitionAndReplica, ReplicaState targetState, Callbacks callbacks) {
        block30: {
            String topic = partitionAndReplica.topic();
            int partition = partitionAndReplica.partition();
            int replicaId = partitionAndReplica.replica();
            TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
            ReplicaState currState = (ReplicaState)this.replicaState().getOrElseUpdate((Object)partitionAndReplica, (Function0 & Serializable & scala.Serializable)() -> NonExistentReplica$.MODULE$);
            try {
                Seq replicaAssignment = (Seq)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                this.assertValidTransition(partitionAndReplica, targetState);
                ReplicaState replicaState = targetState;
                if (NewReplica$.MODULE$.equals(replicaState)) {
                    Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt = ReplicationUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.zkUtils(), topic, partition);
                    Option<LeaderIsrAndControllerEpoch> option = leaderIsrAndControllerEpochOpt;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                        if (leaderIsrAndControllerEpoch.leaderAndIsr().leader() == replicaId) {
                            throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Replica %d for partition %s cannot be moved to NewReplica")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition})) + "state as it is being requested to become leader");
                        }
                        this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        throw new MatchError(option);
                    }
                    this.replicaState().put((Object)partitionAndReplica, (Object)NewReplica$.MODULE$);
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                if (ReplicaDeletionStarted$.MODULE$.equals(replicaState)) {
                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionStarted$.MODULE$);
                    this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, true, callbacks.stopReplicaResponseCallback());
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                if (ReplicaDeletionIneligible$.MODULE$.equals(replicaState)) {
                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                if (ReplicaDeletionSuccessful$.MODULE$.equals(replicaState)) {
                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionSuccessful$.MODULE$);
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                if (NonExistentReplica$.MODULE$.equals(replicaState)) {
                    Seq currentAssignedReplicas = (Seq)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                    this.controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$1 -> x$1 == replicaId));
                    this.replicaState().remove((Object)partitionAndReplica);
                    this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                if (OnlineReplica$.MODULE$.equals(replicaState)) {
                    ReplicaState replicaState2 = (ReplicaState)this.replicaState().apply((Object)partitionAndReplica);
                    if (NewReplica$.MODULE$.equals(replicaState2)) {
                        Seq currentAssignedReplicas = (Seq)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                        Object object = !currentAssignedReplicas.contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) ? this.controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaId), Seq$.MODULE$.canBuildFrom())) : BoxedUnit.UNIT;
                        this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Option option = this.controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, leaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                            this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                            this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (None$.MODULE$.equals(option)) {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)option);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                if (OfflineReplica$.MODULE$.equals(replicaState)) {
                    boolean bl;
                    this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId})), topic, partition, false, this.brokerRequestBatch().addStopReplicaRequestForBrokers$default$5());
                    Option option = this.controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                    if (option instanceof Some) {
                        boolean bl2;
                        Option<LeaderIsrAndControllerEpoch> option2 = this.controller.removeReplicaFromIsr(topic, partition, replicaId);
                        if (option2 instanceof Some) {
                            Some some = (Some)option2;
                            LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.value();
                            Seq currentAssignedReplicas = (Seq)this.controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                            if (!this.controller.topicDeletionManager().isPartitionToBeDeleted(topicAndPartition)) {
                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)((Seq)currentAssignedReplicas.filterNot((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$2 -> x$2 == replicaId)), topic, partition, updatedLeaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                            }
                            this.replicaState().put((Object)partitionAndReplica, (Object)OfflineReplica$.MODULE$);
                            this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition, currState, targetState})));
                            bl2 = false;
                        } else if (None$.MODULE$.equals(option2)) {
                            bl2 = true;
                        } else {
                            throw new MatchError(option2);
                        }
                        bl = bl2;
                    } else if (None$.MODULE$.equals(option)) {
                        bl = true;
                    } else {
                        throw new MatchError((Object)option);
                    }
                    boolean leaderAndIsrIsEmpty = bl;
                    if (leaderAndIsrIsEmpty && !this.controller.topicDeletionManager().isPartitionToBeDeleted(topicAndPartition)) {
                        throw new StateChangeFailedException(new StringOps(Predef$.MODULE$.augmentString("Failed to change state of replica %d for partition %s since the leader and isr path in zookeeper is empty")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId), topicAndPartition})));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block30;
                }
                throw new MatchError((Object)replicaState);
            }
            catch (Throwable t) {
                this.stateChangeLogger().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition [%s,%d] from %s to %s failed")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)$this.controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId), topic, BoxesRunTime.boxToInteger((int)partition), currState, targetState})), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
            }
        }
    }

    public Callbacks handleStateChanges$default$3() {
        return new Callbacks.CallbackBuilder().build();
    }

    public boolean areAllReplicasForTopicDeleted(String topic) {
        Set<PartitionAndReplica> replicasForTopic = this.controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(r, this.replicaState().apply(r)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Are all replicas for topic %s deleted %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, replicaStatesForTopic})));
        return replicaStatesForTopic.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$areAllReplicasForTopicDeleted$3(x$3)));
    }

    public boolean isAtLeastOneReplicaInDeletionStartedState(String topic) {
        Set<PartitionAndReplica> replicasForTopic = this.controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic.map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(r, this.replicaState().apply(r)), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable & scala.Serializable)(deletionState, r) -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$isAtLeastOneReplicaInDeletionStartedState$2(BoxesRunTime.unboxToBoolean((Object)deletionState), r))));
    }

    public Set<PartitionAndReplica> replicasInState(String topic, ReplicaState state) {
        return ((MapLike)this.replicaState().filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$replicasInState$1(topic, state, r)))).keySet();
    }

    public boolean isAnyReplicaInState(String topic, ReplicaState state) {
        return this.replicaState().exists((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$isAnyReplicaInState$1(topic, state, r)));
    }

    public Set<PartitionAndReplica> replicasInDeletionStates(String topic) {
        Set deletionStates = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaState[]{ReplicaDeletionStarted$.MODULE$, ReplicaDeletionSuccessful$.MODULE$, ReplicaDeletionIneligible$.MODULE$}));
        return ((MapLike)this.replicaState().filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$replicasInDeletionStates$1(topic, deletionStates, r)))).keySet();
    }

    private void assertValidTransition(PartitionAndReplica partitionAndReplica, ReplicaState targetState) {
        Predef$.MODULE$.assert(targetState.validPreviousStates().contains(this.replicaState().apply((Object)partitionAndReplica)), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Replica %s should be in the %s states before moving to %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partitionAndReplica, targetState.validPreviousStates().mkString(","), targetState})) + new StringOps(Predef$.MODULE$.augmentString(". Instead it is in %s state")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.replicaState().apply((Object)partitionAndReplica)})));
    }

    private void initializeReplicaState() {
        this.controllerContext().partitionReplicaAssignment().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$initializeReplicaState$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            ReplicaStateMachine.$anonfun$initializeReplicaState$2(this, x$4);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<TopicAndPartition> partitionsAssignedToBroker(Seq<String> topics, int brokerId) {
        return ((MapLike)this.controllerContext().partitionReplicaAssignment().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaStateMachine.$anonfun$partitionsAssignedToBroker$1(brokerId, x$5)))).keySet().toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$areAllReplicasForTopicDeleted$3(Tuple2 x$3) {
        Object object = x$3._2();
        ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
        return !(object != null ? !object.equals(replicaDeletionSuccessful$) : replicaDeletionSuccessful$ != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isAtLeastOneReplicaInDeletionStartedState$2(boolean deletionState, Tuple2 r) {
        if (deletionState) return true;
        Object object = r._2();
        ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
        if (object != null) {
            if (!object.equals(replicaDeletionStarted$)) return false;
            return true;
        }
        if (replicaDeletionStarted$ == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$replicasInState$1(String topic$3, ReplicaState state$1, Tuple2 r) {
        if (!((PartitionAndReplica)r._1()).topic().equals(topic$3)) return false;
        Object object = r._2();
        ReplicaState replicaState = state$1;
        if (object != null) {
            if (!object.equals(replicaState)) return false;
            return true;
        }
        if (replicaState == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isAnyReplicaInState$1(String topic$4, ReplicaState state$2, Tuple2 r) {
        if (!((PartitionAndReplica)r._1()).topic().equals(topic$4)) return false;
        Object object = r._2();
        ReplicaState replicaState = state$2;
        if (object != null) {
            if (!object.equals(replicaState)) return false;
            return true;
        }
        if (replicaState == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$replicasInDeletionStates$1(String topic$5, Set deletionStates$1, Tuple2 r) {
        return ((PartitionAndReplica)r._1()).topic().equals(topic$5) && deletionStates$1.contains(r._2());
    }

    public static final /* synthetic */ boolean $anonfun$initializeReplicaState$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Option $anonfun$initializeReplicaState$3(ReplicaStateMachine $this, String topic$6, int partition$2, int replicaId) {
        PartitionAndReplica partitionAndReplica = new PartitionAndReplica(topic$6, partition$2, replicaId);
        return $this.controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)replicaId)) ? $this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$) : $this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$initializeReplicaState$2(ReplicaStateMachine $this, Tuple2 x$4) {
        Tuple2 tuple2 = x$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicAndPartition topicPartition = (TopicAndPartition)tuple2._1();
        Seq assignedReplicas = (Seq)tuple2._2();
        String topic = topicPartition.topic();
        int partition = topicPartition.partition();
        assignedReplicas.foreach((Function1 & Serializable & scala.Serializable)replicaId -> ReplicaStateMachine.$anonfun$initializeReplicaState$3($this, topic, partition, BoxesRunTime.unboxToInt((Object)replicaId)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$partitionsAssignedToBroker$1(int brokerId$1, Tuple2 x$5) {
        return ((SeqLike)x$5._2()).contains((Object)BoxesRunTime.boxToInteger((int)brokerId$1));
    }

    public ReplicaStateMachine(KafkaController controller) {
        this.controller = controller;
        Logging.$init$(this);
        this.controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.zkUtils = this.controllerContext().zkUtils();
        this.replicaState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.stateChangeLogger = KafkaController$.MODULE$.stateChangeLogger();
        this.logIdent_$eq("[Replica state machine on controller " + controller.config().brokerId() + "]: ");
    }
}

