/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TxnIdAndMarkerEntry;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.WriteTxnMarkersRequest;
import org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u0013\tICK]1og\u0006\u001cG/[8o\u001b\u0006\u00148.\u001a:SKF,Xm\u001d;D_6\u0004H.\u001a;j_:D\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u000b\u0019\t1bY8pe\u0012Lg.\u0019;pe*\tq!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001Q!#\b\t\u0003\u0017Ai\u0011\u0001\u0004\u0006\u0003\u001b9\tA\u0001\\1oO*\tq\"\u0001\u0003kCZ\f\u0017BA\t\r\u0005\u0019y%M[3diB\u00111cG\u0007\u0002))\u0011QCF\u0001\bG2LWM\u001c;t\u0015\t9qC\u0003\u0002\u00193\u00051\u0011\r]1dQ\u0016T\u0011AG\u0001\u0004_J<\u0017B\u0001\u000f\u0015\u0005a\u0011V-];fgR\u001cu.\u001c9mKRLwN\u001c%b]\u0012dWM\u001d\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\tQ!\u001e;jYNL!AI\u0010\u0003\u000f1{wmZ5oO\"AA\u0005\u0001B\u0001B\u0003%Q%\u0001\u0005ce>\\WM]%e!\t1\u0013&D\u0001(\u0015\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016(\u0005\rIe\u000e\u001e\u0005\tY\u0001\u0011\t\u0011)A\u0005[\u0005yA\u000f\u001f8Ti\u0006$X-T1oC\u001e,'\u000f\u0005\u0002/_5\t!!\u0003\u00021\u0005\t9BK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM\u001d\u0005\te\u0001\u0011\t\u0011)A\u0005g\u00059B\u000f\u001f8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM\u001d\t\u0003]QJ!!\u000e\u0002\u0003?Q\u0013\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'\u000f\u0003\u00058\u0001\t\u0005\t\u0015!\u00039\u0003U!\bP\\%e\u0003:$W*\u0019:lKJ,e\u000e\u001e:jKN\u00042!\u000f\u001f?\u001b\u0005Q$BA\u001e\u000f\u0003\u0011)H/\u001b7\n\u0005uR$\u0001\u0002'jgR\u0004\"AL \n\u0005\u0001\u0013!a\u0005+y]&#\u0017I\u001c3NCJ\\WM]#oiJL\b\"\u0002\"\u0001\t\u0003\u0019\u0015A\u0002\u001fj]&$h\bF\u0003E\u000b\u001a;\u0005\n\u0005\u0002/\u0001!)A%\u0011a\u0001K!)A&\u0011a\u0001[!)!'\u0011a\u0001g!)q'\u0011a\u0001q!)!\n\u0001C!\u0017\u0006QqN\\\"p[BdW\r^3\u0015\u00051{\u0005C\u0001\u0014N\u0013\tquE\u0001\u0003V]&$\b\"\u0002)J\u0001\u0004\t\u0016\u0001\u0003:fgB|gn]3\u0011\u0005M\u0011\u0016BA*\u0015\u00059\u0019E.[3oiJ+7\u000f]8og\u0016\u0004")
public class TransactionMarkerRequestCompletionHandler
implements RequestCompletionHandler,
Logging {
    private final TransactionStateManager txnStateManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final List<TxnIdAndMarkerEntry> txnIdAndMarkerEntries;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TransactionMarkerRequestCompletionHandler transactionMarkerRequestCompletionHandler = this;
        synchronized (transactionMarkerRequestCompletionHandler) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void onComplete(ClientResponse response) {
        RequestHeader requestHeader = response.requestHeader();
        int correlationId = requestHeader.correlationId();
        if (response.wasDisconnected()) {
            ApiKeys api = ApiKeys.forId((int)requestHeader.apiKey());
            int correlation = requestHeader.correlationId();
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cancelled ", " request ", " with correlation id ", " due to node ", " being disconnected"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{api, requestHeader, BoxesRunTime.boxToInteger((int)correlation), response.destination()})));
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.txnIdAndMarkerEntries).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$2(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)txnIdAndMarker -> {
                TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$3(this, txnIdAndMarker);
                return BoxedUnit.UNIT;
            });
        } else {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received WriteTxnMarker response ", " from node ", " with correlation id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{response, response.destination(), BoxesRunTime.boxToInteger((int)correlationId)})));
            WriteTxnMarkersResponse writeTxnMarkerResponse = (WriteTxnMarkersResponse)response.responseBody();
            JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(this.txnIdAndMarkerEntries).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$9(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)txnIdAndMarker -> {
                TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$10(this, writeTxnMarkerResponse, txnIdAndMarker);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ boolean $anonfun$onComplete$2(TxnIdAndMarkerEntry check$ifrefutable$1) {
        TxnIdAndMarkerEntry txnIdAndMarkerEntry = check$ifrefutable$1;
        boolean bl = txnIdAndMarkerEntry != null;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$onComplete$3(TransactionMarkerRequestCompletionHandler $this, TxnIdAndMarkerEntry txnIdAndMarker) {
        BoxedUnit boxedUnit;
        Errors errors;
        String transactionalId = txnIdAndMarker.txnId();
        WriteTxnMarkersRequest.TxnMarkerEntry txnMarker = txnIdAndMarker.txnMarkerEntry();
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors2 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors2)) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"I am no longer the coordinator for ", "; cancel sending transaction markers ", " to the brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, txnMarker})));
                $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"I am loading the transaction partition that contains ", " which means the current markers have to be obsoleted; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cancel sending transaction markers ", " to the brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMarker})));
            $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled error ", " when fetching current transaction state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unexpectedError})));
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option = (Option)right.value();
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The coordinator still owns the transaction partition for ", ", but there is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no metadata in the cache; this is not expected"})).s((Seq)Nil$.MODULE$));
            }
        }
        if (!bl2) throw new MatchError(either);
        Option option = (Option)right.value();
        if (!(option instanceof Some)) throw new MatchError(either);
        Some some = (Some)option;
        CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
        if (epochAndMetadata.coordinatorEpoch() != txnMarker.coordinatorEpoch()) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transaction coordinator epoch for ", " has changed from ", " to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, BoxesRunTime.boxToInteger((int)txnMarker.coordinatorEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "; cancel sending transaction markers ", " to the brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epochAndMetadata.coordinatorEpoch()), txnMarker})));
            $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            $this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Re-enqueuing ", " transaction markers for transactional id ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMarker.transactionResult(), transactionalId})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"under coordinator epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)txnMarker.coordinatorEpoch())})));
            $this.txnMarkerChannelManager.addTxnMarkersToBrokerQueue(transactionalId, txnMarker.producerId(), txnMarker.producerEpoch(), txnMarker.transactionResult(), txnMarker.coordinatorEpoch(), (scala.collection.immutable.Set<TopicPartition>)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(txnMarker.partitions()).toSet());
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit4 = boxedUnit;
    }

    public static final /* synthetic */ boolean $anonfun$onComplete$9(TxnIdAndMarkerEntry check$ifrefutable$2) {
        TxnIdAndMarkerEntry txnIdAndMarkerEntry = check$ifrefutable$2;
        boolean bl = txnIdAndMarkerEntry != null;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$onComplete$15(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        if (tuple2 == null) return false;
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        Errors error = (Errors)tuple2._2();
        if (topicPartition == null) return false;
        if (error == null) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$onComplete$10(TransactionMarkerRequestCompletionHandler $this, WriteTxnMarkersResponse writeTxnMarkerResponse$1, TxnIdAndMarkerEntry txnIdAndMarker) {
        BoxedUnit boxedUnit;
        Object object;
        Errors errors;
        String transactionalId = txnIdAndMarker.txnId();
        WriteTxnMarkersRequest.TxnMarkerEntry txnMarker = txnIdAndMarker.txnMarkerEntry();
        Map errors2 = writeTxnMarkerResponse$1.errors(txnMarker.producerId());
        if (errors2 == null) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WriteTxnMarkerResponse does not contain expected error map for producer id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)txnMarker.producerId())})));
        }
        boolean bl = false;
        Left left = null;
        boolean bl2 = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = $this.txnStateManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            bl = true;
            left = (Left)either;
            Errors errors3 = (Errors)left.value();
            if (Errors.NOT_COORDINATOR.equals(errors3)) {
                $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"I am no longer the coordinator for ", "; cancel sending transaction markers ", " to the brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, txnMarker})));
                $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        if (bl && Errors.COORDINATOR_LOAD_IN_PROGRESS.equals(errors = (Errors)left.value())) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"I am loading the transaction partition that contains ", " which means the current markers have to be obsoleted; "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"cancel sending transaction markers ", " to the brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMarker})));
            $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
            BoxedUnit boxedUnit3 = BoxedUnit.UNIT;
            return;
        }
        if (bl) {
            Errors unexpectedError = (Errors)left.value();
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unhandled error ", " when fetching current transaction state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{unexpectedError})));
        }
        if (either instanceof Right) {
            bl2 = true;
            right = (Right)either;
            Option option = (Option)right.value();
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The coordinator still owns the transaction partition for ", ", but there is "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"no metadata in the cache; this is not expected"})).s((Seq)Nil$.MODULE$));
            }
        }
        if (!bl2) throw new MatchError(either);
        Option option = (Option)right.value();
        if (!(option instanceof Some)) throw new MatchError(either);
        Some some = (Some)option;
        CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)some.value();
        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
        Set retryPartitions = Set$.MODULE$.empty();
        BooleanRef abortSending = BooleanRef.create((boolean)false);
        if (epochAndMetadata.coordinatorEpoch() != txnMarker.coordinatorEpoch()) {
            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transaction coordinator epoch for ", " has changed from ", " to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, BoxesRunTime.boxToInteger((int)txnMarker.coordinatorEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "; cancel sending transaction markers ", " to the brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epochAndMetadata.coordinatorEpoch()), txnMarker})));
            $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
            abortSending.elem = true;
            object = BoxedUnit.UNIT;
        } else {
            object = txnMetadata.inLock((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> JavaConversions$.MODULE$.deprecated$u0020mapAsScalaMap(errors2).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionMarkerRequestCompletionHandler.$anonfun$onComplete$15(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                BoxedUnit boxedUnit;
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) throw new MatchError((Object)tuple2);
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                Errors error = (Errors)tuple2._2();
                if (topicPartition == null) throw new MatchError((Object)tuple2);
                TopicPartition topicPartition2 = topicPartition;
                if (error == null) throw new MatchError((Object)tuple2);
                Errors errors = error;
                Errors errors2 = errors;
                if (Errors.NONE.equals(errors2)) {
                    txnMetadata.removePartition(topicPartition2);
                    boxedUnit = BoxedUnit.UNIT;
                    return boxedUnit;
                } else {
                    boolean bl = Errors.CORRUPT_MESSAGE.equals(errors2) ? true : (Errors.MESSAGE_TOO_LARGE.equals(errors2) ? true : (Errors.RECORD_LIST_TOO_LARGE.equals(errors2) ? true : Errors.INVALID_REQUIRED_ACKS.equals(errors2)));
                    if (bl) {
                        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received fatal error ", " while sending txn marker for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errors.exceptionName(), transactionalId})));
                    }
                    boolean bl2 = Errors.UNKNOWN_TOPIC_OR_PARTITION.equals(errors2) ? true : (Errors.NOT_LEADER_FOR_PARTITION.equals(errors2) ? true : (Errors.NOT_ENOUGH_REPLICAS.equals(errors2) ? true : (Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND.equals(errors2) ? true : Errors.REQUEST_TIMED_OUT.equals(errors2))));
                    if (bl2) {
                        $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending ", "'s transaction marker for partition ", " has failed with error ", ", retrying "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, topicPartition2, errors.exceptionName()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with current coordinator epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epochAndMetadata.coordinatorEpoch())})));
                        boxedUnit = retryPartitions.$plus$eq((Object)topicPartition2);
                        return boxedUnit;
                    } else {
                        boolean bl3 = Errors.INVALID_PRODUCER_EPOCH.equals(errors2) ? true : Errors.TRANSACTION_COORDINATOR_FENCED.equals(errors2);
                        if (bl3) {
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending ", "'s transaction marker for partition ", " has permanently failed with error ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, topicPartition2, errors.exceptionName()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"with the current coordinator epoch ", "; cancel sending any more transaction markers ", " to the brokers"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)epochAndMetadata.coordinatorEpoch()), txnMarker})));
                            $this.txnMarkerChannelManager.removeMarkersForTxnId(transactionalId);
                            abortSending$1.elem = true;
                            boxedUnit = BoxedUnit.UNIT;
                            return boxedUnit;
                        } else {
                            boolean bl4 = Errors.UNSUPPORTED_FOR_MESSAGE_FORMAT.equals(errors2) ? true : Errors.UNSUPPORTED_VERSION.equals(errors2);
                            if (!bl4) throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected error ", " while sending txn marker for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errors2.exceptionName(), transactionalId})));
                            $this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Sending ", "'s transaction marker from partition ", " has failed with "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{transactionalId, topicPartition2})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", ". This partition will be removed from the set of partitions"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{errors.name()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" waiting for completion"})).s((Seq)Nil$.MODULE$));
                            txnMetadata.removePartition(topicPartition2);
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                }
                return boxedUnit;
            }));
        }
        if (!abortSending.elem) {
            if (retryPartitions.nonEmpty()) {
                $this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Re-enqueuing ", " transaction markers for transactional id ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{txnMarker.transactionResult(), transactionalId})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"under coordinator epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)txnMarker.coordinatorEpoch())})));
                $this.txnMarkerChannelManager.addTxnMarkersToBrokerQueue(transactionalId, txnMarker.producerId(), txnMarker.producerEpoch(), txnMarker.transactionResult(), txnMarker.coordinatorEpoch(), (scala.collection.immutable.Set<TopicPartition>)retryPartitions.toSet());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                $this.txnMarkerChannelManager.completeSendMarkersForTxnId(transactionalId);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit4 = boxedUnit;
    }

    public TransactionMarkerRequestCompletionHandler(int brokerId, TransactionStateManager txnStateManager, TransactionMarkerChannelManager txnMarkerChannelManager, List<TxnIdAndMarkerEntry> txnIdAndMarkerEntries) {
        this.txnStateManager = txnStateManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.txnIdAndMarkerEntries = txnIdAndMarkerEntries;
        Logging.$init$(this);
        this.logIdent_$eq("[Transaction Marker Request Completion Handler " + brokerId + "]: ");
    }
}

