/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantLock;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t%xAB\u0001\u0003\u0011\u0003\u0011\u0001\"A\nUe\u0006t7/Y2uS>tW*\u001a;bI\u0006$\u0018M\u0003\u0002\u0004\t\u0005YAO]1og\u0006\u001cG/[8o\u0015\t)a!A\u0006d_>\u0014H-\u001b8bi>\u0014(\"A\u0004\u0002\u000b-\fgm[1\u0011\u0005%QQ\"\u0001\u0002\u0007\r-\u0011\u0001\u0012\u0001\u0002\r\u0005M!&/\u00198tC\u000e$\u0018n\u001c8NKR\fG-\u0019;b'\tQQ\u0002\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006))!\tAF\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t\u0001\u0002C\u0003\u0019\u0015\u0011\u0005\u0011$A\u0003baBd\u0017\u0010F\u0006\u001b\u0005\u0007\u0013)Ia\"\u0003\n\n-\u0005CA\u0005\u001c\r\u0015Y!\u0001\u0001\u0002\u001d'\rYR\"\b\t\u0003=\u0005j\u0011a\b\u0006\u0003A\u0019\tQ!\u001e;jYNL!AI\u0010\u0003\u000f1{wmZ5oO\"AAe\u0007BC\u0002\u0013\u0005Q%A\bue\u0006t7/Y2uS>t\u0017\r\\%e+\u00051\u0003CA\u0014/\u001d\tAC\u0006\u0005\u0002*\u001f5\t!F\u0003\u0002,+\u00051AH]8pizJ!!L\b\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[=A\u0001BM\u000e\u0003\u0002\u0003\u0006IAJ\u0001\u0011iJ\fgn]1di&|g.\u00197JI\u0002B\u0001\u0002N\u000e\u0003\u0002\u0004%\t!N\u0001\u000baJ|G-^2fe&#W#\u0001\u001c\u0011\u000599\u0014B\u0001\u001d\u0010\u0005\u0011auN\\4\t\u0011iZ\"\u00111A\u0005\u0002m\na\u0002\u001d:pIV\u001cWM]%e?\u0012*\u0017\u000f\u0006\u0002=\u007fA\u0011a\"P\u0005\u0003}=\u0011A!\u00168ji\"9\u0001)OA\u0001\u0002\u00041\u0014a\u0001=%c!A!i\u0007B\u0001B\u0003&a'A\u0006qe>$WoY3s\u0013\u0012\u0004\u0003\u0002\u0003#\u001c\u0005\u0003\u0007I\u0011A#\u0002\u001bA\u0014x\u000eZ;dKJ,\u0005o\\2i+\u00051\u0005C\u0001\bH\u0013\tAuBA\u0003TQ>\u0014H\u000f\u0003\u0005K7\t\u0005\r\u0011\"\u0001L\u0003E\u0001(o\u001c3vG\u0016\u0014X\t]8dQ~#S-\u001d\u000b\u0003y1Cq\u0001Q%\u0002\u0002\u0003\u0007a\t\u0003\u0005O7\t\u0005\t\u0015)\u0003G\u00039\u0001(o\u001c3vG\u0016\u0014X\t]8dQ\u0002B\u0001\u0002U\u000e\u0003\u0002\u0004%\t!U\u0001\ribtG+[7f_V$Xj]\u000b\u0002%B\u0011abU\u0005\u0003)>\u00111!\u00138u\u0011!16D!a\u0001\n\u00039\u0016\u0001\u0005;y]RKW.Z8vi6\u001bx\fJ3r)\ta\u0004\fC\u0004A+\u0006\u0005\t\u0019\u0001*\t\u0011i[\"\u0011!Q!\nI\u000bQ\u0002\u001e=o)&lWm\\;u\u001bN\u0004\u0003\u0002\u0003/\u001c\u0005\u0003\u0007I\u0011A/\u0002\u000bM$\u0018\r^3\u0016\u0003y\u0003\"!C0\n\u0005\u0001\u0014!\u0001\u0005+sC:\u001c\u0018m\u0019;j_:\u001cF/\u0019;f\u0011!\u00117D!a\u0001\n\u0003\u0019\u0017!C:uCR,w\fJ3r)\taD\rC\u0004AC\u0006\u0005\t\u0019\u00010\t\u0011\u0019\\\"\u0011!Q!\ny\u000baa\u001d;bi\u0016\u0004\u0003\u0002\u00035\u001c\u0005\u000b\u0007I\u0011A5\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N,\u0012A\u001b\t\u0004WB\u0014X\"\u00017\u000b\u00055t\u0017aB7vi\u0006\u0014G.\u001a\u0006\u0003_>\t!bY8mY\u0016\u001cG/[8o\u0013\t\tHNA\u0002TKR\u0004\"a]>\u000e\u0003QT!!\u001e<\u0002\r\r|W.\\8o\u0015\t9qO\u0003\u0002ys\u00061\u0011\r]1dQ\u0016T\u0011A_\u0001\u0004_J<\u0017B\u0001?u\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:D\u0001B`\u000e\u0003\u0002\u0003\u0006IA[\u0001\u0011i>\u0004\u0018n\u0019)beRLG/[8og\u0002B\u0011\"!\u0001\u001c\u0005\u0003\u0007I\u0011A\u001b\u0002#QDhn\u0015;beR$\u0016.\\3ti\u0006l\u0007\u000f\u0003\u0006\u0002\u0006m\u0011\t\u0019!C\u0001\u0003\u000f\tQ\u0003\u001e=o'R\f'\u000f\u001e+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000fF\u0002=\u0003\u0013A\u0001\u0002QA\u0002\u0003\u0003\u0005\rA\u000e\u0005\n\u0003\u001bY\"\u0011!Q!\nY\n!\u0003\u001e=o'R\f'\u000f\u001e+j[\u0016\u001cH/Y7qA!\"\u00111BA\t!\rq\u00111C\u0005\u0004\u0003+y!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0013\u0005e1D!a\u0001\n\u0003)\u0014A\u0006;y]2\u000b7\u000f^+qI\u0006$X\rV5nKN$\u0018-\u001c9\t\u0015\u0005u1D!a\u0001\n\u0003\ty\"\u0001\u000euq:d\u0015m\u001d;Va\u0012\fG/\u001a+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000fF\u0002=\u0003CA\u0001\u0002QA\u000e\u0003\u0003\u0005\rA\u000e\u0005\n\u0003KY\"\u0011!Q!\nY\nq\u0003\u001e=o\u0019\u0006\u001cH/\u00169eCR,G+[7fgR\fW\u000e\u001d\u0011)\t\u0005\r\u0012\u0011\u0003\u0005\u0007)m!\t!a\u000b\u0015#i\ti#a\f\u00022\u0005M\u0012QGA\u001c\u0003s\tY\u0004\u0003\u0004%\u0003S\u0001\rA\n\u0005\u0007i\u0005%\u0002\u0019\u0001\u001c\t\r\u0011\u000bI\u00031\u0001G\u0011\u0019\u0001\u0016\u0011\u0006a\u0001%\"1A,!\u000bA\u0002yCa\u0001[A\u0015\u0001\u0004Q\u0007\"CA\u0001\u0003S\u0001\n\u00111\u00017\u0011\u001d\tI\"!\u000bA\u0002YB\u0011\"a\u0010\u001c\u0001\u0004%\t!!\u0011\u0002\u0019A,g\u000eZ5oON#\u0018\r^3\u0016\u0005\u0005\r\u0003\u0003\u0002\b\u0002FyK1!a\u0012\u0010\u0005\u0019y\u0005\u000f^5p]\"I\u00111J\u000eA\u0002\u0013\u0005\u0011QJ\u0001\u0011a\u0016tG-\u001b8h'R\fG/Z0%KF$2\u0001PA(\u0011%\u0001\u0015\u0011JA\u0001\u0002\u0004\t\u0019\u0005\u0003\u0005\u0002Tm\u0001\u000b\u0015BA\"\u00035\u0001XM\u001c3j]\u001e\u001cF/\u0019;fA!Q\u0011qK\u000eC\u0002\u0013\u0005!!!\u0017\u0002\t1|7m[\u000b\u0003\u00037\u0002B!!\u0018\u0002p5\u0011\u0011q\f\u0006\u0005\u0003C\n\u0019'A\u0003m_\u000e\\7O\u0003\u0003\u0002f\u0005\u001d\u0014AC2p]\u000e,(O]3oi*!\u0011\u0011NA6\u0003\u0011)H/\u001b7\u000b\u0005\u00055\u0014\u0001\u00026bm\u0006LA!!\u001d\u0002`\ti!+Z3oiJ\fg\u000e\u001e'pG.D\u0001\"!\u001e\u001cA\u0003%\u00111L\u0001\u0006Y>\u001c7\u000e\t\u0005\b\u0003sZB\u0011AA>\u0003\u0019Ig\u000eT8dWV!\u0011QPAB)\u0011\ty(!&\u0011\t\u0005\u0005\u00151\u0011\u0007\u0001\t!\t))a\u001eC\u0002\u0005\u001d%!\u0001+\u0012\t\u0005%\u0015q\u0012\t\u0004\u001d\u0005-\u0015bAAG\u001f\t9aj\u001c;iS:<\u0007c\u0001\b\u0002\u0012&\u0019\u00111S\b\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0018\u0006]D\u00111\u0001\u0002\u001a\u0006\u0019a-\u001e8\u0011\u000b9\tY*a \n\u0007\u0005uuB\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\t\tk\u0007C\u0001\u0003G\u000bQ\"\u00193e!\u0006\u0014H/\u001b;j_:\u001cHc\u0001\u001f\u0002&\"A\u0011qUAP\u0001\u0004\tI+\u0001\u0006qCJ$\u0018\u000e^5p]N\u0004R!a+\u0002.Jl\u0011A\\\u0005\u0003c:Dq!!-\u001c\t\u0003\t\u0019,A\bsK6|g/\u001a)beRLG/[8o)\ra\u0014Q\u0017\u0005\b\u0003o\u000by\u000b1\u0001s\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!a/\u001c\t\u0003\ti,\u0001\tqe\u0016\u0004\u0018M]3O_R\u0013\u0018M\\:jiR\u0011\u0011q\u0018\t\u0004\u0013\u0005\u0005\u0017bAAb\u0005\t\u0011B\u000b\u001f8Ue\u0006t7/\u001b;NKR\fG-\u0019;b\u0011\u001d\t9m\u0007C\u0001\u0003{\u000b\u0011\u0004\u001d:fa\u0006\u0014XMR3oG\u0016\u0004&o\u001c3vG\u0016\u0014X\t]8dQ\"9\u00111Z\u000e\u0005\u0002\u00055\u0017!\b9sKB\f'/Z%oGJ,W.\u001a8u!J|G-^2fe\u0016\u0003xn\u00195\u0015\r\u0005}\u0016qZAj\u0011\u001d\t\t.!3A\u0002I\u000bqB\\3x)btG+[7f_V$Xj\u001d\u0005\b\u0003+\fI\r1\u00017\u0003=)\b\u000fZ1uKRKW.Z:uC6\u0004\bbBAm7\u0011\u0005\u00111\\\u0001\u001aaJ,\u0007/\u0019:f!J|G-^2fe&#'k\u001c;bi&|g\u000e\u0006\u0005\u0002@\u0006u\u0017\u0011]Ar\u0011\u001d\ty.a6A\u0002Y\nQB\\3x!J|G-^2fe&#\u0007bBAi\u0003/\u0004\rA\u0015\u0005\b\u0003+\f9\u000e1\u00017\u0011\u001d\t9o\u0007C\u0001\u0003S\fA\u0003\u001d:fa\u0006\u0014X-\u00113e!\u0006\u0014H/\u001b;j_:\u001cHCBA`\u0003W\fI\u0010\u0003\u0005\u0002n\u0006\u0015\b\u0019AAx\u0003Q\tG\rZ3e)>\u0004\u0018n\u0019)beRLG/[8ogB)\u0011\u0011_A|e6\u0011\u00111\u001f\u0006\u0004\u0003kt\u0017!C5n[V$\u0018M\u00197f\u0013\r\t\u00181\u001f\u0005\b\u0003+\f)\u000f1\u00017\u0011\u001d\tip\u0007C\u0001\u0003\u007f\fA\u0003\u001d:fa\u0006\u0014X-\u00112peR|%oQ8n[&$HCBA`\u0005\u0003\u0011)\u0001C\u0004\u0003\u0004\u0005m\b\u0019\u00010\u0002\u00119,wo\u0015;bi\u0016Dq!!6\u0002|\u0002\u0007a\u0007C\u0004\u0003\nm!\tAa\u0003\u0002\u001fA\u0014X\r]1sK\u000e{W\u000e\u001d7fi\u0016$B!a0\u0003\u000e!9\u0011Q\u001bB\u0004\u0001\u00041\u0004b\u0002B\t7\u0011\u0005\u0011QX\u0001\faJ,\u0007/\u0019:f\t\u0016\fG\rC\u0004\u0003\u0016m!\tAa\u0006\u00021%\u001c\bK]8ek\u000e,'/\u00129pG\",\u0005\u0010[1vgR,G-\u0006\u0002\u0003\u001aA\u0019aBa\u0007\n\u0007\tuqBA\u0004C_>dW-\u00198\t\u000f\t\u00052\u0004\"\u0003\u0003\u0018\u0005)\u0002.Y:QK:$\u0017N\\4Ue\u0006t7/Y2uS>t\u0007b\u0002B\u00137\u0011%!qE\u0001\u0014aJ,\u0007/\u0019:f)J\fgn]5uS>tGk\u001c\u000b\u0011\u0003\u007f\u0013ICa\u000b\u0003.\tE\"1\u0007B\u001c\u0005wAqAa\u0001\u0003$\u0001\u0007a\fC\u0004\u0002`\n\r\u0002\u0019\u0001\u001c\t\u000f\t=\"1\u0005a\u0001\r\u0006Aa.Z<Fa>\u001c\u0007\u000eC\u0004\u0002R\n\r\u0002\u0019\u0001*\t\u0011\tU\"1\u0005a\u0001\u0003_\f!C\\3x)>\u0004\u0018n\u0019)beRLG/[8og\"9!\u0011\bB\u0012\u0001\u00041\u0014\u0001\u00068foRChn\u0015;beR$\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0002V\n\r\u0002\u0019\u0001\u001c\t\u000f\t}2\u0004\"\u0001\u0003B\u0005!2m\\7qY\u0016$X\r\u0016:b]NLG/[8o)>$2\u0001\u0010B\"\u0011!\u0011)E!\u0010A\u0002\u0005}\u0016a\u0004;sC:\u001c\u0018\u000e^'fi\u0006$\u0017\r^1\t\u000f\t%3\u0004\"\u0003\u0003L\u0005\u0011b/\u00197jIB\u0013x\u000eZ;dKJ,\u0005o\\2i)\u0011\u0011IB!\u0014\t\u0011\t\u0015#q\ta\u0001\u0003\u007fCqA!\u0015\u001c\t\u0013\u0011\u0019&\u0001\fwC2LG\r\u0015:pIV\u001cWM]#q_\u000eD')^7q)\u0011\u0011IB!\u0016\t\u0011\t\u0015#q\na\u0001\u0003\u007fCqA!\u0017\u001c\t\u0013\u0011Y&A\u000euQJ|wo\u0015;bi\u0016$&/\u00198tSRLwN\u001c$bS2,(/\u001a\u000b\u0004y\tu\u0003\u0002\u0003B0\u0005/\u0002\r!a0\u0002%QDh\u000e\u0016:b]NLG/T3uC\u0012\fG/\u0019\u0005\b\u0005GZB\u0011\u0001B\f\u0003m\u0001XM\u001c3j]\u001e$&/\u00198tSRLwN\\%o!J|wM]3tg\"9!qM\u000e\u0005B\t%\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0019BqA!\u001c\u001c\t\u0003\u0012y'\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00053\u0011\t\b\u0003\u0005\u0003t\t-\u0004\u0019AAH\u0003\u0011!\b.\u0019;\t\u000f\t]4\u0004\"\u0011\u0003z\u0005A\u0001.Y:i\u0007>$W\rF\u0001SQ\rY\"Q\u0010\t\u0004=\t}\u0014b\u0001BA?\tian\u001c8uQJ,\u0017\rZ:bM\u0016DQ\u0001J\fA\u0002\u0019BQ\u0001N\fA\u0002YBQ\u0001R\fA\u0002\u0019CQ\u0001U\fA\u0002ICaA!$\u0018\u0001\u00041\u0014!\u0003;j[\u0016\u001cH/Y7q\u0011\u0019A\"\u0002\"\u0001\u0003\u0012Ri!Da%\u0003\u0016\n]%\u0011\u0014BN\u0005;Ca\u0001\nBH\u0001\u00041\u0003B\u0002\u001b\u0003\u0010\u0002\u0007a\u0007\u0003\u0004E\u0005\u001f\u0003\rA\u0012\u0005\u0007!\n=\u0005\u0019\u0001*\t\rq\u0013y\t1\u0001_\u0011\u001d\u0011iIa$A\u0002YBqA!)\u000b\t\u0003\u0011\u0019+A\u0006csR,Gk\\*uCR,Gc\u00010\u0003&\"A!q\u0015BP\u0001\u0004\u0011I+\u0001\u0003csR,\u0007c\u0001\b\u0003,&\u0019!QV\b\u0003\t\tKH/\u001a\u0005\b\u0005cSA\u0011\u0001BZ\u0003EI7OV1mS\u0012$&/\u00198tSRLwN\u001c\u000b\u0007\u00053\u0011)L!/\t\u000f\t]&q\u0016a\u0001=\u0006Aq\u000e\u001c3Ti\u0006$X\rC\u0004\u0003\u0004\t=\u0006\u0019\u00010\t\u0013\tu&B1A\u0005\n\t}\u0016a\u0005<bY&$\u0007K]3wS>,8o\u0015;bi\u0016\u001cXC\u0001Ba!\u00199#1\u00190\u0003H&\u0019!Q\u0019\u0019\u0003\u00075\u000b\u0007\u000f\u0005\u0003(\u0005\u0013t\u0016BA91\u0011!\u0011iM\u0003Q\u0001\n\t\u0005\u0017\u0001\u0006<bY&$\u0007K]3wS>,8o\u0015;bi\u0016\u001c\b\u0005C\u0005\u0003R*\t\n\u0011\"\u0001\u0003T\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"A!6+\u0007Y\u00129n\u000b\u0002\u0003ZB!!1\u001cBs\u001b\t\u0011iN\u0003\u0003\u0003`\n\u0005\u0018!C;oG\",7m[3e\u0015\r\u0011\u0019oD\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bt\u0005;\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class TransactionMetadata
implements Logging {
    private final String transactionalId;
    private long producerId;
    private short producerEpoch;
    private int txnTimeoutMs;
    private TransactionState state;
    private final scala.collection.mutable.Set<TopicPartition> topicPartitions;
    private volatile long txnStartTimestamp;
    private volatile long txnLastUpdateTimestamp;
    private Option<TransactionState> pendingState;
    private final ReentrantLock lock;
    private final String loggerName;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static long $lessinit$greater$default$7() {
        return TransactionMetadata$.MODULE$.$lessinit$greater$default$7();
    }

    public static boolean isValidTransition(TransactionState transactionState, TransactionState transactionState2) {
        return TransactionMetadata$.MODULE$.isValidTransition(transactionState, transactionState2);
    }

    public static TransactionState byteToState(byte by) {
        return TransactionMetadata$.MODULE$.byteToState(by);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, TransactionState transactionState, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, transactionState, l2);
    }

    public static TransactionMetadata apply(String string, long l, short s, int n, long l2) {
        return TransactionMetadata$.MODULE$.apply(string, l, s, n, l2);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TransactionMetadata transactionMetadata = this;
        synchronized (transactionMetadata) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public long producerId() {
        return this.producerId;
    }

    public void producerId_$eq(long x$1) {
        this.producerId = x$1;
    }

    public short producerEpoch() {
        return this.producerEpoch;
    }

    public void producerEpoch_$eq(short x$1) {
        this.producerEpoch = x$1;
    }

    public int txnTimeoutMs() {
        return this.txnTimeoutMs;
    }

    public void txnTimeoutMs_$eq(int x$1) {
        this.txnTimeoutMs = x$1;
    }

    public TransactionState state() {
        return this.state;
    }

    public void state_$eq(TransactionState x$1) {
        this.state = x$1;
    }

    public scala.collection.mutable.Set<TopicPartition> topicPartitions() {
        return this.topicPartitions;
    }

    public long txnStartTimestamp() {
        return this.txnStartTimestamp;
    }

    public void txnStartTimestamp_$eq(long x$1) {
        this.txnStartTimestamp = x$1;
    }

    public long txnLastUpdateTimestamp() {
        return this.txnLastUpdateTimestamp;
    }

    public void txnLastUpdateTimestamp_$eq(long x$1) {
        this.txnLastUpdateTimestamp = x$1;
    }

    public Option<TransactionState> pendingState() {
        return this.pendingState;
    }

    public void pendingState_$eq(Option<TransactionState> x$1) {
        this.pendingState = x$1;
    }

    public ReentrantLock lock() {
        return this.lock;
    }

    public <T> T inLock(Function0<T> fun) {
        return CoreUtils$.MODULE$.inLock(this.lock(), fun);
    }

    public void addPartitions(Set<TopicPartition> partitions) {
        this.topicPartitions().$plus$plus$eq(partitions);
    }

    public void removePartition(TopicPartition topicPartition) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        if (transactionState == null ? prepareCommit$ != null : !transactionState.equals(prepareCommit$)) {
            TransactionState transactionState2 = this.state();
            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
            if (transactionState2 == null ? prepareAbort$ != null : !transactionState2.equals(prepareAbort$)) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Transaction metadata's current state is ", ", and its pending state is ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state(), this.pendingState()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"while trying to remove partitions whose txn marker has been sent, this is not expected"})).s((Seq)Nil$.MODULE$));
            }
        }
        this.topicPartitions().$minus$eq((Object)topicPartition);
    }

    public TxnTransitMetadata prepareNoTransit() {
        return new TxnTransitMetadata(this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), this.state(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareFenceProducerEpoch() {
        if (this.producerEpoch() == Short.MAX_VALUE) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot fence producer with epoch equal to Short.MaxValue since this would overflow"})).s((Seq)Nil$.MODULE$));
        }
        return this.prepareTransitionTo(PrepareEpochFence$.MODULE$, this.producerId(), (short)(this.producerEpoch() + 1), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public TxnTransitMetadata prepareIncrementProducerEpoch(int newTxnTimeoutMs, long updateTimestamp) {
        if (this.isProducerEpochExhausted()) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot allocate any more producer epochs for producerId ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})));
        }
        int nextEpoch = this.producerEpoch() == -1 ? 0 : this.producerEpoch() + 1;
        return this.prepareTransitionTo(Empty$.MODULE$, this.producerId(), (short)nextEpoch, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareProducerIdRotation(long newProducerId, int newTxnTimeoutMs, long updateTimestamp) {
        if (this.hasPendingTransaction()) {
            throw new IllegalStateException("Cannot rotate producer ids while a transaction is still pending");
        }
        return this.prepareTransitionTo(Empty$.MODULE$, newProducerId, (short)0, newTxnTimeoutMs, (scala.collection.immutable.Set<TopicPartition>)Set$.MODULE$.empty(), -1L, updateTimestamp);
    }

    public TxnTransitMetadata prepareAddPartitions(scala.collection.immutable.Set<TopicPartition> addedTopicPartitions, long updateTimestamp) {
        TransactionState transactionState = this.state();
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteAbort$.MODULE$.equals(transactionState) ? true : CompleteCommit$.MODULE$.equals(transactionState));
        long l = bl ? updateTimestamp : this.txnStartTimestamp();
        long newTxnStartTimestamp = l;
        return this.prepareTransitionTo(Ongoing$.MODULE$, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().$plus$plus(addedTopicPartitions).toSet(), newTxnStartTimestamp, updateTimestamp);
    }

    public TxnTransitMetadata prepareAbortOrCommit(TransactionState newState, long updateTimestamp) {
        return this.prepareTransitionTo(newState, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)this.topicPartitions().toSet(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareComplete(long updateTimestamp) {
        TransactionState transactionState = this.state();
        PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
        Product newState = !(transactionState != null ? !transactionState.equals(prepareCommit$) : prepareCommit$ != null) ? CompleteCommit$.MODULE$ : CompleteAbort$.MODULE$;
        return this.prepareTransitionTo((TransactionState)newState, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), updateTimestamp);
    }

    public TxnTransitMetadata prepareDead() {
        return this.prepareTransitionTo(Dead$.MODULE$, this.producerId(), this.producerEpoch(), this.txnTimeoutMs(), (scala.collection.immutable.Set<TopicPartition>)Predef$.MODULE$.Set().empty(), this.txnStartTimestamp(), this.txnLastUpdateTimestamp());
    }

    public boolean isProducerEpochExhausted() {
        return this.producerEpoch() >= 32766;
    }

    private boolean hasPendingTransaction() {
        TransactionState transactionState = this.state();
        boolean bl = Ongoing$.MODULE$.equals(transactionState) ? true : (PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState));
        boolean bl2 = bl;
        return bl2;
    }

    private TxnTransitMetadata prepareTransitionTo(TransactionState newState, long newProducerId, short newEpoch, int newTxnTimeoutMs, scala.collection.immutable.Set<TopicPartition> newTopicPartitions, long newTxnStartTimestamp, long updateTimestamp) {
        if (this.pendingState().isDefined()) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Preparing transaction state transition to ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"while it already a pending state ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pendingState().get()})));
        }
        if (newProducerId < 0L) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal new producer id ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)newProducerId)})));
        }
        if (newEpoch < 0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal new producer epoch ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)newEpoch)})));
        }
        if (!((SetLike)TransactionMetadata$.MODULE$.kafka$coordinator$transaction$TransactionMetadata$$validPreviousStates().apply((Object)newState)).contains((Object)this.state())) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Preparing transaction state transition to ", " failed since the target state"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " is not a valid previous state of the current state ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newState, this.state()})));
        }
        TxnTransitMetadata transitMetadata = new TxnTransitMetadata(newProducerId, newEpoch, newTxnTimeoutMs, newState, newTopicPartitions, newTxnStartTimestamp, updateTimestamp);
        this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " prepare transition from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), this.state(), transitMetadata})));
        this.pendingState_$eq((Option<TransactionState>)new Some((Object)newState));
        return transitMetadata;
    }

    public void completeTransitionTo(TxnTransitMetadata transitMetadata) {
        TransactionState toState;
        TransactionState transactionState = toState = (TransactionState)this.pendingState().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "'s transition to ", " failed since pendingState is not defined: this should not happen"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this, transitMetadata})));
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId()})) + "completing transaction state transition while it does not have a pending state");
        });
        TransactionState transactionState2 = transitMetadata.txnState();
        if (transactionState == null ? transactionState2 != null : !transactionState.equals(transactionState2)) {
            this.throwStateTransitionFailure(transitMetadata);
        } else {
            TransactionState transactionState3 = toState;
            if (Empty$.MODULE$.equals(transactionState3)) {
                BoxedUnit boxedUnit;
                if (this.producerEpoch() != transitMetadata.producerEpoch() && !this.validProducerEpochBump(transitMetadata) || transitMetadata.topicPartitions().nonEmpty() || transitMetadata.txnStartTimestamp() != -1L) {
                    this.throwStateTransitionFailure(transitMetadata);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.txnTimeoutMs_$eq(transitMetadata.txnTimeoutMs());
                    this.producerEpoch_$eq(transitMetadata.producerEpoch());
                    this.producerId_$eq(transitMetadata.producerId());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (Ongoing$.MODULE$.equals(transactionState3)) {
                BoxedUnit boxedUnit;
                if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().subsetOf(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() > transitMetadata.txnStartTimestamp()) {
                    this.throwStateTransitionFailure(transitMetadata);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                    this.addPartitions((Set<TopicPartition>)transitMetadata.topicPartitions());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
            } else {
                boolean bl = PrepareAbort$.MODULE$.equals(transactionState3) ? true : PrepareCommit$.MODULE$.equals(transactionState3);
                if (bl) {
                    BoxedUnit boxedUnit;
                    if (!this.validProducerEpoch(transitMetadata) || !this.topicPartitions().toSet().equals(transitMetadata.topicPartitions()) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || this.txnStartTimestamp() != transitMetadata.txnStartTimestamp()) {
                        this.throwStateTransitionFailure(transitMetadata);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit4 = boxedUnit;
                } else {
                    boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState3) ? true : CompleteCommit$.MODULE$.equals(transactionState3);
                    if (bl2) {
                        BoxedUnit boxedUnit;
                        if (!this.validProducerEpoch(transitMetadata) || this.txnTimeoutMs() != transitMetadata.txnTimeoutMs() || transitMetadata.txnStartTimestamp() == -1L) {
                            this.throwStateTransitionFailure(transitMetadata);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.txnStartTimestamp_$eq(transitMetadata.txnStartTimestamp());
                            this.topicPartitions().clear();
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit5 = boxedUnit;
                    } else if (PrepareEpochFence$.MODULE$.equals(transactionState3)) {
                        this.throwStateTransitionFailure(transitMetadata);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        if (Dead$.MODULE$.equals(transactionState3)) {
                            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " is trying to complete a transition to "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ". This means that the transactionalId was being expired, and the only acceptable completion of "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{toState})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"this operation is to remove the transaction metadata from the cache, not to persist the ", " in the log."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{toState})));
                        }
                        throw new MatchError((Object)transactionState3);
                    }
                }
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " complete transition from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), this.state(), transitMetadata})));
            this.txnLastUpdateTimestamp_$eq(transitMetadata.txnLastUpdateTimestamp());
            this.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
            this.state_$eq(toState);
        }
    }

    private boolean validProducerEpoch(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() && transitProducerId == this.producerId();
    }

    private boolean validProducerEpochBump(TxnTransitMetadata transitMetadata) {
        short transitEpoch = transitMetadata.producerEpoch();
        long transitProducerId = transitMetadata.producerId();
        return transitEpoch == this.producerEpoch() + 1 || transitEpoch == 0 && transitProducerId != this.producerId();
    }

    private void throwStateTransitionFailure(TxnTransitMetadata txnTransitMetadata) {
        this.fatal((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "'s transition to ", " failed: this should not happen"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toString(), txnTransitMetadata})));
        throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"TransactionalId ", " failed transition to state ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), txnTransitMetadata})) + "due to unexpected metadata");
    }

    public boolean pendingTransitionInProgress() {
        return this.pendingState().isDefined();
    }

    public String toString() {
        return "TransactionMetadata(" + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transactionalId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerId=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.producerId())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"producerEpoch=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)this.producerEpoch())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnTimeoutMs=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.txnTimeoutMs())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"state=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pendingState=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pendingState()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topicPartitions=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topicPartitions()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnStartTimestamp=", ", "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.txnStartTimestamp())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"txnLastUpdateTimestamp=", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp())}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        Object object = that;
        if (!(object instanceof TransactionMetadata)) return false;
        TransactionMetadata transactionMetadata = (TransactionMetadata)object;
        String string = this.transactionalId();
        String string2 = transactionMetadata.transactionalId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.producerId() != transactionMetadata.producerId()) return false;
        if (this.producerEpoch() != transactionMetadata.producerEpoch()) return false;
        if (this.txnTimeoutMs() != transactionMetadata.txnTimeoutMs()) return false;
        if (!this.state().equals(transactionMetadata.state())) return false;
        if (!this.topicPartitions().equals(transactionMetadata.topicPartitions())) return false;
        if (this.txnStartTimestamp() != transactionMetadata.txnStartTimestamp()) return false;
        if (this.txnLastUpdateTimestamp() != transactionMetadata.txnLastUpdateTimestamp()) return false;
        return true;
    }

    public int hashCode() {
        Seq fields = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.transactionalId(), BoxesRunTime.boxToLong((long)this.producerId()), BoxesRunTime.boxToShort((short)this.producerEpoch()), BoxesRunTime.boxToInteger((int)this.txnTimeoutMs()), this.state(), this.topicPartitions(), BoxesRunTime.boxToLong((long)this.txnStartTimestamp()), BoxesRunTime.boxToLong((long)this.txnLastUpdateTimestamp())}));
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)fields.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.hashCode()), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(a, b) -> 31 * a + b));
    }

    public TransactionMetadata(String transactionalId, long producerId, short producerEpoch, int txnTimeoutMs, TransactionState state, scala.collection.mutable.Set<TopicPartition> topicPartitions, long txnStartTimestamp, long txnLastUpdateTimestamp) {
        this.transactionalId = transactionalId;
        this.producerId = producerId;
        this.producerEpoch = producerEpoch;
        this.txnTimeoutMs = txnTimeoutMs;
        this.state = state;
        this.topicPartitions = topicPartitions;
        this.txnStartTimestamp = txnStartTimestamp;
        this.txnLastUpdateTimestamp = txnLastUpdateTimestamp;
        Logging.$init$(this);
        this.pendingState = None$.MODULE$;
        this.lock = new ReentrantLock();
    }
}

