/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused$;
import kafka.log.LogCleaningState;
import kafka.log.LogToClean;
import kafka.metrics.KafkaMetricsGroup;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t=c!B\u0001\u0003\u0001\t1!!\u0005'pO\u000ecW-\u00198fe6\u000bg.Y4fe*\u00111\u0001B\u0001\u0004Y><'\"A\u0003\u0002\u000b-\fgm[1\u0014\t\u00019Qb\u0005\t\u0003\u0011-i\u0011!\u0003\u0006\u0002\u0015\u0005)1oY1mC&\u0011A\"\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u00059\tR\"A\b\u000b\u0005A!\u0011!B;uS2\u001c\u0018B\u0001\n\u0010\u0005\u001daunZ4j]\u001e\u0004\"\u0001F\f\u000e\u0003UQ!A\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0001$\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\u000f1|w\rR5sg\u000e\u0001Q#A\u000f\u0011\u0007!q\u0002%\u0003\u0002 \u0013\t)\u0011I\u001d:bsB\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0003S>T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t!a)\u001b7f\u0011!I\u0003A!A!\u0002\u0013i\u0012\u0001\u00037pO\u0012K'o\u001d\u0011\t\u0011-\u0002!Q1A\u0005\u00021\nA\u0001\\8hgV\tQ\u0006\u0005\u0003\u000f]AZ\u0014BA\u0018\u0010\u0005\u0011\u0001vn\u001c7\u0011\u0005EJT\"\u0001\u001a\u000b\u0005M\"\u0014AB2p[6|gN\u0003\u0002\u0006k)\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ$G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0011\u0005qjT\"\u0001\u0002\n\u0005y\u0012!a\u0001'pO\"A\u0001\t\u0001B\u0001B\u0003%Q&A\u0003m_\u001e\u001c\b\u0005C\u0003C\u0001\u0011\u00051)\u0001\u0004=S:LGO\u0010\u000b\u0004\t\u00163\u0005C\u0001\u001f\u0001\u0011\u0015Q\u0012\t1\u0001\u001e\u0011\u0015Y\u0013\t1\u0001.\u0011\u001dA\u0005A1A\u0005B%\u000b!\u0002\\8hO\u0016\u0014h*Y7f+\u0005Q\u0005CA&O\u001b\u0005a%BA'%\u0003\u0011a\u0017M\\4\n\u0005=c%AB*ue&tw\r\u0003\u0004R\u0001\u0001\u0006IAS\u0001\fY><w-\u001a:OC6,\u0007\u0005\u0003\u0005T\u0001\t\u0007I\u0011\u0001\u0002J\u0003QygMZ:fi\u000eCWmY6q_&tGOR5mK\"1Q\u000b\u0001Q\u0001\n)\u000bQc\u001c4gg\u0016$8\t[3dWB|\u0017N\u001c;GS2,\u0007\u0005C\u0004X\u0001\t\u0007I\u0011\u0002-\u0002\u0017\rDWmY6q_&tGo]\u000b\u00023B!!l\u0018\u0011b\u001b\u0005Y&B\u0001/^\u0003%IW.\\;uC\ndWM\u0003\u0002_\u0013\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0001\\&aA'baB\u0011!MZ\u0007\u0002G*\u0011q\u000b\u001a\u0006\u0003K\u0012\taa]3sm\u0016\u0014\u0018BA4d\u0005QyeMZ:fi\u000eCWmY6q_&tGOR5mK\"1\u0011\u000e\u0001Q\u0001\ne\u000bAb\u00195fG.\u0004x.\u001b8ug\u0002Bqa\u001b\u0001C\u0002\u0013%A.\u0001\u0006j]B\u0013xn\u001a:fgN,\u0012!\u001c\t\u0005]F\u00044/D\u0001p\u0015\t\u0001X,A\u0004nkR\f'\r\\3\n\u0005I|'a\u0002%bg\"l\u0015\r\u001d\t\u0003yQL!!\u001e\u0002\u0003!1{wm\u00117fC:LgnZ*uCR,\u0007BB<\u0001A\u0003%Q.A\u0006j]B\u0013xn\u001a:fgN\u0004\u0003bB=\u0001\u0005\u0004%IA_\u0001\u0005Y>\u001c7.F\u0001|!\ra\u0018qA\u0007\u0002{*\u0011ap`\u0001\u0006Y>\u001c7n\u001d\u0006\u0005\u0003\u0003\t\u0019!\u0001\u0006d_:\u001cWO\u001d:f]RT1!!\u0002%\u0003\u0011)H/\u001b7\n\u0007\u0005%QPA\u0007SK\u0016tGO]1oi2{7m\u001b\u0005\b\u0003\u001b\u0001\u0001\u0015!\u0003|\u0003\u0015awnY6!\u0011%\t\t\u0002\u0001b\u0001\n\u0013\t\u0019\"\u0001\nqCV\u001cX\rZ\"mK\u0006t\u0017N\\4D_:$WCAA\u000b!\ra\u0018qC\u0005\u0004\u00033i(!C\"p]\u0012LG/[8o\u0011!\ti\u0002\u0001Q\u0001\n\u0005U\u0011a\u00059bkN,Gm\u00117fC:LgnZ\"p]\u0012\u0004\u0003\"CA\u0011\u0001\u0001\u0007I\u0011BA\u0012\u0003e!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8\u0016\u0005\u0005\u0015\u0002c\u0001\u0005\u0002(%\u0019\u0011\u0011F\u0005\u0003\r\u0011{WO\u00197f\u0011%\ti\u0003\u0001a\u0001\n\u0013\ty#A\u000feSJ$\u0018.Z:u\u0019><7\t\\3b]\u0006\u0014G.\u001a*bi&|w\fJ3r)\u0011\t\t$a\u000e\u0011\u0007!\t\u0019$C\u0002\u00026%\u0011A!\u00168ji\"Q\u0011\u0011HA\u0016\u0003\u0003\u0005\r!!\n\u0002\u0007a$\u0013\u0007\u0003\u0005\u0002>\u0001\u0001\u000b\u0015BA\u0013\u0003i!\u0017N\u001d;jKN$Hj\\4DY\u0016\fg.\u00192mKJ\u000bG/[8!Q\u0011\tY$!\u0011\u0011\u0007!\t\u0019%C\u0002\u0002F%\u0011\u0001B^8mCRLG.\u001a\u0005\n\u0003\u0013\u0002\u0001\u0019!C\u0005\u0003\u0017\nQ\u0002^5nK>3G*Y:u%VtWCAA'!\rA\u0011qJ\u0005\u0004\u0003#J!\u0001\u0002'p]\u001eD\u0011\"!\u0016\u0001\u0001\u0004%I!a\u0016\u0002#QLW.Z(g\u0019\u0006\u001cHOU;o?\u0012*\u0017\u000f\u0006\u0003\u00022\u0005e\u0003BCA\u001d\u0003'\n\t\u00111\u0001\u0002N!A\u0011Q\f\u0001!B\u0013\ti%\u0001\buS6,wJ\u001a'bgR\u0014VO\u001c\u0011)\t\u0005m\u0013\u0011\t\u0005\b\u0003G\u0002A\u0011AA3\u0003U\tG\u000e\\\"mK\u0006tWM]\"iK\u000e\\\u0007o\\5oiN,\"!a\u001a\u0011\u000f\u0005%\u0014q\u000f\u0019\u0002N9!\u00111NA:!\r\ti'C\u0007\u0003\u0003_R1!!\u001d\u001c\u0003\u0019a$o\\8u}%\u0019\u0011QO\u0005\u0002\rA\u0013X\rZ3g\u0013\r\u0001\u0017\u0011\u0010\u0006\u0004\u0003kJ\u0001bBA?\u0001\u0011\u0005\u0011qP\u0001\u001aOJ\f'MR5mi\"LWm\u001d;D_6\u0004\u0018m\u0019;fI2{w\r\u0006\u0003\u0002\u0002\u00065\u0005#\u0002\u0005\u0002\u0004\u0006\u001d\u0015bAAC\u0013\t1q\n\u001d;j_:\u00042\u0001PAE\u0013\r\tYI\u0001\u0002\u000b\u0019><Gk\\\"mK\u0006t\u0007\u0002CAH\u0003w\u0002\r!!%\u0002\tQLW.\u001a\t\u0005\u0003'\u000b9*\u0004\u0002\u0002\u0016*\u0011\u0001CM\u0005\u0005\u00033\u000b)J\u0001\u0003US6,\u0007bBAO\u0001\u0011\u0005\u0011qT\u0001\u000eI\u0016dW\r^1cY\u0016dunZ:\u0015\u0005\u0005\u0005\u0006CBAR\u0003[\u000b\u0019L\u0004\u0003\u0002&\u0006%f\u0002BA7\u0003OK\u0011AC\u0005\u0004\u0003WK\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003_\u000b\tL\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0015\r\tY+\u0003\t\u0006\u0011\u0005U\u0006gO\u0005\u0004\u0003oK!A\u0002+va2,'\u0007C\u0004\u0002<\u0002!\t!!0\u0002\u001b\u0005\u0014wN\u001d;DY\u0016\fg.\u001b8h)\u0011\t\t$a0\t\u000f\u0005\u0005\u0017\u0011\u0018a\u0001a\u0005qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007bBAc\u0001\u0011\u0005\u0011qY\u0001\u0016C\n|'\u000f^!oIB\u000bWo]3DY\u0016\fg.\u001b8h)\u0011\t\t$!3\t\u000f\u0005\u0005\u00171\u0019a\u0001a!9\u0011Q\u001a\u0001\u0005\u0002\u0005=\u0017A\u0004:fgVlWm\u00117fC:Lgn\u001a\u000b\u0005\u0003c\t\t\u000eC\u0004\u0002B\u0006-\u0007\u0019\u0001\u0019\t\u000f\u0005U\u0007\u0001\"\u0003\u0002X\u0006\t\u0012n]\"mK\u0006t\u0017N\\4J]N#\u0018\r^3\u0015\r\u0005e\u0017q\\Aq!\rA\u00111\\\u0005\u0004\u0003;L!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0003\f\u0019\u000e1\u00011\u0011\u001d\t\u0019/a5A\u0002M\fQ\"\u001a=qK\u000e$X\rZ*uCR,\u0007bBAt\u0001\u0011\u0005\u0011\u0011^\u0001\u0015G\",7m[\"mK\u0006t\u0017N\\4BE>\u0014H/\u001a3\u0015\t\u0005E\u00121\u001e\u0005\b\u0003\u0003\f)\u000f1\u00011\u0011\u001d\ty\u000f\u0001C\u0001\u0003c\f\u0011#\u001e9eCR,7\t[3dWB|\u0017N\u001c;t)\u0019\t\t$a=\u0002x\"9\u0011Q_Aw\u0001\u0004\u0001\u0013a\u00023bi\u0006$\u0015N\u001d\u0005\t\u0003s\fi\u000f1\u0001\u0002|\u00061Q\u000f\u001d3bi\u0016\u0004R\u0001CAB\u0003{\u0004b\u0001CA[a\u00055\u0003b\u0002B\u0001\u0001\u0011\u0005!1A\u0001\u0018[\u0006L(-\u001a+sk:\u001c\u0017\r^3DQ\u0016\u001c7\u000e]8j]R$\u0002\"!\r\u0003\u0006\t\u001d!\u0011\u0002\u0005\b\u0003k\fy\u00101\u0001!\u0011\u001d\t\t-a@A\u0002AB\u0001Ba\u0003\u0002\u0000\u0002\u0007\u0011QJ\u0001\u0007_\u001a47/\u001a;\t\u000f\t=\u0001\u0001\"\u0001\u0003\u0012\u0005aAm\u001c8f\u00072,\u0017M\\5oORA\u0011\u0011\u0007B\n\u0005+\u00119\u0002C\u0004\u0002B\n5\u0001\u0019\u0001\u0019\t\u000f\u0005U(Q\u0002a\u0001A!A!\u0011\u0004B\u0007\u0001\u0004\ti%A\u0005f]\u0012|eMZ:fi\"9!Q\u0004\u0001\u0005\u0002\t}\u0011\u0001\u00043p]\u0016$U\r\\3uS:<G\u0003BA\u0019\u0005CAq!!1\u0003\u001c\u0001\u0007\u0001g\u0002\u0005\u0003&\tA\tA\u0001B\u0014\u0003EaunZ\"mK\u0006tWM]'b]\u0006<WM\u001d\t\u0004y\t%baB\u0001\u0003\u0011\u0003\u0011!1F\n\u0005\u0005S9Q\u0002C\u0004C\u0005S!\tAa\f\u0015\u0005\t\u001d\u0002\u0002\u0003B\u001a\u0005S!\tA!\u000e\u0002%%\u001c8i\\7qC\u000e$\u0018I\u001c3EK2,G/\u001a\u000b\u0005\u00033\u00149\u0004\u0003\u0004\u0004\u0005c\u0001\ra\u000f\u0005\t\u0005w\u0011I\u0003\"\u0001\u0003>\u0005\u00012\r\\3b]\u0006\u0014G.Z(gMN,Go\u001d\u000b\u000b\u0005\u007f\u0011\tEa\u0011\u0003F\t-\u0003c\u0002\u0005\u00026\u00065\u0013Q\n\u0005\u0007\u0007\te\u0002\u0019A\u001e\t\u000f\u0005\u0005'\u0011\ba\u0001a!A!q\tB\u001d\u0001\u0004\u0011I%A\u0005mCN$8\t\\3b]B)!l\u0018\u0019\u0002N!A!Q\nB\u001d\u0001\u0004\ti%A\u0002o_^\u0004")
public class LogCleanerManager
implements KafkaMetricsGroup {
    private final File[] logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final String loggerName;
    private final String offsetCheckpointFile;
    private final scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints;
    private final HashMap<TopicPartition, LogCleaningState> inProgress;
    private final ReentrantLock lock;
    private final Condition pausedCleaningCond;
    private volatile double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    private volatile long kafka$log$LogCleanerManager$$timeOfLastRun;
    private Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Tuple2<Object, Object> cleanableOffsets(Log log, TopicPartition topicPartition, scala.collection.immutable.Map<TopicPartition, Object> map, long l) {
        return LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, map, l);
    }

    public static boolean isCompactAndDelete(Log log) {
        return LogCleanerManager$.MODULE$.isCompactAndDelete(log);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging.trace$(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.swallowTrace$(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging.debug$(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.swallowDebug$(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging.info$(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.swallowInfo$(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging.warn$(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.swallowWarn$(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging.swallow$(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging.error$(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging.swallowError$(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging.fatal$(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        LogCleanerManager logCleanerManager = this;
        synchronized (logCleanerManager) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
    }

    @Override
    public final void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public File[] logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public String offsetCheckpointFile() {
        return this.offsetCheckpointFile;
    }

    private scala.collection.immutable.Map<File, OffsetCheckpointFile> checkpoints() {
        return this.checkpoints;
    }

    private HashMap<TopicPartition, LogCleaningState> inProgress() {
        return this.inProgress;
    }

    private ReentrantLock lock() {
        return this.lock;
    }

    private Condition pausedCleaningCond() {
        return this.pausedCleaningCond;
    }

    public double kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio() {
        return this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio;
    }

    private void kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(double x$1) {
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = x$1;
    }

    public long kafka$log$LogCleanerManager$$timeOfLastRun() {
        return this.kafka$log$LogCleanerManager$$timeOfLastRun;
    }

    private void kafka$log$LogCleanerManager$$timeOfLastRun_$eq(long x$1) {
        this.kafka$log$LogCleanerManager$$timeOfLastRun = x$1;
    }

    public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
        return ((TraversableOnce)this.checkpoints().values().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.read(), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<LogToClean> grabFilthiestCompactedLog(Time time) {
        return (Option)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            long now = time.milliseconds();
            this.kafka$log$LogCleanerManager$$timeOfLastRun_$eq(now);
            scala.collection.immutable.Map<TopicPartition, Object> lastClean = this.allCleanerCheckpoints();
            Iterable dirtyLogs = (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$2(x0$1)))).filterNot((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$3(this, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2.mcJJ.sp sp2;
                Log log;
                TopicPartition topicPartition;
                Tuple2 tuple2 = x0$3;
                if (tuple2 != null) {
                    topicPartition = (TopicPartition)tuple2._1();
                    log = (Log)tuple2._2();
                    Tuple2<Object, Object> tuple22 = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, now);
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    long firstDirtyOffset = tuple22._1$mcJ$sp();
                    long firstUncleanableDirtyOffset = tuple22._2$mcJ$sp();
                    sp2 = new Tuple2.mcJJ.sp(firstDirtyOffset, firstUncleanableDirtyOffset);
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2.mcJJ.sp sp3 = sp2;
                long firstDirtyOffset = sp3._1$mcJ$sp();
                long firstUncleanableDirtyOffset = sp3._2$mcJ$sp();
                LogToClean logToClean = new LogToClean(topicPartition, log, firstDirtyOffset, firstUncleanableDirtyOffset);
                return logToClean;
            }, Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$5(ltc)));
            this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio_$eq(dirtyLogs.nonEmpty() ? ((LogToClean)dirtyLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).cleanableRatio() : 0.0);
            Iterable cleanableLogs = (Iterable)dirtyLogs.filter((Function1 & Serializable & scala.Serializable)ltc -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$grabFilthiestCompactedLog$6(ltc)));
            if (cleanableLogs.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                LogToClean filthiest = (LogToClean)cleanableLogs.max(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
                this.inProgress().put((Object)filthiest.topicPartition(), (Object)LogCleaningInProgress$.MODULE$);
                none$ = new Some((Object)filthiest);
            }
            return none$;
        });
    }

    public Iterable<Tuple2<TopicPartition, Log>> deletableLogs() {
        return (Iterable)CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Iterable toClean = (Iterable)this.logs().filter((Function1 & Serializable & scala.Serializable)x0$4 -> BoxesRunTime.boxToBoolean((boolean)LogCleanerManager.$anonfun$deletableLogs$2(this, x0$4)));
            toClean.foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition tp = (TopicPartition)tuple2._1();
                Option option = this.inProgress().put((Object)tp, (Object)LogCleaningInProgress$.MODULE$);
                return option;
            });
            return var1_1;
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.abortAndPauseCleaning(topicPartition);
            this.resumeCleaning(topicPartition);
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option option;
            Option option2 = this.inProgress().get((Object)topicPartition);
            if (None$.MODULE$.equals(option2)) {
                option = this.inProgress().put((Object)topicPartition, (Object)LogCleaningPaused$.MODULE$);
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                LogCleaningState state = (LogCleaningState)some.value();
                LogCleaningState logCleaningState = state;
                if (!LogCleaningInProgress$.MODULE$.equals(logCleaningState)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be aborted and paused since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, logCleaningState})));
                }
                Option option3 = this.inProgress().put((Object)topicPartition, (Object)LogCleaningAborted$.MODULE$);
                option = option3;
            } else {
                throw new MatchError((Object)option2);
            }
            while (!this.isCleaningInState(topicPartition, LogCleaningPaused$.MODULE$)) {
                this.pausedCleaningCond().await(100L, TimeUnit.MILLISECONDS);
            }
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cleaning for partition ", " is aborted and paused"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
    }

    public void resumeCleaning(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Option option;
            Option option2 = this.inProgress().get((Object)topicPartition);
            if (None$.MODULE$.equals(option2)) {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is not paused."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
            }
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                LogCleaningState state = (LogCleaningState)some.value();
                LogCleaningState logCleaningState = state;
                if (!LogCleaningPaused$.MODULE$.equals(logCleaningState)) {
                    throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " cannot be resumed since it is in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, logCleaningState})));
                }
                option = this.inProgress().remove((Object)topicPartition);
            } else {
                throw new MatchError((Object)option2);
            }
            Option option3 = option;
            return option3;
        });
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compaction for partition ", " is resumed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition})));
    }

    private boolean isCleaningInState(TopicPartition topicPartition, LogCleaningState expectedState) {
        boolean bl;
        Option option = this.inProgress().get((Object)topicPartition);
        if (None$.MODULE$.equals(option)) {
            bl = false;
        } else if (option instanceof Some) {
            LogCleaningState state;
            Some some = (Some)option;
            LogCleaningState logCleaningState = state = (LogCleaningState)some.value();
            LogCleaningState logCleaningState2 = expectedState;
            bl = !(logCleaningState != null ? !logCleaningState.equals(logCleaningState2) : logCleaningState2 != null);
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    public void checkCleaningAborted(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (this.isCleaningInState(topicPartition, LogCleaningAborted$.MODULE$)) {
                throw new LogCleaningAbortedException();
            }
        });
    }

    public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> update) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            OffsetCheckpointFile checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir);
            Map existing = checkpoint.read().filterKeys(this.logs().keys()).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(update));
            checkpoint.write((Map<TopicPartition, Object>)existing);
        });
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                OffsetCheckpointFile checkpoint;
                Map<TopicPartition, Object> existing;
                if (!this.logs().get(topicPartition).config().compact() || BoxesRunTime.unboxToLong((Object)(existing = (checkpoint = (OffsetCheckpointFile)this.checkpoints().apply((Object)dataDir)).read()).getOrElse((Object)topicPartition, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) <= offset) break block0;
                checkpoint.write((Map<TopicPartition, Object>)existing.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)offset))));
            }
        });
    }

    public void doneCleaning(TopicPartition topicPartition, File dataDir, long endOffset) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> {
            Option option;
            LogCleaningState logCleaningState = (LogCleaningState)this.inProgress().apply((Object)topicPartition);
            if (LogCleaningInProgress$.MODULE$.equals(logCleaningState)) {
                this.updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)Option$.MODULE$.apply((Object)new Tuple2((Object)topicPartition, (Object)BoxesRunTime.boxToLong((long)endOffset))));
                option = this.inProgress().remove((Object)topicPartition);
            } else if (LogCleaningAborted$.MODULE$.equals(logCleaningState)) {
                this.inProgress().put((Object)topicPartition, (Object)LogCleaningPaused$.MODULE$);
                this.pausedCleaningCond().signalAll();
                option = BoxedUnit.UNIT;
            } else {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"In-progress partition ", " cannot be in ", " state."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topicPartition, logCleaningState})));
            }
            return option;
        });
    }

    public void doneDeleting(TopicPartition topicPartition) {
        CoreUtils$.MODULE$.inLock(this.lock(), (Function0 & Serializable & scala.Serializable)() -> this.inProgress().remove((Object)topicPartition));
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Log log = (Log)tuple2._2();
        boolean bl = log.config().compact();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$3(LogCleanerManager $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        boolean bl = $this.inProgress().contains((Object)topicPartition);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$5(LogToClean ltc) {
        return ltc.totalBytes() > 0L;
    }

    public static final /* synthetic */ boolean $anonfun$grabFilthiestCompactedLog$6(LogToClean ltc) {
        return ltc.cleanableRatio() > Predef$.MODULE$.Double2double(ltc.log().config().minCleanableRatio());
    }

    public static final /* synthetic */ boolean $anonfun$deletableLogs$2(LogCleanerManager $this, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        Log log = (Log)tuple2._2();
        boolean bl = !$this.inProgress().contains((Object)topicPartition) && LogCleanerManager$.MODULE$.isCompactAndDelete(log);
        return bl;
    }

    public LogCleanerManager(File[] logDirs, Pool<TopicPartition, Log> logs) {
        this.logDirs = logDirs;
        this.logs = logs;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.offsetCheckpointFile = "cleaner-offset-checkpoint";
        this.checkpoints = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logDirs)).map((Function1 & Serializable & scala.Serializable)dir -> new Tuple2(dir, (Object)new OffsetCheckpointFile(new File((File)dir, this.offsetCheckpointFile()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        this.inProgress = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.lock = new ReentrantLock();
        this.pausedCleaningCond = this.lock().newCondition();
        this.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio = 0.0;
        this.newGauge("max-dirty-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public int value() {
                return (int)((double)100 * this.$outer.kafka$log$LogCleanerManager$$dirtiestLogCleanableRatio());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.kafka$log$LogCleanerManager$$timeOfLastRun = Time.SYSTEM.milliseconds();
        this.newGauge("time-since-last-run-ms", new Gauge<Object>(this){
            private final /* synthetic */ LogCleanerManager $outer;

            public long value() {
                return Time.SYSTEM.milliseconds() - this.$outer.kafka$log$LogCleanerManager$$timeOfLastRun();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }
}

