/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.maven.surefire.booter.BaseProviderFactory;
import org.apache.maven.surefire.booter.BooterDeserializer;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.Command;
import org.apache.maven.surefire.booter.CommandListener;
import org.apache.maven.surefire.booter.CommandReader;
import org.apache.maven.surefire.booter.DumpErrorSingleton;
import org.apache.maven.surefire.booter.ForkingReporterFactory;
import org.apache.maven.surefire.booter.ForkingRunListener;
import org.apache.maven.surefire.booter.LazyTestsToRun;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.Shutdown;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.booter.SystemPropertyManager;
import org.apache.maven.surefire.booter.TypeEncodedValue;
import org.apache.maven.surefire.providerapi.ProviderParameters;
import org.apache.maven.surefire.providerapi.SurefireProvider;
import org.apache.maven.surefire.report.LegacyPojoStackTraceWriter;
import org.apache.maven.surefire.report.ReporterFactory;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.TestSetFailedException;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;
import org.apache.maven.surefire.util.internal.StringUtils;

public final class ForkedBooter {
    private static final long DEFAULT_SYSTEM_EXIT_TIMEOUT_IN_SECONDS = 30L;
    private static final long PING_TIMEOUT_IN_SECONDS = 20L;
    private static final long ONE_SECOND_IN_MILLIS = 1000L;
    private static volatile ScheduledThreadPoolExecutor jvmTerminator;
    private static volatile long systemExitTimeoutInSeconds;

    public static void main(String ... args) {
        CommandReader reader = ForkedBooter.startupMasterProcessReader();
        ExecutorService pingScheduler = ForkedBooter.isDebugging() ? null : ForkedBooter.listenToShutdownCommands(reader);
        PrintStream originalOut = System.out;
        try {
            String tmpDir = args[0];
            String dumpFileName = args[1];
            String surefirePropsFileName = args[2];
            BooterDeserializer booterDeserializer = new BooterDeserializer(ForkedBooter.createSurefirePropertiesIfFileExists(tmpDir, surefirePropsFileName));
            if (args.length > 3) {
                String effectiveSystemPropertiesFileName = args[3];
                SystemPropertyManager.setSystemProperties(new File(tmpDir, effectiveSystemPropertiesFileName));
            }
            ProviderConfiguration providerConfiguration = booterDeserializer.deserialize();
            DumpErrorSingleton.getSingleton().init(dumpFileName, providerConfiguration.getReporterConfiguration());
            StartupConfiguration startupConfiguration = booterDeserializer.getProviderConfiguration();
            systemExitTimeoutInSeconds = providerConfiguration.systemExitTimeout(30L);
            TypeEncodedValue forkedTestSet = providerConfiguration.getTestForFork();
            boolean readTestsFromInputStream = providerConfiguration.isReadTestsFromInStream();
            ClasspathConfiguration classpathConfiguration = startupConfiguration.getClasspathConfiguration();
            if (startupConfiguration.isManifestOnlyJarRequestedAndUsable()) {
                classpathConfiguration.trickClassPathWhenManifestOnlyClasspath();
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            classLoader.setDefaultAssertionStatus(classpathConfiguration.isEnableAssertions());
            startupConfiguration.writeSurefireTestClasspathProperty();
            Object testSet = forkedTestSet != null ? forkedTestSet.getDecodedValue(classLoader) : (readTestsFromInputStream ? new LazyTestsToRun(originalOut) : null);
            try {
                ForkedBooter.runSuitesInProcess(testSet, startupConfiguration, providerConfiguration, originalOut);
            }
            catch (InvocationTargetException t) {
                DumpErrorSingleton.getSingleton().dumpException((Throwable)t);
                LegacyPojoStackTraceWriter stackTraceWriter = new LegacyPojoStackTraceWriter("test subsystem", "no method", t.getTargetException());
                StringBuilder stringBuilder = new StringBuilder();
                ForkingRunListener.encode((StringBuilder)stringBuilder, (StackTraceWriter)stackTraceWriter, (boolean)false);
                ForkedBooter.encodeAndWriteToOutput("X,0," + stringBuilder + "\n", originalOut);
            }
            catch (Throwable t) {
                DumpErrorSingleton.getSingleton().dumpException(t);
                LegacyPojoStackTraceWriter stackTraceWriter = new LegacyPojoStackTraceWriter("test subsystem", "no method", t);
                StringBuilder stringBuilder = new StringBuilder();
                ForkingRunListener.encode((StringBuilder)stringBuilder, (StackTraceWriter)stackTraceWriter, (boolean)false);
                ForkedBooter.encodeAndWriteToOutput("X,0," + stringBuilder + "\n", originalOut);
            }
            ForkedBooter.acknowledgedExit(reader, originalOut, pingScheduler);
        }
        catch (Throwable t) {
            DumpErrorSingleton.getSingleton().dumpException(t);
            t.printStackTrace(System.err);
            ForkedBooter.cancelPingScheduler(pingScheduler);
            ForkedBooter.exit(1);
        }
    }

    private static void cancelPingScheduler(final ExecutorService pingScheduler) {
        if (pingScheduler != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        pingScheduler.shutdown();
                        return null;
                    }
                });
            }
            catch (AccessControlException accessControlException) {
                // empty catch block
            }
        }
    }

    private static CommandReader startupMasterProcessReader() {
        return CommandReader.getReader();
    }

    private static ExecutorService listenToShutdownCommands(CommandReader reader) {
        reader.addShutdownListener(ForkedBooter.createExitHandler());
        AtomicBoolean pingDone = new AtomicBoolean(true);
        reader.addNoopListener(ForkedBooter.createPingHandler(pingDone));
        Runnable pingJob = ForkedBooter.createPingJob(pingDone);
        ScheduledExecutorService pingScheduler = ForkedBooter.createPingScheduler();
        pingScheduler.scheduleAtFixedRate(pingJob, 0L, 20L, TimeUnit.SECONDS);
        return pingScheduler;
    }

    private static CommandListener createPingHandler(final AtomicBoolean pingDone) {
        return new CommandListener(){

            public void update(Command command) {
                pingDone.set(true);
            }
        };
    }

    private static CommandListener createExitHandler() {
        return new CommandListener(){

            public void update(Command command) {
                Shutdown shutdown = command.toShutdownData();
                if (shutdown.isKill()) {
                    ForkedBooter.kill();
                } else if (shutdown.isExit()) {
                    ForkedBooter.exit(1);
                }
            }
        };
    }

    private static Runnable createPingJob(final AtomicBoolean pingDone) {
        return new Runnable(){

            @Override
            public void run() {
                boolean hasPing = pingDone.getAndSet(false);
                if (!hasPing) {
                    ForkedBooter.kill();
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void encodeAndWriteToOutput(String string, PrintStream out) {
        byte[] encodeBytes = StringUtils.encodeStringForForkCommunication((String)string);
        PrintStream printStream = out;
        synchronized (printStream) {
            out.write(encodeBytes, 0, encodeBytes.length);
            out.flush();
        }
    }

    private static void kill() {
        Runtime.getRuntime().halt(1);
    }

    private static void exit(int returnCode) {
        ForkedBooter.launchLastDitchDaemonShutdownThread(returnCode);
        System.exit(returnCode);
    }

    private static void acknowledgedExit(CommandReader reader, PrintStream originalOut, ExecutorService pingScheduler) {
        final Semaphore barrier = new Semaphore(0);
        reader.addByeAckListener(new CommandListener(){

            public void update(Command command) {
                barrier.release();
            }
        });
        ForkedBooter.encodeAndWriteToOutput("Z,0,BYE!\n", originalOut);
        ForkedBooter.launchLastDitchDaemonShutdownThread(0);
        long timeoutMillis = Math.max(systemExitTimeoutInSeconds * 1000L, 1000L);
        ForkedBooter.acquireOnePermit(barrier, timeoutMillis);
        ForkedBooter.cancelPingScheduler(pingScheduler);
        System.exit(0);
    }

    private static boolean acquireOnePermit(Semaphore barrier, long timeoutMillis) {
        try {
            return barrier.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            return true;
        }
    }

    private static RunResult runSuitesInProcess(Object testSet, StartupConfiguration startupConfiguration, ProviderConfiguration providerConfiguration, PrintStream originalSystemOut) throws SurefireExecutionException, TestSetFailedException, InvocationTargetException {
        ReporterFactory factory = ForkedBooter.createForkingReporterFactory(providerConfiguration, originalSystemOut);
        return ForkedBooter.invokeProviderInSameClassLoader(testSet, factory, providerConfiguration, true, startupConfiguration, false);
    }

    private static ReporterFactory createForkingReporterFactory(ProviderConfiguration providerConfiguration, PrintStream originalSystemOut) {
        boolean trimStackTrace = providerConfiguration.getReporterConfiguration().isTrimStackTrace();
        return new ForkingReporterFactory(trimStackTrace, originalSystemOut);
    }

    private static synchronized ScheduledThreadPoolExecutor getJvmTerminator() {
        if (jvmTerminator == null) {
            ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory((String)("last-ditch-daemon-shutdown-thread-" + systemExitTimeoutInSeconds + "s"));
            jvmTerminator = new ScheduledThreadPoolExecutor(1, threadFactory);
            jvmTerminator.setMaximumPoolSize(1);
            return jvmTerminator;
        }
        return jvmTerminator;
    }

    private static ScheduledExecutorService createPingScheduler() {
        ThreadFactory threadFactory = DaemonThreadFactory.newDaemonThreadFactory((String)"ping-20s");
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, threadFactory);
        executor.setMaximumPoolSize(1);
        executor.prestartCoreThread();
        return executor;
    }

    private static void launchLastDitchDaemonShutdownThread(final int returnCode) {
        ForkedBooter.getJvmTerminator().schedule(new Runnable(){

            @Override
            public void run() {
                Runtime.getRuntime().halt(returnCode);
            }
        }, systemExitTimeoutInSeconds, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RunResult invokeProviderInSameClassLoader(Object testSet, Object factory, ProviderConfiguration providerConfig, boolean insideFork, StartupConfiguration startupConfig, boolean restoreStreams) throws TestSetFailedException, InvocationTargetException {
        PrintStream orgSystemOut = System.out;
        PrintStream orgSystemErr = System.err;
        try {
            RunResult runResult = ForkedBooter.createProviderInCurrentClassloader(startupConfig, insideFork, providerConfig, factory).invoke(testSet);
            return runResult;
        }
        finally {
            if (restoreStreams && System.getSecurityManager() == null) {
                System.setOut(orgSystemOut);
                System.setErr(orgSystemErr);
            }
        }
    }

    private static SurefireProvider createProviderInCurrentClassloader(StartupConfiguration startupConfiguration, boolean isInsideFork, ProviderConfiguration providerConfiguration, Object reporterManagerFactory) {
        BaseProviderFactory bpf = new BaseProviderFactory((ReporterFactory)reporterManagerFactory, isInsideFork);
        bpf.setTestRequest(providerConfiguration.getTestSuiteDefinition());
        bpf.setReporterConfiguration(providerConfiguration.getReporterConfiguration());
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        bpf.setClassLoaders(classLoader);
        bpf.setTestArtifactInfo(providerConfiguration.getTestArtifact());
        bpf.setProviderProperties(providerConfiguration.getProviderProperties());
        bpf.setRunOrderParameters(providerConfiguration.getRunOrderParameters());
        bpf.setDirectoryScannerParameters(providerConfiguration.getDirScannerParams());
        bpf.setMainCliOptions(providerConfiguration.getMainCliOptions());
        bpf.setSkipAfterFailureCount(providerConfiguration.getSkipAfterFailureCount());
        bpf.setShutdown(providerConfiguration.getShutdown());
        bpf.setSystemExitTimeout(providerConfiguration.getSystemExitTimeout());
        String providerClass = startupConfiguration.getActualClassName();
        return (SurefireProvider)ReflectionUtils.instantiateOneArg((ClassLoader)classLoader, (String)providerClass, ProviderParameters.class, (Object)bpf);
    }

    private static InputStream createSurefirePropertiesIfFileExists(String tmpDir, String propFileName) throws FileNotFoundException {
        File surefirePropertiesFile = new File(tmpDir, propFileName);
        return surefirePropertiesFile.exists() ? new FileInputStream(surefirePropertiesFile) : null;
    }

    private static boolean isDebugging() {
        for (String argument : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            if (!"-Xdebug".equals(argument) && !argument.startsWith("-agentlib:jdwp")) continue;
            return true;
        }
        return false;
    }

    static {
        systemExitTimeoutInSeconds = 30L;
    }
}

