/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.distsql.handler.update;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.distsql.handler.converter.DatabaseDiscoveryRuleStatementConverter;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.segment.DatabaseDiscoveryHeartbeatSegment;
import org.apache.shardingsphere.dbdiscovery.distsql.parser.statement.AlterDatabaseDiscoveryHeartbeatStatement;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateRuleException;
import org.apache.shardingsphere.infra.distsql.exception.rule.RequiredRuleMissedException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionAlterUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;

public final class AlterDatabaseDiscoveryHeartbeatStatementUpdater
implements RuleDefinitionAlterUpdater<AlterDatabaseDiscoveryHeartbeatStatement, DatabaseDiscoveryRuleConfiguration> {
    private static final String RULE_TYPE = "database discovery";

    public DatabaseDiscoveryRuleConfiguration buildToBeAlteredRuleConfiguration(AlterDatabaseDiscoveryHeartbeatStatement sqlStatement) {
        return DatabaseDiscoveryRuleStatementConverter.convertDiscoveryHeartbeat(sqlStatement.getHeartbeats());
    }

    public void updateCurrentRuleConfiguration(DatabaseDiscoveryRuleConfiguration currentRuleConfig, DatabaseDiscoveryRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getDiscoveryHeartbeats().putAll(toBeCreatedRuleConfig.getDiscoveryHeartbeats());
        }
    }

    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, AlterDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        String schemaName = shardingSphereMetaData.getName();
        this.checkCurrentConfiguration(schemaName, currentRuleConfig);
        this.checkDuplicateHeartbeat(schemaName, sqlStatement);
        this.checkNotExistHeartbeat(schemaName, sqlStatement, currentRuleConfig);
    }

    private void checkCurrentConfiguration(String schemaName, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        DistSQLException.predictionThrow((currentRuleConfig != null ? 1 : 0) != 0, () -> new RequiredRuleMissedException(RULE_TYPE, schemaName));
    }

    private void checkNotExistHeartbeat(String schemaName, AlterDatabaseDiscoveryHeartbeatStatement sqlStatement, DatabaseDiscoveryRuleConfiguration currentRuleConfig) throws DistSQLException {
        Set currentHeartbeats = currentRuleConfig.getDiscoveryHeartbeats().keySet();
        Collection notExistHeartbeats = sqlStatement.getHeartbeats().stream().map(DatabaseDiscoveryHeartbeatSegment::getHeartbeatName).filter(each -> !currentHeartbeats.contains(each)).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)notExistHeartbeats.isEmpty(), () -> new RequiredRuleMissedException(RULE_TYPE, schemaName, notExistHeartbeats));
    }

    private void checkDuplicateHeartbeat(String schemaName, AlterDatabaseDiscoveryHeartbeatStatement sqlStatement) throws DistSQLException {
        Collection<String> duplicateRuleNames = this.getToBeCreatedDuplicateRuleNames(sqlStatement);
        DistSQLException.predictionThrow((boolean)duplicateRuleNames.isEmpty(), () -> new DuplicateRuleException(RULE_TYPE, schemaName, duplicateRuleNames));
    }

    private Collection<String> getToBeCreatedDuplicateRuleNames(AlterDatabaseDiscoveryHeartbeatStatement sqlStatement) {
        return sqlStatement.getHeartbeats().stream().collect(Collectors.toMap(DatabaseDiscoveryHeartbeatSegment::getHeartbeatName, e -> 1, Integer::sum)).entrySet().stream().filter(entry -> (Integer)entry.getValue() > 1).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getRuleConfigurationClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }

    public String getType() {
        return AlterDatabaseDiscoveryHeartbeatStatement.class.getName();
    }
}

