/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.mysql.type;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.mysql.AbstractDatabaseDiscoveryType;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceDisabledEvent;
import org.apache.shardingsphere.infra.storage.StorageNodeDataSource;
import org.apache.shardingsphere.infra.storage.StorageNodeRole;
import org.apache.shardingsphere.infra.storage.StorageNodeStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MGRDatabaseDiscoveryType
extends AbstractDatabaseDiscoveryType {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MGRDatabaseDiscoveryType.class);
    private static final String PLUGIN_STATUS = "SELECT * FROM information_schema.PLUGINS WHERE PLUGIN_NAME='group_replication'";
    private static final String MEMBER_COUNT = "SELECT count(*) FROM performance_schema.replication_group_members";
    private static final String GROUP_NAME = "SELECT * FROM performance_schema.global_variables WHERE VARIABLE_NAME='group_replication_group_name'";
    private static final String SINGLE_PRIMARY = "SELECT * FROM performance_schema.global_variables WHERE VARIABLE_NAME='group_replication_single_primary_mode'";
    private static final String MEMBER_LIST = "SELECT MEMBER_HOST, MEMBER_PORT, MEMBER_STATE FROM performance_schema.replication_group_members";
    private static final String PRIMARY_DATA_SOURCE = "SELECT MEMBER_HOST, MEMBER_PORT FROM performance_schema.replication_group_members WHERE MEMBER_ID = (SELECT VARIABLE_VALUE FROM performance_schema.global_status WHERE VARIABLE_NAME = 'group_replication_primary_member')";
    private Properties props = new Properties();

    public void checkDatabaseDiscoveryConfiguration(String schemaName, Map<String, DataSource> dataSourceMap) throws SQLException {
        try (Connection connection = dataSourceMap.values().stream().findFirst().get().getConnection();
             Statement statement = connection.createStatement();){
            this.checkPluginIsActive(statement);
            this.checkMemberCount(statement);
            this.checkServerGroupName(statement);
            this.checkIsSinglePrimaryMode(statement);
            this.checkDataSourceInReplicationGroup(statement, dataSourceMap);
        }
    }

    private void checkPluginIsActive(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(PLUGIN_STATUS);){
            while (resultSet.next()) {
                if ("ACTIVE".equals(resultSet.getString("PLUGIN_STATUS"))) continue;
                throw new ShardingSphereConfigurationException("MGR plugin is not active.", new Object[0]);
            }
        }
    }

    private void checkMemberCount(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(MEMBER_COUNT);){
            while (resultSet.next()) {
                if (resultSet.getInt(1) >= 1) continue;
                throw new ShardingSphereConfigurationException("MGR member count < 1", new Object[0]);
            }
        }
    }

    private void checkServerGroupName(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(GROUP_NAME);){
            while (resultSet.next()) {
                String ruleGroupName;
                String serverGroupName = resultSet.getString("VARIABLE_VALUE");
                if (serverGroupName.equals(ruleGroupName = this.props.getProperty("group-name"))) continue;
                throw new ShardingSphereConfigurationException("MGR group name is not consistent\nserverGroupName: %s\nruleGroupName: %s", new Object[]{serverGroupName, ruleGroupName});
            }
        }
    }

    private void checkIsSinglePrimaryMode(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(SINGLE_PRIMARY);){
            while (resultSet.next()) {
                if ("ON".equals(resultSet.getString("VARIABLE_VALUE"))) continue;
                throw new ShardingSphereConfigurationException("MGR is not in single primary mode", new Object[0]);
            }
        }
    }

    private void checkDataSourceInReplicationGroup(Statement statement, Map<String, DataSource> dataSourceMap) throws SQLException {
        LinkedList<String> memberDataSourceURLs = new LinkedList<String>();
        try (ResultSet resultSet = statement.executeQuery(MEMBER_LIST);){
            while (resultSet.next()) {
                memberDataSourceURLs.add(String.format("%s:%s", resultSet.getString("MEMBER_HOST"), resultSet.getString("MEMBER_PORT")));
            }
        }
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            this.checkDataSourceExistedWithGroupMember(entry.getKey(), entry.getValue(), memberDataSourceURLs);
        }
    }

    private void checkDataSourceExistedWithGroupMember(String datasourceName, DataSource dataSource, Collection<String> memberDataSourceURLs) throws SQLException {
        boolean isExisted = false;
        for (String each : memberDataSourceURLs) {
            if (!dataSource.getConnection().getMetaData().getURL().contains(each)) continue;
            isExisted = true;
            break;
        }
        if (!isExisted) {
            throw new ShardingSphereConfigurationException("%s is not MGR replication group member", new Object[]{datasourceName});
        }
    }

    @Override
    protected String getPrimaryDataSourceURL(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(PRIMARY_DATA_SOURCE);){
            if (resultSet.next()) {
                String string = String.format("%s:%s", resultSet.getString("MEMBER_HOST"), resultSet.getString("MEMBER_PORT"));
                return string;
            }
            String string = "";
            return string;
        }
    }

    public void updateMemberState(String schemaName, Map<String, DataSource> dataSourceMap, String groupName) {
        List<String> memberDataSourceURLs = this.findMemberDataSourceURLs(dataSourceMap);
        if (memberDataSourceURLs.isEmpty()) {
            return;
        }
        this.determineDisabledDataSource(schemaName, dataSourceMap, memberDataSourceURLs, groupName);
    }

    private List<String> findMemberDataSourceURLs(Map<String, DataSource> dataSourceMap) {
        LinkedList<String> result = new LinkedList<String>();
        try (Connection connection = dataSourceMap.get(this.getPrimaryDataSource()).getConnection();
             Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(MEMBER_LIST);
            while (resultSet.next()) {
                if (!"ONLINE".equals(resultSet.getString("MEMBER_STATE"))) continue;
                result.add(String.format("%s:%s", resultSet.getString("MEMBER_HOST"), resultSet.getString("MEMBER_PORT")));
            }
        }
        catch (SQLException ex) {
            log.error("An exception occurred while find member data source urls", (Throwable)ex);
        }
        return result;
    }

    private void determineDisabledDataSource(String schemaName, Map<String, DataSource> dataSourceMap, List<String> memberDataSourceURLs, String groupName) {
        for (Map.Entry<String, DataSource> entry : dataSourceMap.entrySet()) {
            if (entry.getKey().equals(this.getPrimaryDataSource())) continue;
            boolean disable = true;
            try (Connection connection = entry.getValue().getConnection();){
                String url = connection.getMetaData().getURL();
                for (String each : memberDataSourceURLs) {
                    if (null == url || !url.contains(each)) continue;
                    disable = false;
                    break;
                }
            }
            catch (SQLException ex) {
                log.error("An exception occurred while find data source urls", (Throwable)ex);
            }
            ShardingSphereEventBus.getInstance().post((Object)new DataSourceDisabledEvent(schemaName, groupName, entry.getKey(), new StorageNodeDataSource(StorageNodeRole.MEMBER, disable ? StorageNodeStatus.DISABLED : StorageNodeStatus.ENABLED)));
        }
    }

    public String getType() {
        return "MGR";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }
}

