/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.type;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.infra.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.sql.parser.sql.common.constant.QuoteCharacter;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public interface DatabaseType {
    public String getName();

    public QuoteCharacter getQuoteCharacter();

    public Collection<String> getJdbcUrlPrefixes();

    public DataSourceMetaData getDataSourceMetaData(String var1, String var2);

    public Optional<String> getDataSourceClassName();

    public Map<String, Collection<String>> getSystemDatabaseSchemaMap();

    public Collection<String> getSystemSchemas();

    default public String getSchema(Connection connection) {
        try {
            return connection.getSchema();
        }
        catch (SQLException ignored) {
            return null;
        }
    }

    default public String formatTableNamePattern(String tableNamePattern) {
        return tableNamePattern;
    }

    default public void handleRollbackOnly(boolean rollbackOnly, SQLStatement statement) throws SQLException {
    }
}

