/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.instance;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.definition.InstanceId;
import org.apache.shardingsphere.infra.instance.definition.InstanceType;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;

public final class InstanceContext {
    private final ComputeNodeInstance instance;
    private final WorkerIdGenerator workerIdGenerator;
    private final ModeConfiguration modeConfiguration;
    private final LockContext lockContext;
    private final Collection<ComputeNodeInstance> computeNodeInstances = new LinkedList<ComputeNodeInstance>();

    public void updateInstanceStatus(String instanceId, Collection<String> status) {
        if (this.instance.getInstanceDefinition().getInstanceId().getId().equals(instanceId)) {
            this.instance.switchState(status);
        }
        this.updateRelatedComputeNodeInstancesStatus(instanceId, status);
    }

    private void updateRelatedComputeNodeInstancesStatus(String instanceId, Collection<String> status) {
        for (ComputeNodeInstance each : this.computeNodeInstances) {
            if (!each.getInstanceDefinition().getInstanceId().getId().equals(instanceId)) continue;
            each.switchState(status);
        }
    }

    public void updateWorkerId(Long workerId) {
        if (!Objects.equals(workerId, this.instance.getWorkerId())) {
            this.instance.setWorkerId(workerId);
        }
    }

    public void updateLabel(String instanceId, Collection<String> labels) {
        if (this.instance.getInstanceDefinition().getInstanceId().getId().equals(instanceId)) {
            this.instance.setLabels(labels);
        }
        this.computeNodeInstances.stream().filter(each -> each.getInstanceDefinition().getInstanceId().getId().equals(instanceId)).forEach(each -> each.setLabels(labels));
    }

    public void updateXaRecoveryId(String xaRecoveryId) {
        if (!Objects.equals(xaRecoveryId, this.instance.getXaRecoveryId())) {
            this.instance.setXaRecoveryId(xaRecoveryId);
        }
    }

    public long getWorkerId() {
        if (null == this.instance.getWorkerId()) {
            Optional.of(this.workerIdGenerator.generate()).ifPresent(this.instance::setWorkerId);
        }
        return this.instance.getWorkerId();
    }

    public void addComputeNodeInstance(ComputeNodeInstance instance) {
        this.computeNodeInstances.removeIf(each -> each.getInstanceDefinition().getInstanceId().getId().equalsIgnoreCase(instance.getInstanceDefinition().getInstanceId().getId()));
        this.computeNodeInstances.add(instance);
    }

    public void deleteComputeNodeInstance(ComputeNodeInstance instance) {
        this.computeNodeInstances.removeIf(each -> each.getInstanceDefinition().getInstanceId().getId().equalsIgnoreCase(instance.getInstanceDefinition().getInstanceId().getId()));
    }

    public List<InstanceId> getComputeNodeInstanceIds(InstanceType instanceType, Collection<String> labels) {
        ArrayList<InstanceId> result = new ArrayList<InstanceId>(this.computeNodeInstances.size());
        for (ComputeNodeInstance each : this.computeNodeInstances) {
            if (each.getInstanceDefinition().getInstanceType() != instanceType) continue;
            if (!labels.stream().anyMatch(each.getLabels()::contains)) continue;
            result.add(each.getInstanceDefinition().getInstanceId());
        }
        return result;
    }

    @Generated
    public ComputeNodeInstance getInstance() {
        return this.instance;
    }

    @Generated
    public WorkerIdGenerator getWorkerIdGenerator() {
        return this.workerIdGenerator;
    }

    @Generated
    public ModeConfiguration getModeConfiguration() {
        return this.modeConfiguration;
    }

    @Generated
    public LockContext getLockContext() {
        return this.lockContext;
    }

    @Generated
    public Collection<ComputeNodeInstance> getComputeNodeInstances() {
        return this.computeNodeInstances;
    }

    @Generated
    public InstanceContext(ComputeNodeInstance instance, WorkerIdGenerator workerIdGenerator, ModeConfiguration modeConfiguration, LockContext lockContext) {
        this.instance = instance;
        this.workerIdGenerator = workerIdGenerator;
        this.modeConfiguration = modeConfiguration;
        this.lockContext = lockContext;
    }
}

