/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.rule.builder.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.function.DistributedRuleConfiguration;
import org.apache.shardingsphere.infra.config.function.EnhancedRuleConfiguration;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.config.schema.SchemaConfiguration;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.schema.DefaultSchemaRuleConfigurationBuilder;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRuleBuilder;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.ordered.OrderedSPIRegistry;

public final class SchemaRulesBuilder {
    public static Collection<ShardingSphereRule> buildRules(String schemaName, SchemaConfiguration schemaConfig, ConfigurationProperties props) {
        LinkedList<ShardingSphereRule> result = new LinkedList<ShardingSphereRule>();
        for (Map.Entry<RuleConfiguration, SchemaRuleBuilder> entry : SchemaRulesBuilder.getRuleBuilderMap(schemaConfig).entrySet()) {
            result.add(entry.getValue().build(entry.getKey(), schemaName, schemaConfig.getDataSources(), result, props));
        }
        return result;
    }

    private static Map<RuleConfiguration, SchemaRuleBuilder> getRuleBuilderMap(SchemaConfiguration schemaConfig) {
        LinkedHashMap<RuleConfiguration, SchemaRuleBuilder> result = new LinkedHashMap<RuleConfiguration, SchemaRuleBuilder>();
        result.putAll(SchemaRulesBuilder.getDistributedRuleBuilderMap(schemaConfig.getRuleConfigurations()));
        result.putAll(SchemaRulesBuilder.getEnhancedRuleBuilderMap(schemaConfig.getRuleConfigurations()));
        result.putAll(SchemaRulesBuilder.getMissedDefaultRuleBuilderMap(result.values()));
        return result;
    }

    private static Map<RuleConfiguration, SchemaRuleBuilder> getDistributedRuleBuilderMap(Collection<RuleConfiguration> ruleConfigs) {
        Collection distributedRuleConfigs = ruleConfigs.stream().filter(each -> SchemaRulesBuilder.isAssignableFrom(each, DistributedRuleConfiguration.class)).collect(Collectors.toList());
        return OrderedSPIRegistry.getRegisteredServices(SchemaRuleBuilder.class, (Collection)distributedRuleConfigs, Comparator.reverseOrder());
    }

    private static Map<RuleConfiguration, SchemaRuleBuilder> getEnhancedRuleBuilderMap(Collection<RuleConfiguration> ruleConfigs) {
        Collection enhancedRuleConfigs = ruleConfigs.stream().filter(each -> SchemaRulesBuilder.isAssignableFrom(each, EnhancedRuleConfiguration.class)).collect(Collectors.toList());
        return OrderedSPIRegistry.getRegisteredServices(SchemaRuleBuilder.class, (Collection)enhancedRuleConfigs);
    }

    private static boolean isAssignableFrom(RuleConfiguration ruleConfig, Class<? extends RuleConfiguration> ruleConfigClass) {
        return Arrays.stream(ruleConfig.getClass().getInterfaces()).anyMatch(ruleConfigClass::isAssignableFrom);
    }

    private static Map<RuleConfiguration, SchemaRuleBuilder> getMissedDefaultRuleBuilderMap(Collection<SchemaRuleBuilder> configuredBuilders) {
        LinkedHashMap<RuleConfiguration, SchemaRuleBuilder> result = new LinkedHashMap<RuleConfiguration, SchemaRuleBuilder>();
        Map defaultBuilders = OrderedSPIRegistry.getRegisteredServices(DefaultSchemaRuleConfigurationBuilder.class, SchemaRulesBuilder.getMissedDefaultRuleBuilders(configuredBuilders));
        for (Map.Entry entry : defaultBuilders.entrySet()) {
            result.put((RuleConfiguration)((DefaultSchemaRuleConfigurationBuilder)entry.getValue()).build(), (SchemaRuleBuilder)entry.getKey());
        }
        return result;
    }

    private static Collection<SchemaRuleBuilder> getMissedDefaultRuleBuilders(Collection<SchemaRuleBuilder> configuredBuilders) {
        Collection configuredBuilderClasses = configuredBuilders.stream().map(each -> each.getClass()).collect(Collectors.toSet());
        return OrderedSPIRegistry.getRegisteredServices(SchemaRuleBuilder.class).stream().filter(each -> !configuredBuilderClasses.contains(each.getClass())).collect(Collectors.toList());
    }

    @Generated
    private SchemaRulesBuilder() {
    }

    static {
        ShardingSphereServiceLoader.register(SchemaRuleBuilder.class);
        ShardingSphereServiceLoader.register(DefaultSchemaRuleConfigurationBuilder.class);
    }
}

