/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.federation.executor.original;

import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.shardingsphere.infra.federation.executor.original.FilterableSchema;
import org.apache.shardingsphere.infra.federation.executor.original.table.FilterableTableScanExecutor;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationDatabaseMetaData;
import org.apache.shardingsphere.infra.federation.optimizer.metadata.FederationSchemaMetaData;

public final class FilterableDatabase
extends AbstractSchema {
    private final String name;
    private final Map<String, Schema> subSchemaMap;

    public FilterableDatabase(FederationDatabaseMetaData databaseMetaData, FilterableTableScanExecutor executor) {
        this.name = databaseMetaData.getName();
        this.subSchemaMap = this.createSubSchemaMap(databaseMetaData, executor);
    }

    private Map<String, Schema> createSubSchemaMap(FederationDatabaseMetaData databaseMetaData, FilterableTableScanExecutor executor) {
        LinkedHashMap<String, Schema> result = new LinkedHashMap<String, Schema>(databaseMetaData.getSchemas().size(), 1.0f);
        for (FederationSchemaMetaData each : databaseMetaData.getSchemas().values()) {
            result.put(each.getName(), (Schema)new FilterableSchema(each, executor));
        }
        return result;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<String, Schema> getSubSchemaMap() {
        return this.subSchemaMap;
    }
}

