/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.merge.result.impl.memory;

import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.merge.result.MergedResult;
import org.apache.shardingsphere.infra.merge.result.impl.memory.MemoryQueryResultRow;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;

public abstract class MemoryMergedResult<T extends ShardingSphereRule>
implements MergedResult {
    private final Iterator<MemoryQueryResultRow> memoryResultSetRows;
    private MemoryQueryResultRow currentResultSetRow;
    private boolean wasNull;

    protected MemoryMergedResult(T rule, ShardingSphereSchema schema, SQLStatementContext<?> sqlStatementContext, List<QueryResult> queryResults) throws SQLException {
        List<MemoryQueryResultRow> memoryQueryResultRowList = this.init(rule, schema, sqlStatementContext, queryResults);
        this.memoryResultSetRows = memoryQueryResultRowList.iterator();
        if (!memoryQueryResultRowList.isEmpty()) {
            this.currentResultSetRow = memoryQueryResultRowList.get(0);
        }
    }

    protected abstract List<MemoryQueryResultRow> init(T var1, ShardingSphereSchema var2, SQLStatementContext<?> var3, List<QueryResult> var4) throws SQLException;

    @Override
    public final boolean next() {
        if (this.memoryResultSetRows.hasNext()) {
            this.currentResultSetRow = this.memoryResultSetRows.next();
            return true;
        }
        return false;
    }

    @Override
    public final Object getValue(int columnIndex, Class<?> type) throws SQLException {
        if (Blob.class == type || Clob.class == type || Reader.class == type || InputStream.class == type || SQLXML.class == type) {
            throw new SQLFeatureNotSupportedException(String.format("Get value from `%s`", type.getName()));
        }
        Object result = this.currentResultSetRow.getCell(columnIndex);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public final Object getCalendarValue(int columnIndex, Class<?> type, Calendar calendar) {
        Object result = this.currentResultSetRow.getCell(columnIndex);
        this.wasNull = null == result;
        return result;
    }

    @Override
    public final InputStream getInputStream(int columnIndex, String type) throws SQLException {
        throw new SQLFeatureNotSupportedException(String.format("Get input stream from `%s`", type));
    }

    @Override
    public final boolean wasNull() {
        return this.wasNull;
    }
}

