/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.query;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.query.DistSQLResultSet;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.properties.PropertiesConverter;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.distsql.parser.statement.ShowUnusedShardingAlgorithmsStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;

public final class UnusedShardingAlgorithmsQueryResultSet
implements DistSQLResultSet {
    private static final String TYPE = ShowUnusedShardingAlgorithmsStatement.class.getName();
    private static final String NAME = "name";
    private static final String COLUMN_TYPE = "type";
    private static final String PROPS = "props";
    private Iterator<Map.Entry<String, ShardingSphereAlgorithmConfiguration>> data = Collections.emptyIterator();

    public void init(ShardingSphereMetaData metaData, SQLStatement sqlStatement) {
        Optional<ShardingRuleConfiguration> ruleConfig = metaData.getRuleMetaData().getConfigurations().stream().filter(each -> each instanceof ShardingRuleConfiguration).map(each -> (ShardingRuleConfiguration)each).findAny();
        ruleConfig.ifPresent(this::getUnusedShardingAlgorithms);
    }

    public Collection<String> getColumnNames() {
        return Arrays.asList(NAME, COLUMN_TYPE, PROPS);
    }

    public boolean next() {
        return this.data.hasNext();
    }

    public Collection<Object> getRowData() {
        return this.buildTableRowData(this.data.next());
    }

    private Collection<Object> buildTableRowData(Map.Entry<String, ShardingSphereAlgorithmConfiguration> data) {
        LinkedList<Object> result = new LinkedList<Object>();
        result.add(data.getKey());
        result.add(data.getValue().getType());
        result.add(this.buildProps(data.getValue().getProps()));
        return result;
    }

    private Object buildProps(Properties props) {
        return Objects.nonNull(props) ? PropertiesConverter.convert((Properties)props) : "";
    }

    public String getType() {
        return TYPE;
    }

    private void getUnusedShardingAlgorithms(ShardingRuleConfiguration shardingRuleConfig) {
        Collection<String> inUsedSet = this.getUsedShardingAlgorithms(shardingRuleConfig);
        HashMap map = new HashMap();
        for (Map.Entry each : shardingRuleConfig.getShardingAlgorithms().entrySet()) {
            if (inUsedSet.contains(each.getKey())) continue;
            map.put(each.getKey(), each.getValue());
        }
        this.data = map.entrySet().iterator();
    }

    private Collection<String> getUsedShardingAlgorithms(ShardingRuleConfiguration shardingRuleConfig) {
        ShardingStrategyConfiguration databaseShardingStrategy;
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        shardingRuleConfig.getTables().forEach(each -> {
            if (Objects.nonNull(each.getDatabaseShardingStrategy())) {
                result.add(each.getDatabaseShardingStrategy().getShardingAlgorithmName());
            }
            if (Objects.nonNull(each.getTableShardingStrategy())) {
                result.add(each.getTableShardingStrategy().getShardingAlgorithmName());
            }
        });
        shardingRuleConfig.getAutoTables().stream().filter(each -> Objects.nonNull(each.getShardingStrategy())).forEach(each -> result.add(each.getShardingStrategy().getShardingAlgorithmName()));
        ShardingStrategyConfiguration tableShardingStrategy = shardingRuleConfig.getDefaultTableShardingStrategy();
        if (Objects.nonNull(tableShardingStrategy) && !Strings.isNullOrEmpty((String)tableShardingStrategy.getShardingAlgorithmName())) {
            result.add(tableShardingStrategy.getShardingAlgorithmName());
        }
        if (Objects.nonNull(databaseShardingStrategy = shardingRuleConfig.getDefaultDatabaseShardingStrategy()) && !Strings.isNullOrEmpty((String)databaseShardingStrategy.getShardingAlgorithmName())) {
            result.add(databaseShardingStrategy.getShardingAlgorithmName());
        }
        return result;
    }
}

