/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.update;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.shardingsphere.distsql.parser.segment.AlgorithmSegment;
import org.apache.shardingsphere.infra.config.algorithm.ShardingSphereAlgorithmConfiguration;
import org.apache.shardingsphere.infra.distsql.exception.DistSQLException;
import org.apache.shardingsphere.infra.distsql.exception.rule.DuplicateKeyGeneratorException;
import org.apache.shardingsphere.infra.distsql.exception.rule.InvalidAlgorithmConfigurationException;
import org.apache.shardingsphere.infra.distsql.update.RuleDefinitionCreateUpdater;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.distsql.handler.converter.ShardingTableRuleStatementConverter;
import org.apache.shardingsphere.sharding.distsql.parser.segment.ShardingKeyGeneratorSegment;
import org.apache.shardingsphere.sharding.distsql.parser.statement.CreateShardingKeyGeneratorStatement;
import org.apache.shardingsphere.sharding.spi.KeyGenerateAlgorithm;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;

public final class CreateShardingKeyGeneratorStatementUpdater
implements RuleDefinitionCreateUpdater<CreateShardingKeyGeneratorStatement, ShardingRuleConfiguration> {
    public void checkSQLStatement(ShardingSphereMetaData shardingSphereMetaData, CreateShardingKeyGeneratorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        this.checkDuplicate(shardingSphereMetaData.getName(), sqlStatement, currentRuleConfig);
        this.checkKeyGeneratorAlgorithm(sqlStatement);
    }

    private void checkDuplicate(String schemaName, CreateShardingKeyGeneratorStatement sqlStatement, ShardingRuleConfiguration currentRuleConfig) throws DistSQLException {
        Collection keyGeneratorNames = sqlStatement.getKeyGeneratorSegments().stream().map(ShardingKeyGeneratorSegment::getKeyGeneratorName).collect(Collectors.toCollection(LinkedList::new));
        this.checkDuplicateInput(keyGeneratorNames, duplicated -> new DuplicateKeyGeneratorException("sharding", schemaName, duplicated));
        if (null != currentRuleConfig) {
            this.checkExist(keyGeneratorNames, currentRuleConfig.getKeyGenerators().keySet(), duplicated -> new DuplicateKeyGeneratorException("sharding", schemaName, duplicated));
        }
    }

    private void checkDuplicateInput(Collection<String> rules, Function<Collection<String>, DistSQLException> thrower) throws DistSQLException {
        Collection duplicateRequire = rules.stream().collect(Collectors.groupingBy(each -> each, Collectors.counting())).entrySet().stream().filter(each -> (Long)each.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)duplicateRequire.isEmpty(), () -> (DistSQLException)thrower.apply(duplicateRequire));
    }

    private void checkExist(Collection<String> requireRules, Collection<String> currentRules, Function<Collection<String>, DistSQLException> thrower) throws DistSQLException {
        Collection identical = requireRules.stream().filter(currentRules::contains).collect(Collectors.toSet());
        DistSQLException.predictionThrow((boolean)identical.isEmpty(), () -> (DistSQLException)thrower.apply(identical));
    }

    private void checkKeyGeneratorAlgorithm(CreateShardingKeyGeneratorStatement sqlStatement) throws DistSQLException {
        Collection notExistedKeyGeneratorAlgorithms = sqlStatement.getKeyGeneratorSegments().stream().map(ShardingKeyGeneratorSegment::getAlgorithmSegment).map(AlgorithmSegment::getName).filter(each -> !TypedSPIRegistry.findRegisteredService(KeyGenerateAlgorithm.class, (String)each, (Properties)new Properties()).isPresent()).collect(Collectors.toList());
        DistSQLException.predictionThrow((boolean)notExistedKeyGeneratorAlgorithms.isEmpty(), () -> new InvalidAlgorithmConfigurationException("sharding", notExistedKeyGeneratorAlgorithms));
    }

    public ShardingRuleConfiguration buildToBeCreatedRuleConfiguration(CreateShardingKeyGeneratorStatement sqlStatement) {
        ShardingRuleConfiguration result = new ShardingRuleConfiguration();
        Map<String, ShardingSphereAlgorithmConfiguration> keyGeneratorConfigurationMap = sqlStatement.getKeyGeneratorSegments().stream().collect(Collectors.toMap(ShardingKeyGeneratorSegment::getKeyGeneratorName, each -> ShardingTableRuleStatementConverter.createAlgorithmConfiguration(each.getAlgorithmSegment())));
        result.setKeyGenerators(keyGeneratorConfigurationMap);
        return result;
    }

    public void updateCurrentRuleConfiguration(ShardingRuleConfiguration currentRuleConfig, ShardingRuleConfiguration toBeCreatedRuleConfig) {
        if (null != currentRuleConfig) {
            currentRuleConfig.getKeyGenerators().putAll(toBeCreatedRuleConfig.getKeyGenerators());
        }
    }

    public Class<ShardingRuleConfiguration> getRuleConfigurationClass() {
        return ShardingRuleConfiguration.class;
    }

    public String getType() {
        return CreateShardingKeyGeneratorStatement.class.getName();
    }
}

