/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.core;

import java.util.Collection;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.sql.parser.core.extractor.SQLSegmentsExtractorEngine;
import org.apache.shardingsphere.sql.parser.core.filler.SQLStatementFillerEngine;
import org.apache.shardingsphere.sql.parser.core.parser.SQLAST;
import org.apache.shardingsphere.sql.parser.core.parser.SQLParserEngine;
import org.apache.shardingsphere.sql.parser.core.rule.registry.ParseRuleRegistry;
import org.apache.shardingsphere.sql.parser.sql.segment.SQLSegment;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;

public final class SQLParseKernel {
    private final SQLParserEngine parserEngine;
    private final SQLSegmentsExtractorEngine extractorEngine;
    private final SQLStatementFillerEngine fillerEngine;

    public SQLParseKernel(ParseRuleRegistry parseRuleRegistry, String databaseTypeName, String sql) {
        this.parserEngine = new SQLParserEngine(parseRuleRegistry, databaseTypeName, sql);
        this.extractorEngine = new SQLSegmentsExtractorEngine();
        this.fillerEngine = new SQLStatementFillerEngine(parseRuleRegistry, databaseTypeName);
    }

    public SQLStatement parse() {
        SQLAST ast = this.parserEngine.parse();
        Collection<SQLSegment> sqlSegments = this.extractorEngine.extract(ast);
        Map<ParserRuleContext, Integer> parameterMarkerIndexes = ast.getParameterMarkerIndexes();
        return this.fillerEngine.fill(sqlSegments, parameterMarkerIndexes.size(), ast.getSqlStatementRule());
    }
}

