/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import com.univocity.parsers.csv.CsvParser;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.HadoopFileLinesReader;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.csv.CSVDataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVInferSchema$;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser;
import org.apache.spark.sql.execution.datasources.csv.UnivocityParser$;
import org.apache.spark.sql.execution.datasources.text.TextFileFormat;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class TextInputCSVDataSource$
extends CSVDataSource {
    public static final TextInputCSVDataSource$ MODULE$;
    private final boolean isSplitable;

    static {
        new TextInputCSVDataSource$();
    }

    @Override
    public boolean isSplitable() {
        return this.isSplitable;
    }

    @Override
    public Iterator<InternalRow> readFile(Configuration conf, PartitionedFile file, UnivocityParser parser, StructType schema2) {
        HadoopFileLinesReader linesReader = new HadoopFileLinesReader(file, conf);
        Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get()).foreach((Function1)new Serializable(linesReader){
            public static final long serialVersionUID = 0L;
            public final HadoopFileLinesReader linesReader$1;

            public final TaskContext apply(TaskContext x$2) {
                return x$2.addTaskCompletionListener((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.3 $outer;

                    public final void apply(TaskContext x$3) {
                        this.$outer.linesReader$1.close();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.linesReader$1 = linesReader$1;
            }
        });
        Iterator lines = linesReader.map(new Serializable(parser){
            public static final long serialVersionUID = 0L;
            private final UnivocityParser parser$1;

            public final String apply(Text line) {
                return new String(line.getBytes(), 0, line.getLength(), this.parser$1.options().charset());
            }
            {
                this.parser$1 = parser$1;
            }
        });
        boolean shouldDropHeader = parser.options().headerFlag() && file.start() == 0L;
        return UnivocityParser$.MODULE$.parseIterator(lines, shouldDropHeader, parser, schema2);
    }

    @Override
    public StructType infer(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions parsedOptions) {
        Dataset<String> csv = this.createBaseDataset(sparkSession, inputPaths, parsedOptions);
        Option maybeFirstLine = Predef$.MODULE$.refArrayOps((Object[])CSVUtils$.MODULE$.filterCommentAndEmpty(csv, parsedOptions).take(1)).headOption();
        return this.inferFromDataset(sparkSession, csv, (Option<String>)maybeFirstLine, parsedOptions);
    }

    public StructType inferFromDataset(SparkSession sparkSession, Dataset<String> csv, Option<String> maybeFirstLine, CSVOptions parsedOptions) {
        Option<String> option;
        block4: {
            StructType structType;
            block3: {
                block2: {
                    option = maybeFirstLine;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String firstLine = (String)some.x();
                    String[] firstRow = new CsvParser(parsedOptions.asParserSettings()).parseLine(firstLine);
                    boolean caseSensitive = sparkSession.sessionState().conf().caseSensitiveAnalysis();
                    String[] header = this.makeSafeHeader(firstRow, caseSensitive, parsedOptions);
                    RDD tokenRDD = csv.rdd().mapPartitions((Function1)new Serializable(parsedOptions, firstLine){
                        public static final long serialVersionUID = 0L;
                        private final CSVOptions parsedOptions$1;
                        private final String firstLine$1;

                        public final Iterator<String[]> apply(Iterator<String> iter) {
                            Iterator<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(iter, this.parsedOptions$1);
                            Iterator<String> linesWithoutHeader = CSVUtils$.MODULE$.filterHeaderLine(filteredLines, this.firstLine$1, this.parsedOptions$1);
                            CsvParser parser = new CsvParser(this.parsedOptions$1.asParserSettings());
                            return linesWithoutHeader.map((Function1)new Serializable(this, parser){
                                public static final long serialVersionUID = 0L;
                                private final CsvParser parser$2;

                                public final String[] apply(String x$1) {
                                    return this.parser$2.parseLine(x$1);
                                }
                                {
                                    this.parser$2 = parser$2;
                                }
                            });
                        }
                        {
                            this.parsedOptions$1 = parsedOptions$1;
                            this.firstLine$1 = firstLine$1;
                        }
                    }, csv.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
                    structType = CSVInferSchema$.MODULE$.infer((RDD<String[]>)tokenRDD, header, parsedOptions);
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                structType = StructType$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
            return structType;
        }
        throw new MatchError(option);
    }

    private Dataset<String> createBaseDataset(SparkSession sparkSession, Seq<FileStatus> inputPaths, CSVOptions options) {
        Dataset<String> dataset;
        Seq paths = (Seq)inputPaths.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(FileStatus x$4) {
                return x$4.getPath().toString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Charset charset = Charset.forName(options.charset());
        Charset charset2 = StandardCharsets.UTF_8;
        if (!(charset != null ? !((Object)charset).equals(charset2) : charset2 != null)) {
            SparkSession x$7 = sparkSession;
            Seq x$8 = paths;
            String x$9 = TextFileFormat.class.getName();
            CaseInsensitiveMap<String> x$10 = options.parameters();
            Option<StructType> x$11 = DataSource$.MODULE$.apply$default$4();
            Seq<String> x$12 = DataSource$.MODULE$.apply$default$5();
            Option<BucketSpec> x$13 = DataSource$.MODULE$.apply$default$6();
            Option<CatalogTable> x$14 = DataSource$.MODULE$.apply$default$8();
            dataset = sparkSession.baseRelationToDataFrame(new DataSource(x$7, x$9, (Seq<String>)x$8, x$11, x$12, x$13, (Map<String, String>)x$10, x$14).resolveRelation(false)).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(Encoders$.MODULE$.STRING());
        } else {
            String charset3 = options.charset();
            RDD qual$1 = sparkSession.sparkContext().hadoopFile(paths.mkString(","), ClassTag$.MODULE$.apply(LongWritable.class), ClassTag$.MODULE$.apply(Text.class), ClassTag$.MODULE$.apply(TextInputFormat.class));
            Serializable x$15 = new Serializable(charset3){
                public static final long serialVersionUID = 0L;
                public final String charset$1;

                public final Iterator<String> apply(Iterator<Tuple2<LongWritable, Text>> x$5) {
                    return x$5.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.7 $outer;

                        public final String apply(Tuple2<LongWritable, Text> pair) {
                            return new String(((Text)pair._2()).getBytes(), 0, ((Text)pair._2()).getLength(), this.$outer.charset$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                {
                    this.charset$1 = charset$1;
                }
            };
            boolean x$16 = qual$1.mapPartitions$default$2();
            RDD rdd2 = qual$1.mapPartitions((Function1)x$15, x$16, ClassTag$.MODULE$.apply(String.class));
            dataset = sparkSession.createDataset(rdd2, Encoders$.MODULE$.STRING());
        }
        return dataset;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TextInputCSVDataSource$() {
        MODULE$ = this;
        this.isSplitable = true;
    }
}

