/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.async.internal.reactive;

import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.bsc.async.AsyncGenerator;
import org.bsc.async.AsyncGeneratorQueue;

public class GeneratorSubscriber<T>
implements Flow.Subscriber<T>,
AsyncGenerator<T> {
    private final AsyncGeneratorQueue.Generator<T> delegate;
    private final Supplier<Object> mapResult;

    public Optional<Supplier<Object>> mapResult() {
        return Optional.ofNullable(this.mapResult);
    }

    public <P extends Flow.Publisher<T>> GeneratorSubscriber(P publisher, Supplier<Object> mapResult, BlockingQueue<AsyncGenerator.Data<T>> queue) {
        this.delegate = new AsyncGeneratorQueue.Generator(queue);
        this.mapResult = mapResult;
        publisher.subscribe(this);
    }

    public <P extends Flow.Publisher<T>> GeneratorSubscriber(P publisher, BlockingQueue<AsyncGenerator.Data<T>> queue) {
        this(publisher, null, queue);
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        subscription.request(Long.MAX_VALUE);
    }

    @Override
    public void onNext(T item) {
        this.delegate.queue().add(AsyncGenerator.Data.of(item));
    }

    @Override
    public void onError(Throwable error) {
        this.delegate.queue().add(AsyncGenerator.Data.error(error));
    }

    @Override
    public void onComplete() {
        this.delegate.queue().add(AsyncGenerator.Data.done(this.mapResult().map(Supplier::get).orElse(null)));
    }

    @Override
    public AsyncGenerator.Data<T> next() {
        return this.delegate.next();
    }
}

