// Targeted by JavaCPP version 1.5.4: DO NOT EDIT THIS FILE

package org.bytedeco.opencv.opencv_tracking;

import org.bytedeco.javacpp.annotation.Index;
import java.nio.*;
import org.bytedeco.javacpp.*;
import org.bytedeco.javacpp.annotation.*;

import static org.bytedeco.javacpp.presets.javacpp.*;
import static org.bytedeco.openblas.global.openblas_nolapack.*;
import static org.bytedeco.openblas.global.openblas.*;
import org.bytedeco.opencv.opencv_core.*;
import static org.bytedeco.opencv.global.opencv_core.*;
import org.bytedeco.opencv.opencv_imgproc.*;
import static org.bytedeco.opencv.global.opencv_imgproc.*;
import org.bytedeco.opencv.opencv_plot.*;
import static org.bytedeco.opencv.global.opencv_plot.*;
import static org.bytedeco.opencv.global.opencv_imgcodecs.*;
import org.bytedeco.opencv.opencv_videoio.*;
import static org.bytedeco.opencv.global.opencv_videoio.*;
import org.bytedeco.opencv.opencv_highgui.*;
import static org.bytedeco.opencv.global.opencv_highgui.*;
import org.bytedeco.opencv.opencv_flann.*;
import static org.bytedeco.opencv.global.opencv_flann.*;
import org.bytedeco.opencv.opencv_features2d.*;
import static org.bytedeco.opencv.global.opencv_features2d.*;
import org.bytedeco.opencv.opencv_calib3d.*;
import static org.bytedeco.opencv.global.opencv_calib3d.*;
import org.bytedeco.opencv.opencv_video.*;
import static org.bytedeco.opencv.global.opencv_video.*;
import org.bytedeco.opencv.opencv_dnn.*;
import static org.bytedeco.opencv.global.opencv_dnn.*;

import static org.bytedeco.opencv.global.opencv_tracking.*;


/**
 * \brief Class that manages the sampler in order to select regions for the update the model of the tracker
 * [AAM] Sampling e Labeling. See table I and section III B
 */

/** \brief Class that manages the sampler in order to select regions for the update the model of the tracker
<p>
\cite AAM Sampling e Labeling. See table I and section III B
<p>
TrackerSampler is an aggregation of TrackerSamplerAlgorithm
@see
   TrackerSamplerAlgorithm
 */
@Namespace("cv") @NoOffset @Properties(inherit = org.bytedeco.opencv.presets.opencv_tracking.class)
public class TrackerSampler extends Pointer {
    static { Loader.load(); }
    /** Pointer cast constructor. Invokes {@link Pointer#Pointer(Pointer)}. */
    public TrackerSampler(Pointer p) { super(p); }
    /** Native array allocator. Access with {@link Pointer#position(long)}. */
    public TrackerSampler(long size) { super((Pointer)null); allocateArray(size); }
    private native void allocateArray(long size);
    @Override public TrackerSampler position(long position) {
        return (TrackerSampler)super.position(position);
    }
    @Override public TrackerSampler getPointer(long i) {
        return new TrackerSampler(this).position(position + i);
    }


  /**
   * \brief Constructor
   */
  public TrackerSampler() { super((Pointer)null); allocate(); }
  private native void allocate();

  /**
   * \brief Destructor
   */

  /** \brief Computes the regions starting from a position in an image
    @param image The current frame
    @param boundingBox The bounding box from which regions can be calculated
     */
  public native void sampling( @Const @ByRef Mat image, @ByVal Rect boundingBox );

  /** \brief Return the collection of the TrackerSamplerAlgorithm
    */
  public native @Const @ByRef StringTrackerSamplerAlgorithmPairVector getSamplers();

  /** \brief Return the samples from all TrackerSamplerAlgorithm, \cite AAM Fig. 1 variable Sk
    */
  public native @Const @ByRef MatVector getSamples();

  /** \brief Add TrackerSamplerAlgorithm in the collection. Return true if sampler is added, false otherwise
    @param trackerSamplerAlgorithmType The TrackerSamplerAlgorithm name
    <p>
    The modes available now:
    -   "CSC" -- Current State Center
    -   "CS" -- Current State
    -   "PF" -- Particle Filtering
    <p>
    Example TrackerSamplerAlgorithm::addTrackerSamplerAlgorithm : :
    <pre>{@code
         TrackerSamplerCSC::Params CSCparameters;
         Ptr<TrackerSamplerAlgorithm> CSCSampler = new TrackerSamplerCSC( CSCparameters );

         if( !sampler->addTrackerSamplerAlgorithm( CSCSampler ) )
           return false;

         //or add CSC sampler with default parameters
         //sampler->addTrackerSamplerAlgorithm( "CSC" );
    }</pre>
    \note If you use the second method, you must initialize the TrackerSamplerAlgorithm
     */
  public native @Cast("bool") boolean addTrackerSamplerAlgorithm( @Str BytePointer trackerSamplerAlgorithmType );
  public native @Cast("bool") boolean addTrackerSamplerAlgorithm( @Str String trackerSamplerAlgorithmType );

  /** \overload
    @param sampler The TrackerSamplerAlgorithm
    */
  public native @Cast("bool") boolean addTrackerSamplerAlgorithm( @Ptr @ByVal TrackerSamplerAlgorithm sampler );
}
