/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.text;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint;
import org.opencv.core.MatOfRect;
import org.opencv.text.ERFilter;
import org.opencv.utils.Converters;

public class Text {
    public static final int OCR_DECODER_VITERBI = 0;
    public static final int ERGROUPING_ORIENTATION_HORIZ = 0;
    public static final int ERGROUPING_ORIENTATION_ANY = 1;
    public static final int PSM_OSD_ONLY = 0;
    public static final int PSM_AUTO_OSD = 1;
    public static final int PSM_AUTO_ONLY = 2;
    public static final int PSM_AUTO = 3;
    public static final int PSM_SINGLE_COLUMN = 4;
    public static final int PSM_SINGLE_BLOCK_VERT_TEXT = 5;
    public static final int PSM_SINGLE_BLOCK = 6;
    public static final int PSM_SINGLE_LINE = 7;
    public static final int PSM_SINGLE_WORD = 8;
    public static final int PSM_CIRCLE_WORD = 9;
    public static final int PSM_SINGLE_CHAR = 10;
    public static final int OCR_KNN_CLASSIFIER = 0;
    public static final int OCR_CNN_CLASSIFIER = 1;
    public static final int OEM_TESSERACT_ONLY = 0;
    public static final int OEM_CUBE_ONLY = 1;
    public static final int OEM_TESSERACT_CUBE_COMBINED = 2;
    public static final int OEM_DEFAULT = 3;
    public static final int ERFILTER_NM_RGBLGrad = 0;
    public static final int ERFILTER_NM_IHSGrad = 1;
    public static final int OCR_LEVEL_WORD = 0;
    public static final int OCR_LEVEL_TEXTLINE = 1;

    public static Mat createOCRHMMTransitionsTable(String vocabulary, List<String> lexicon) {
        return new Mat(Text.createOCRHMMTransitionsTable_0(vocabulary, lexicon));
    }

    public static ERFilter createERFilterNM1(String filename, int thresholdDelta, float minArea, float maxArea, float minProbability, boolean nonMaxSuppression, float minProbabilityDiff) {
        return ERFilter.__fromPtr__(Text.createERFilterNM1_0(filename, thresholdDelta, minArea, maxArea, minProbability, nonMaxSuppression, minProbabilityDiff));
    }

    public static ERFilter createERFilterNM1(String filename, int thresholdDelta, float minArea, float maxArea, float minProbability, boolean nonMaxSuppression) {
        return ERFilter.__fromPtr__(Text.createERFilterNM1_1(filename, thresholdDelta, minArea, maxArea, minProbability, nonMaxSuppression));
    }

    public static ERFilter createERFilterNM1(String filename, int thresholdDelta, float minArea, float maxArea, float minProbability) {
        return ERFilter.__fromPtr__(Text.createERFilterNM1_2(filename, thresholdDelta, minArea, maxArea, minProbability));
    }

    public static ERFilter createERFilterNM1(String filename, int thresholdDelta, float minArea, float maxArea) {
        return ERFilter.__fromPtr__(Text.createERFilterNM1_3(filename, thresholdDelta, minArea, maxArea));
    }

    public static ERFilter createERFilterNM1(String filename, int thresholdDelta, float minArea) {
        return ERFilter.__fromPtr__(Text.createERFilterNM1_4(filename, thresholdDelta, minArea));
    }

    public static ERFilter createERFilterNM1(String filename, int thresholdDelta) {
        return ERFilter.__fromPtr__(Text.createERFilterNM1_5(filename, thresholdDelta));
    }

    public static ERFilter createERFilterNM1(String filename) {
        return ERFilter.__fromPtr__(Text.createERFilterNM1_6(filename));
    }

    public static ERFilter createERFilterNM2(String filename, float minProbability) {
        return ERFilter.__fromPtr__(Text.createERFilterNM2_0(filename, minProbability));
    }

    public static ERFilter createERFilterNM2(String filename) {
        return ERFilter.__fromPtr__(Text.createERFilterNM2_1(filename));
    }

    public static void computeNMChannels(Mat _src, List<Mat> _channels, int _mode) {
        Mat _channels_mat = new Mat();
        Text.computeNMChannels_0(_src.nativeObj, _channels_mat.nativeObj, _mode);
        Converters.Mat_to_vector_Mat(_channels_mat, _channels);
        _channels_mat.release();
    }

    public static void computeNMChannels(Mat _src, List<Mat> _channels) {
        Mat _channels_mat = new Mat();
        Text.computeNMChannels_1(_src.nativeObj, _channels_mat.nativeObj);
        Converters.Mat_to_vector_Mat(_channels_mat, _channels);
        _channels_mat.release();
    }

    public static void detectRegions(Mat image, ERFilter er_filter1, ERFilter er_filter2, MatOfRect groups_rects, int method, String filename, float minProbability) {
        MatOfRect groups_rects_mat = groups_rects;
        Text.detectRegions_0(image.nativeObj, er_filter1.getNativeObjAddr(), er_filter2.getNativeObjAddr(), groups_rects_mat.nativeObj, method, filename, minProbability);
    }

    public static void detectRegions(Mat image, ERFilter er_filter1, ERFilter er_filter2, MatOfRect groups_rects, int method, String filename) {
        MatOfRect groups_rects_mat = groups_rects;
        Text.detectRegions_1(image.nativeObj, er_filter1.getNativeObjAddr(), er_filter2.getNativeObjAddr(), groups_rects_mat.nativeObj, method, filename);
    }

    public static void detectRegions(Mat image, ERFilter er_filter1, ERFilter er_filter2, MatOfRect groups_rects, int method) {
        MatOfRect groups_rects_mat = groups_rects;
        Text.detectRegions_2(image.nativeObj, er_filter1.getNativeObjAddr(), er_filter2.getNativeObjAddr(), groups_rects_mat.nativeObj, method);
    }

    public static void detectRegions(Mat image, ERFilter er_filter1, ERFilter er_filter2, MatOfRect groups_rects) {
        MatOfRect groups_rects_mat = groups_rects;
        Text.detectRegions_3(image.nativeObj, er_filter1.getNativeObjAddr(), er_filter2.getNativeObjAddr(), groups_rects_mat.nativeObj);
    }

    public static void detectRegions(Mat image, ERFilter er_filter1, ERFilter er_filter2, List<MatOfPoint> regions) {
        Mat regions_mat = new Mat();
        Text.detectRegions_4(image.nativeObj, er_filter1.getNativeObjAddr(), er_filter2.getNativeObjAddr(), regions_mat.nativeObj);
        Converters.Mat_to_vector_vector_Point(regions_mat, regions);
        regions_mat.release();
    }

    public static void detectTextSWT(Mat input, MatOfRect result, boolean dark_on_light, Mat draw, Mat chainBBs) {
        MatOfRect result_mat = result;
        Text.detectTextSWT_0(input.nativeObj, result_mat.nativeObj, dark_on_light, draw.nativeObj, chainBBs.nativeObj);
    }

    public static void detectTextSWT(Mat input, MatOfRect result, boolean dark_on_light, Mat draw) {
        MatOfRect result_mat = result;
        Text.detectTextSWT_1(input.nativeObj, result_mat.nativeObj, dark_on_light, draw.nativeObj);
    }

    public static void detectTextSWT(Mat input, MatOfRect result, boolean dark_on_light) {
        MatOfRect result_mat = result;
        Text.detectTextSWT_2(input.nativeObj, result_mat.nativeObj, dark_on_light);
    }

    public static void erGrouping(Mat image, Mat channel, List<MatOfPoint> regions, MatOfRect groups_rects, int method, String filename, float minProbablity) {
        ArrayList<Mat> regions_tmplm = new ArrayList<Mat>(regions != null ? regions.size() : 0);
        Mat regions_mat = Converters.vector_vector_Point_to_Mat(regions, regions_tmplm);
        MatOfRect groups_rects_mat = groups_rects;
        Text.erGrouping_0(image.nativeObj, channel.nativeObj, regions_mat.nativeObj, groups_rects_mat.nativeObj, method, filename, minProbablity);
    }

    public static void erGrouping(Mat image, Mat channel, List<MatOfPoint> regions, MatOfRect groups_rects, int method, String filename) {
        ArrayList<Mat> regions_tmplm = new ArrayList<Mat>(regions != null ? regions.size() : 0);
        Mat regions_mat = Converters.vector_vector_Point_to_Mat(regions, regions_tmplm);
        MatOfRect groups_rects_mat = groups_rects;
        Text.erGrouping_1(image.nativeObj, channel.nativeObj, regions_mat.nativeObj, groups_rects_mat.nativeObj, method, filename);
    }

    public static void erGrouping(Mat image, Mat channel, List<MatOfPoint> regions, MatOfRect groups_rects, int method) {
        ArrayList<Mat> regions_tmplm = new ArrayList<Mat>(regions != null ? regions.size() : 0);
        Mat regions_mat = Converters.vector_vector_Point_to_Mat(regions, regions_tmplm);
        MatOfRect groups_rects_mat = groups_rects;
        Text.erGrouping_2(image.nativeObj, channel.nativeObj, regions_mat.nativeObj, groups_rects_mat.nativeObj, method);
    }

    public static void erGrouping(Mat image, Mat channel, List<MatOfPoint> regions, MatOfRect groups_rects) {
        ArrayList<Mat> regions_tmplm = new ArrayList<Mat>(regions != null ? regions.size() : 0);
        Mat regions_mat = Converters.vector_vector_Point_to_Mat(regions, regions_tmplm);
        MatOfRect groups_rects_mat = groups_rects;
        Text.erGrouping_3(image.nativeObj, channel.nativeObj, regions_mat.nativeObj, groups_rects_mat.nativeObj);
    }

    private static native long createOCRHMMTransitionsTable_0(String var0, List<String> var1);

    private static native long createERFilterNM1_0(String var0, int var1, float var2, float var3, float var4, boolean var5, float var6);

    private static native long createERFilterNM1_1(String var0, int var1, float var2, float var3, float var4, boolean var5);

    private static native long createERFilterNM1_2(String var0, int var1, float var2, float var3, float var4);

    private static native long createERFilterNM1_3(String var0, int var1, float var2, float var3);

    private static native long createERFilterNM1_4(String var0, int var1, float var2);

    private static native long createERFilterNM1_5(String var0, int var1);

    private static native long createERFilterNM1_6(String var0);

    private static native long createERFilterNM2_0(String var0, float var1);

    private static native long createERFilterNM2_1(String var0);

    private static native void computeNMChannels_0(long var0, long var2, int var4);

    private static native void computeNMChannels_1(long var0, long var2);

    private static native void detectRegions_0(long var0, long var2, long var4, long var6, int var8, String var9, float var10);

    private static native void detectRegions_1(long var0, long var2, long var4, long var6, int var8, String var9);

    private static native void detectRegions_2(long var0, long var2, long var4, long var6, int var8);

    private static native void detectRegions_3(long var0, long var2, long var4, long var6);

    private static native void detectRegions_4(long var0, long var2, long var4, long var6);

    private static native void detectTextSWT_0(long var0, long var2, boolean var4, long var5, long var7);

    private static native void detectTextSWT_1(long var0, long var2, boolean var4, long var5);

    private static native void detectTextSWT_2(long var0, long var2, boolean var4);

    private static native void erGrouping_0(long var0, long var2, long var4, long var6, int var8, String var9, float var10);

    private static native void erGrouping_1(long var0, long var2, long var4, long var6, int var8, String var9);

    private static native void erGrouping_2(long var0, long var2, long var4, long var6, int var8);

    private static native void erGrouping_3(long var0, long var2, long var4, long var6);
}

