/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class CancellableExecutionCompletableFuture<T>
extends CompletableFuture<T> {
    private static final Log log = LoggerFactory.make(Log.class, MethodHandles.lookup());
    private final Future<?> future;

    CancellableExecutionCompletableFuture(Runnable runnable, ExecutorService executor) {
        this.future = executor.submit(new CompletingRunnable(this, runnable));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        log.tracef("Cancelling CompletableFuture %s (mayInterruptIfRunning = %s)", this, mayInterruptIfRunning);
        super.cancel(mayInterruptIfRunning);
        log.tracef("Cancelling Future %s (mayInterruptIfRunning = %s)", this.future, mayInterruptIfRunning);
        boolean cancelled = this.future.cancel(mayInterruptIfRunning);
        if (!cancelled) {
            log.debugf("Could not cancel Future %s (mayInterruptIfRunning = %s)", this.future, mayInterruptIfRunning);
        }
        return cancelled;
    }

    private static class CompletingRunnable<T>
    implements Runnable {
        private final CompletableFuture<T> future;
        private final Runnable delegate;

        private CompletingRunnable(CompletableFuture<T> future, Runnable delegate) {
            this.future = future;
            this.delegate = delegate;
        }

        public String toString() {
            return "CompletingRunnable[future=" + this.future + ", delegate=" + this.delegate + "]";
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
                this.future.complete(null);
            }
            catch (Throwable t) {
                if (this.future.isCancelled()) {
                    Futures.getThrowableNow(this.future).addSuppressed(t);
                }
                this.future.completeExceptionally(t);
            }
        }
    }
}

