/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.remote.impl.indexing.search5;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.protostream.AnnotationMetadataCreator;
import org.infinispan.protostream.descriptors.AnnotationElement;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.query.remote.impl.indexing.FieldMapping;
import org.infinispan.query.remote.impl.indexing.IndexingMetadata;
import org.infinispan.query.remote.impl.indexing.infinispan.InfinispanMetadataCreator;
import org.infinispan.query.remote.impl.logging.Log;

final class Search5MetadataCreator
implements AnnotationMetadataCreator<IndexingMetadata, Descriptor> {
    private static final Log log = (Log)LogFactory.getLog(Search5MetadataCreator.class, Log.class);

    Search5MetadataCreator() {
    }

    public IndexingMetadata create(Descriptor descriptor, AnnotationElement.Annotation annotation) {
        String v;
        Boolean enabled = (Boolean)annotation.getAttributeValue("enabled").getValue();
        String indexName = (String)annotation.getAttributeValue("index").getValue();
        if (indexName.isEmpty()) {
            indexName = null;
        }
        String entityAnalyzer = null;
        AnnotationElement.Annotation entityAnalyzerAnnotation = IndexingMetadata.findAnnotation(descriptor.getAnnotations(), "Analyzer");
        if (entityAnalyzerAnnotation != null && !(v = (String)entityAnalyzerAnnotation.getAttributeValue("definition").getValue()).isEmpty()) {
            entityAnalyzer = v;
        }
        HashMap<String, FieldMapping> fields = new HashMap<String, FieldMapping>(descriptor.getFields().size());
        for (FieldDescriptor fd : descriptor.getFields()) {
            Map annotations;
            FieldMapping fieldMapping = InfinispanMetadataCreator.fieldMapping(fd, annotations = fd.getAnnotations());
            if (fieldMapping != null) {
                fields.put(fd.getName(), fieldMapping);
                continue;
            }
            fieldMapping = Search5MetadataCreator.search5FieldMapping(fd, annotations);
            if (fieldMapping == null) continue;
            fields.put(fd.getName(), fieldMapping);
        }
        IndexingMetadata indexingMetadata = new IndexingMetadata(enabled, indexName, entityAnalyzer, fields);
        if (log.isDebugEnabled()) {
            log.debugf("Descriptor name=%s indexingMetadata=%s", descriptor.getFullName(), indexingMetadata);
        }
        return indexingMetadata;
    }

    private static FieldMapping search5FieldMapping(FieldDescriptor fd, Map<String, AnnotationElement.Annotation> annotations) {
        AnnotationElement.Annotation fieldLevelAnalyzerAnnotationAttribute;
        String fieldLevelAnalyzerAttribute;
        String v;
        String fieldLevelAnalyzer = null;
        AnnotationElement.Annotation fieldAnalyzerAnnotation = IndexingMetadata.findAnnotation(fd.getAnnotations(), "Analyzer");
        if (fieldAnalyzerAnnotation != null && !(v = (String)fieldAnalyzerAnnotation.getAttributeValue("definition").getValue()).isEmpty()) {
            fieldLevelAnalyzer = v;
        }
        boolean isSortable = IndexingMetadata.findAnnotation(fd.getAnnotations(), "SortableField") != null;
        AnnotationElement.Annotation fieldAnnotation = IndexingMetadata.findAnnotation(fd.getAnnotations(), "Field");
        if (fieldAnnotation == null) {
            return null;
        }
        String fieldName = fd.getName();
        String v2 = (String)fieldAnnotation.getAttributeValue("name").getValue();
        if (!v2.isEmpty()) {
            fieldName = v2;
        }
        AnnotationElement.Value indexAttribute = fieldAnnotation.getAttributeValue("index");
        boolean isIndexed = IndexingMetadata.attributeMatches(indexAttribute, "org.hibernate.search.annotations", "Index.YES", "YES");
        AnnotationElement.Value analyzeAttribute = fieldAnnotation.getAttributeValue("analyze");
        boolean isAnalyzed = IndexingMetadata.attributeMatches(analyzeAttribute, "org.hibernate.search.annotations", "Analyze.YES", "YES");
        AnnotationElement.Value storeAttribute = fieldAnnotation.getAttributeValue("store");
        boolean isStored = IndexingMetadata.attributeMatches(storeAttribute, "org.hibernate.search.annotations", "Store.YES", "YES");
        AnnotationElement.Value indexNullAsAttribute = fieldAnnotation.getAttributeValue("indexNullAs");
        String indexNullAs = (String)indexNullAsAttribute.getValue();
        if ("__DO_NOT_INDEX_NULL__".equals(indexNullAs)) {
            indexNullAs = null;
        }
        if ((fieldLevelAnalyzerAttribute = (String)(fieldLevelAnalyzerAnnotationAttribute = (AnnotationElement.Annotation)fieldAnnotation.getAttributeValue("analyzer").getValue()).getAttributeValue("definition").getValue()).isEmpty()) {
            fieldLevelAnalyzerAttribute = null;
        } else {
            fieldLevelAnalyzer = fieldLevelAnalyzerAttribute;
        }
        if (!(isAnalyzed || fieldLevelAnalyzer == null && fieldLevelAnalyzerAttribute == null)) {
            throw new IllegalStateException("Cannot specify an analyzer for field " + fd.getFullName() + " unless the field is analyzed.");
        }
        String analyzer = Search5MetadataCreator.analyzer(fd.getType(), isAnalyzed, fieldLevelAnalyzer);
        boolean sortable = Search5MetadataCreator.sortable(analyzer, isStored, isSortable);
        FieldMapping fieldMapping = FieldMapping.make(fd, fieldName, isIndexed, isStored, false, sortable).indexNullAs(indexNullAs).analyzer(analyzer).build();
        if (log.isDebugEnabled()) {
            log.debugf("fieldName=%s fieldMapping=%s", fieldName, fieldMapping);
        }
        return fieldMapping;
    }

    private static boolean sortable(String fieldLevelAnalyzer, boolean isStored, boolean isSortable) {
        if (fieldLevelAnalyzer != null) {
            return false;
        }
        return isSortable || isStored;
    }

    private static String analyzer(Type type, boolean analyze, String fieldLevelAnalyzer) {
        if (!Type.STRING.equals((Object)type) || !analyze) {
            return null;
        }
        return fieldLevelAnalyzer != null ? fieldLevelAnalyzer : "standard";
    }
}

