/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.commands.string;

import io.netty.channel.ChannelHandlerContext;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.server.resp.ByteBufferUtils;
import org.infinispan.server.resp.Resp3Handler;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.RespRequestHandler;
import org.infinispan.server.resp.commands.Resp3Command;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletionStages;

public class MGET
extends RespCommand
implements Resp3Command {
    public MGET() {
        super(-2, 1, -1, 1);
    }

    @Override
    public CompletionStage<RespRequestHandler> perform(Resp3Handler handler, ChannelHandlerContext ctx, List<byte[]> arguments) {
        int keysToRetrieve = arguments.size();
        if (keysToRetrieve == 0) {
            ByteBufferUtils.stringToByteBufAscii("*0\r\n", handler.allocator());
            return handler.myStage();
        }
        List results = Collections.synchronizedList(Arrays.asList(new byte[keysToRetrieve][]));
        AtomicInteger resultBytesSize = new AtomicInteger();
        AggregateCompletionStage getStage = CompletionStages.aggregateCompletionStage();
        for (int i = 0; i < keysToRetrieve; ++i) {
            int innerCount = i;
            byte[] keyBytes = arguments.get(i);
            getStage.dependsOn(handler.cache().getAsync((Object)keyBytes).whenComplete((returnValue, t) -> {
                if (returnValue != null) {
                    results.set(innerCount, returnValue);
                    int length = ((byte[])returnValue).length;
                    if (length > 0) {
                        resultBytesSize.addAndGet(1 + (int)Math.log10(length) + 1 + 2 + ((byte[])returnValue).length);
                    } else {
                        resultBytesSize.addAndGet(4);
                    }
                } else {
                    resultBytesSize.addAndGet(3);
                }
                resultBytesSize.addAndGet(2);
            }));
        }
        return handler.stageToReturn(getStage.freeze(), ctx, (ignore, alloc) -> ByteBufferUtils.bytesToResult(resultBytesSize.get(), results, alloc));
    }
}

