/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.provider.apache;

import java.io.IOException;
import java.util.Map;
import org.apache.directory.api.ldap.codec.api.ExtendedResponseDecorator;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.SearchCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.exception.LdapOperationException;
import org.apache.directory.api.ldap.model.message.AbandonRequest;
import org.apache.directory.api.ldap.model.message.AbandonRequestImpl;
import org.apache.directory.api.ldap.model.message.AddRequestImpl;
import org.apache.directory.api.ldap.model.message.AddResponse;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.BindRequestImpl;
import org.apache.directory.api.ldap.model.message.BindResponse;
import org.apache.directory.api.ldap.model.message.CompareRequestImpl;
import org.apache.directory.api.ldap.model.message.CompareResponse;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.DeleteRequestImpl;
import org.apache.directory.api.ldap.model.message.DeleteResponse;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.ModifyDnRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyDnResponse;
import org.apache.directory.api.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.api.ldap.model.message.ModifyResponse;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.message.SearchRequestImpl;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchResultEntry;
import org.apache.directory.api.ldap.model.message.SearchResultReference;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.directory.ldap.client.api.SaslCramMd5Request;
import org.apache.directory.ldap.client.api.SaslDigestMd5Request;
import org.apache.directory.ldap.client.api.SaslGssApiRequest;
import org.apache.directory.ldap.client.api.exception.InvalidConnectionException;
import org.ldaptive.AddRequest;
import org.ldaptive.BindRequest;
import org.ldaptive.CompareRequest;
import org.ldaptive.DeleteRequest;
import org.ldaptive.DerefAliases;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ModifyDnRequest;
import org.ldaptive.ModifyRequest;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.ResultCode;
import org.ldaptive.SearchEntry;
import org.ldaptive.SearchReference;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.control.RequestControl;
import org.ldaptive.control.ResponseControl;
import org.ldaptive.extended.ExtendedRequest;
import org.ldaptive.extended.ExtendedResponse;
import org.ldaptive.extended.ExtendedResponseFactory;
import org.ldaptive.extended.UnsolicitedNotificationListener;
import org.ldaptive.intermediate.IntermediateResponseFactory;
import org.ldaptive.provider.ControlProcessor;
import org.ldaptive.provider.ProviderConnection;
import org.ldaptive.provider.ProviderUtils;
import org.ldaptive.provider.SearchItem;
import org.ldaptive.provider.SearchIterator;
import org.ldaptive.provider.SearchListener;
import org.ldaptive.provider.apache.ApacheLdapProviderConfig;
import org.ldaptive.provider.apache.ApacheLdapSaslUtils;
import org.ldaptive.provider.apache.ApacheLdapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheLdapConnection
implements ProviderConnection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LdapNetworkConnection connection;
    private final ApacheLdapProviderConfig config;

    public ApacheLdapConnection(LdapNetworkConnection lc, ApacheLdapProviderConfig pc) {
        this.connection = lc;
        this.config = pc;
    }

    public LdapNetworkConnection getLdapConnection() {
        return this.connection;
    }

    public void close(RequestControl[] controls) throws LdapException {
        if (controls != null) {
            throw new UnsupportedOperationException("Provider does not support unbind with controls");
        }
        if (this.connection != null) {
            try {
                if (this.connection.isConnected()) {
                    this.connection.unBind();
                }
            }
            catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
                this.logger.error("Error unbinding from LDAP", (Throwable)e);
            }
            try {
                this.connection.close();
            }
            catch (IOException e) {
                throw new LdapException((Exception)e);
            }
            finally {
                this.connection = null;
            }
        }
    }

    public Response<Void> bind(BindRequest request) throws LdapException {
        Response<Void> response = request.getSaslConfig() != null ? this.saslBind(request) : (request.getDn() == null && request.getCredential() == null ? this.anonymousBind(request) : this.simpleBind(request));
        return response;
    }

    protected Response<Void> anonymousBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            BindRequestImpl bri = new BindRequestImpl();
            if (request.getControls() != null) {
                bri.addAllControls((Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            }
            BindResponse br = this.connection.bind((org.apache.directory.api.ldap.model.message.BindRequest)bri);
            this.throwOperationException((Request)request, (ResultResponse)br);
            response = this.createResponse((Request)request, null, (ResultResponse)br);
        }
        catch (LdapOperationException e) {
            this.processLdapOperationException(e);
        }
        catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
            this.processLdapException(e);
        }
        return response;
    }

    protected Response<Void> simpleBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            BindRequestImpl bri = new BindRequestImpl();
            if (request.getControls() != null) {
                bri.addAllControls((Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            }
            bri.setVersion3(true);
            bri.setSimple(true);
            bri.setDn(new Dn(new String[]{request.getDn()}));
            bri.setCredentials(request.getCredential().getBytes());
            BindResponse br = this.connection.bind((org.apache.directory.api.ldap.model.message.BindRequest)bri);
            this.throwOperationException((Request)request, (ResultResponse)br);
            response = this.createResponse((Request)request, null, (ResultResponse)br);
        }
        catch (LdapOperationException e) {
            this.processLdapOperationException(e);
        }
        catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
            this.processLdapException(e);
        }
        return response;
    }

    protected Response<Void> saslBind(BindRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            BindResponse br;
            switch (request.getSaslConfig().getMechanism()) {
                case EXTERNAL: {
                    throw new UnsupportedOperationException("SASL External not supported");
                }
                case DIGEST_MD5: {
                    SaslDigestMd5Request digestMd5Request = ApacheLdapSaslUtils.createDigestMd5Request(request.getDn(), request.getCredential(), request.getSaslConfig());
                    br = this.connection.bind(digestMd5Request);
                    break;
                }
                case CRAM_MD5: {
                    SaslCramMd5Request cramMd5Request = ApacheLdapSaslUtils.createCramMd5Request(request.getDn(), request.getCredential(), request.getSaslConfig());
                    br = this.connection.bind(cramMd5Request);
                    break;
                }
                case GSSAPI: {
                    SaslGssApiRequest gssApiRequest = ApacheLdapSaslUtils.createGssApiRequest(request.getDn(), request.getCredential(), request.getSaslConfig());
                    br = this.connection.bind(gssApiRequest);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown SASL authentication mechanism: " + request.getSaslConfig().getMechanism());
                }
            }
            this.throwOperationException((Request)request, (ResultResponse)br);
            response = this.createResponse((Request)request, null, (ResultResponse)br);
        }
        catch (LdapOperationException e) {
            this.processLdapOperationException(e);
        }
        catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
            this.processLdapException(e);
        }
        return response;
    }

    public Response<Void> add(AddRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            ApacheLdapUtils bu = new ApacheLdapUtils();
            AddRequestImpl ari = new AddRequestImpl();
            if (request.getControls() != null) {
                ari.addAllControls((Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            }
            ari.setEntry(bu.fromLdapEntry(new LdapEntry(request.getDn(), request.getLdapAttributes())));
            AddResponse ar = this.connection.add((org.apache.directory.api.ldap.model.message.AddRequest)ari);
            this.throwOperationException((Request)request, (ResultResponse)ar);
            response = this.createResponse((Request)request, null, (ResultResponse)ar);
        }
        catch (LdapOperationException e) {
            this.processLdapOperationException(e);
        }
        catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
            this.processLdapException(e);
        }
        return response;
    }

    public Response<Boolean> compare(CompareRequest request) throws LdapException {
        Response<Boolean> response = null;
        try {
            CompareRequestImpl cri = new CompareRequestImpl();
            if (request.getControls() != null) {
                cri.addAllControls((Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            }
            cri.setName(new Dn(new String[]{request.getDn()}));
            cri.setAttributeId(request.getAttribute().getName());
            if (request.getAttribute().isBinary()) {
                cri.setAssertionValue(request.getAttribute().getBinaryValue());
            } else {
                cri.setAssertionValue(request.getAttribute().getStringValue());
            }
            CompareResponse cr = this.connection.compare((org.apache.directory.api.ldap.model.message.CompareRequest)cri);
            this.throwOperationException((Request)request, (ResultResponse)cr);
            response = this.createResponse((Request)request, cr.isTrue(), (ResultResponse)cr);
        }
        catch (LdapOperationException e) {
            this.processLdapOperationException(e);
        }
        catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
            this.processLdapException(e);
        }
        return response;
    }

    public Response<Void> delete(DeleteRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            DeleteRequestImpl dri = new DeleteRequestImpl();
            if (request.getControls() != null) {
                dri.addAllControls((Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            }
            dri.setName(new Dn(new String[]{request.getDn()}));
            DeleteResponse dr = this.connection.delete((org.apache.directory.api.ldap.model.message.DeleteRequest)dri);
            this.throwOperationException((Request)request, (ResultResponse)dr);
            response = this.createResponse((Request)request, null, (ResultResponse)dr);
        }
        catch (LdapOperationException e) {
            this.processLdapOperationException(e);
        }
        catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
            this.processLdapException(e);
        }
        return response;
    }

    public Response<Void> modify(ModifyRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            ApacheLdapUtils bu = new ApacheLdapUtils();
            ModifyRequestImpl mri = new ModifyRequestImpl();
            if (request.getControls() != null) {
                mri.addAllControls((Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            }
            mri.setName(new Dn(new String[]{request.getDn()}));
            for (Modification m : bu.fromAttributeModification(request.getAttributeModifications())) {
                mri.addModification(m);
            }
            ModifyResponse mr = this.connection.modify((org.apache.directory.api.ldap.model.message.ModifyRequest)mri);
            this.throwOperationException((Request)request, (ResultResponse)mr);
            response = this.createResponse((Request)request, null, (ResultResponse)mr);
        }
        catch (LdapOperationException e) {
            this.processLdapOperationException(e);
        }
        catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
            this.processLdapException(e);
        }
        return response;
    }

    public Response<Void> modifyDn(ModifyDnRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            Dn dn = new Dn(new String[]{request.getDn()});
            Dn newDn = new Dn(new String[]{request.getNewDn()});
            ModifyDnRequestImpl mdri = new ModifyDnRequestImpl();
            if (request.getControls() != null) {
                mdri.addAllControls((Control[])this.config.getControlProcessor().processRequestControls(request.getControls()));
            }
            mdri.setName(dn);
            mdri.setNewRdn(newDn.getRdn());
            mdri.setNewSuperior(newDn.getParent());
            mdri.setDeleteOldRdn(request.getDeleteOldRDn());
            ModifyDnResponse mdr = this.connection.modifyDn((org.apache.directory.api.ldap.model.message.ModifyDnRequest)mdri);
            this.throwOperationException((Request)request, (ResultResponse)mdr);
            response = this.createResponse((Request)request, null, (ResultResponse)mdr);
        }
        catch (LdapOperationException e) {
            this.processLdapOperationException(e);
        }
        catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
            this.processLdapException(e);
        }
        return response;
    }

    public SearchIterator search(SearchRequest request) throws LdapException {
        ApacheLdapSearchIterator i = new ApacheLdapSearchIterator(request);
        i.initialize();
        return i;
    }

    public void searchAsync(SearchRequest request, SearchListener listener) throws LdapException {
        ApacheLdapSearchListener l = new ApacheLdapSearchListener(request, listener);
        l.initialize();
    }

    public void abandon(int messageId, RequestControl[] controls) throws LdapException {
        AbandonRequestImpl ari = new AbandonRequestImpl();
        if (controls != null) {
            ari.addAllControls((Control[])this.config.getControlProcessor().processRequestControls(controls));
        }
        ari.setAbandoned(messageId);
        this.connection.abandon((AbandonRequest)ari);
    }

    public Response<?> extendedOperation(ExtendedRequest request) throws LdapException {
        Response<Object> response = null;
        try {
            org.apache.directory.api.ldap.model.message.ExtendedResponse apacheExtRes = this.connection.extended(request.getOID(), request.encode());
            this.throwOperationException((Request)request, (ResultResponse)apacheExtRes);
            byte[] responseValue = null;
            if (apacheExtRes instanceof ExtendedResponseDecorator) {
                responseValue = ((ExtendedResponseDecorator)apacheExtRes).getResponseValue();
            }
            ExtendedResponse extRes = ExtendedResponseFactory.createExtendedResponse((String)request.getOID(), (String)apacheExtRes.getResponseName(), (byte[])responseValue);
            response = this.createResponse((Request)request, extRes.getValue(), (ResultResponse)apacheExtRes);
        }
        catch (LdapOperationException e) {
            this.processLdapOperationException(e);
        }
        catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
            this.processLdapException(e);
        }
        return response;
    }

    public void addUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
        throw new UnsupportedOperationException("Unsolicited notifications not supported");
    }

    public void removeUnsolicitedNotificationListener(UnsolicitedNotificationListener listener) {
        throw new UnsupportedOperationException("Unsolicited notifications not supported");
    }

    protected void throwOperationException(Request request, ResultResponse resultResponse) throws LdapException {
        LdapResult ldapResult = resultResponse.getLdapResult();
        Referral ref = ldapResult.getReferral();
        ProviderUtils.throwOperationException((ResultCode[])this.config.getOperationExceptionResultCodes(), (String)String.format("Ldap returned result code: %s", ldapResult.getResultCode()), (int)ldapResult.getResultCode().getResultCode(), (String)(ldapResult.getMatchedDn() != null ? ldapResult.getMatchedDn().getName() : null), (ResponseControl[])this.processResponseControls((ControlProcessor<Control>)this.config.getControlProcessor(), (RequestControl[])request.getControls(), (Message)resultResponse), ref != null ? ref.getLdapUrls().toArray(new String[ref.getReferralLength()]) : null, (boolean)false);
    }

    protected <T> Response<T> createResponse(Request request, T result, ResultResponse resultResponse) {
        LdapResult ldapResult = resultResponse.getLdapResult();
        Referral ref = ldapResult.getReferral();
        return new Response(result, ResultCode.valueOf((int)ldapResult.getResultCode().getValue()), ldapResult.getDiagnosticMessage(), ldapResult.getMatchedDn() != null ? ldapResult.getMatchedDn().getName() : null, this.processResponseControls((ControlProcessor<Control>)this.config.getControlProcessor(), (RequestControl[])request.getControls(), (Message)resultResponse), ref != null ? ref.getLdapUrls().toArray(new String[ref.getReferralLength()]) : null, resultResponse.getMessageId());
    }

    protected void processLdapOperationException(LdapOperationException e) throws LdapException {
        ProviderUtils.throwOperationException((ResultCode[])this.config.getOperationExceptionResultCodes(), (Exception)((Object)e), (int)(e.getResultCode() != null ? Integer.valueOf(e.getResultCode().getResultCode()) : null), (String)(e.getResolvedDn() != null ? e.getResolvedDn().getName() : null), null, null, (boolean)true);
    }

    protected void processLdapException(org.apache.directory.api.ldap.model.exception.LdapException e) throws LdapException {
        if (e instanceof InvalidConnectionException) {
            ProviderUtils.throwOperationException((ResultCode[])this.config.getOperationExceptionResultCodes(), (Exception)((Object)e), (int)ResultCode.SERVER_DOWN.value(), null, null, null, (boolean)true);
        }
        throw new LdapException((Exception)((Object)e));
    }

    public ResponseControl[] processResponseControls(ControlProcessor<Control> processor, RequestControl[] requestControls, Message response) {
        return processor.processResponseControls((Object[])this.getResponseControls(response));
    }

    public Control[] getResponseControls(Message response) {
        Control[] ctls = null;
        if (response != null) {
            Map respControls = response.getControls();
            ctls = respControls.values().toArray(new Control[respControls.size()]);
        }
        return ctls;
    }

    protected abstract class AbstractApacheLdapSearch {
        protected final SearchRequest request;
        protected final ApacheLdapUtils util;

        public AbstractApacheLdapSearch(SearchRequest sr) {
            this.request = sr;
            this.util = new ApacheLdapUtils(sr.getSortBehavior());
            this.util.setBinaryAttributes(sr.getBinaryAttributes());
        }

        protected SearchCursor search(LdapNetworkConnection conn, SearchRequest sr) throws org.apache.directory.api.ldap.model.exception.LdapException {
            org.apache.directory.api.ldap.model.message.SearchRequest apacheSr = this.getSearchRequest(sr);
            Control[] c = (Control[])ApacheLdapConnection.this.config.getControlProcessor().processRequestControls(sr.getControls());
            if (c != null) {
                apacheSr.addAllControls(c);
            }
            return conn.search(apacheSr);
        }

        protected org.apache.directory.api.ldap.model.message.SearchRequest getSearchRequest(SearchRequest sr) throws org.apache.directory.api.ldap.model.exception.LdapException {
            org.apache.directory.api.ldap.model.message.SearchScope searchScope;
            SearchRequestImpl apacheSr = new SearchRequestImpl();
            if (sr.getReturnAttributes() != null) {
                apacheSr.addAttributes(sr.getReturnAttributes());
            }
            apacheSr.setBase(new Dn(new String[]{sr.getBaseDn()}));
            AliasDerefMode deref = this.getAliasDerefMode(sr.getDerefAliases());
            if (deref != null) {
                apacheSr.setDerefAliases(deref);
            } else {
                apacheSr.setDerefAliases(AliasDerefMode.NEVER_DEREF_ALIASES);
            }
            if (sr.getSearchFilter() != null) {
                apacheSr.setFilter(sr.getSearchFilter().format());
            }
            if ((searchScope = this.getSearchScope(sr.getSearchScope())) != null) {
                apacheSr.setScope(searchScope);
            }
            apacheSr.setSizeLimit(sr.getSizeLimit());
            apacheSr.setTimeLimit((int)sr.getTimeLimit().getSeconds());
            apacheSr.setTypesOnly(sr.getTypesOnly());
            return apacheSr;
        }

        protected org.apache.directory.api.ldap.model.message.SearchScope getSearchScope(SearchScope ss) {
            org.apache.directory.api.ldap.model.message.SearchScope scope = null;
            if (ss == SearchScope.OBJECT) {
                scope = org.apache.directory.api.ldap.model.message.SearchScope.OBJECT;
            } else if (ss == SearchScope.ONELEVEL) {
                scope = org.apache.directory.api.ldap.model.message.SearchScope.ONELEVEL;
            } else if (ss == SearchScope.SUBTREE) {
                scope = org.apache.directory.api.ldap.model.message.SearchScope.SUBTREE;
            }
            return scope;
        }

        protected AliasDerefMode getAliasDerefMode(DerefAliases deref) {
            AliasDerefMode mode = null;
            if (deref == DerefAliases.ALWAYS) {
                mode = AliasDerefMode.DEREF_ALWAYS;
            } else if (deref == DerefAliases.FINDING) {
                mode = AliasDerefMode.DEREF_FINDING_BASE_OBJ;
            } else if (deref == DerefAliases.NEVER) {
                mode = AliasDerefMode.NEVER_DEREF_ALIASES;
            } else if (deref == DerefAliases.SEARCHING) {
                mode = AliasDerefMode.DEREF_IN_SEARCHING;
            }
            return mode;
        }

        protected SearchItem processSearchResultEntry(SearchResultEntry entry) {
            ApacheLdapConnection.this.logger.trace("reading search entry: {}", (Object)entry);
            Entry e = entry.getEntry();
            ResponseControl[] respControls = null;
            if (entry.getControls() != null && entry.getControls().size() > 0) {
                respControls = ApacheLdapConnection.this.processResponseControls((ControlProcessor<Control>)ApacheLdapConnection.this.config.getControlProcessor(), this.request.getControls(), (Message)entry);
            }
            SearchEntry se = this.util.toSearchEntry(e, respControls, entry.getMessageId());
            return new SearchItem(se);
        }

        protected SearchItem processSearchResultReference(SearchResultReference ref) {
            ApacheLdapConnection.this.logger.trace("reading search reference: {}", (Object)ref);
            Referral r = ref.getReferral();
            ResponseControl[] respControls = null;
            if (ref.getControls() != null && ref.getControls().size() > 0) {
                respControls = ApacheLdapConnection.this.processResponseControls((ControlProcessor<Control>)ApacheLdapConnection.this.config.getControlProcessor(), this.request.getControls(), (Message)ref);
            }
            SearchReference sr = new SearchReference(ref.getMessageId(), respControls, r.getLdapUrls());
            return new SearchItem(sr);
        }

        protected SearchItem processIntermediateResponse(IntermediateResponse res) {
            ApacheLdapConnection.this.logger.trace("reading intermediate response: {}", (Object)res);
            ResponseControl[] respControls = null;
            if (res.getControls() != null && res.getControls().size() > 0) {
                respControls = ApacheLdapConnection.this.processResponseControls((ControlProcessor<Control>)ApacheLdapConnection.this.config.getControlProcessor(), this.request.getControls(), (Message)res);
            }
            org.ldaptive.intermediate.IntermediateResponse ir = IntermediateResponseFactory.createIntermediateResponse((String)res.getResponseName(), (byte[])res.getResponseValue(), respControls, (int)res.getMessageId());
            return new SearchItem(ir);
        }
    }

    protected class ApacheLdapSearchListener
    extends AbstractApacheLdapSearch {
        private final SearchListener listener;

        public ApacheLdapSearchListener(SearchRequest sr, SearchListener sl) {
            super(sr);
            this.listener = sl;
        }

        public void initialize() throws LdapException {
            boolean closeCursor = false;
            SearchCursor cursor = null;
            try {
                cursor = this.search(ApacheLdapConnection.this.connection, this.request);
                while (cursor.next()) {
                    org.apache.directory.api.ldap.model.message.Response curRes = (org.apache.directory.api.ldap.model.message.Response)cursor.get();
                    if (curRes instanceof SearchResultEntry) {
                        this.listener.searchItemReceived(this.processSearchResultEntry((SearchResultEntry)curRes));
                        continue;
                    }
                    if (curRes instanceof SearchResultReference) {
                        this.listener.searchItemReceived(this.processSearchResultReference((SearchResultReference)curRes));
                        continue;
                    }
                    if (!(curRes instanceof IntermediateResponse)) continue;
                    this.listener.searchItemReceived(this.processIntermediateResponse((IntermediateResponse)curRes));
                }
                SearchResultDone done = cursor.getSearchResultDone();
                Response<Object> response = ApacheLdapConnection.this.createResponse((Request)this.request, null, (ResultResponse)done);
                this.listener.responseReceived(response);
            }
            catch (LdapOperationException e) {
                closeCursor = true;
                ApacheLdapConnection.this.processLdapOperationException(e);
            }
            catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
                closeCursor = true;
                ApacheLdapConnection.this.processLdapException(e);
            }
            catch (RuntimeException e) {
                closeCursor = true;
                throw e;
            }
            catch (Exception e) {
                closeCursor = true;
                throw new LdapException(e);
            }
            finally {
                if (closeCursor) {
                    try {
                        if (cursor != null) {
                            cursor.close();
                        }
                    }
                    catch (Exception e) {
                        ApacheLdapConnection.this.logger.debug("Error closing search cursor", (Throwable)e);
                    }
                }
            }
        }
    }

    protected class ApacheLdapSearchIterator
    extends AbstractApacheLdapSearch
    implements SearchIterator {
        private Response<Void> response;
        private SearchCursor cursor;

        public ApacheLdapSearchIterator(SearchRequest sr) {
            super(sr);
        }

        public void initialize() throws LdapException {
            boolean closeCursor = false;
            try {
                this.cursor = this.search(ApacheLdapConnection.this.connection, this.request);
            }
            catch (LdapOperationException e) {
                closeCursor = true;
                ApacheLdapConnection.this.processLdapOperationException(e);
            }
            catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
                closeCursor = true;
                ApacheLdapConnection.this.processLdapException(e);
            }
            catch (RuntimeException e) {
                closeCursor = true;
                throw e;
            }
            catch (Exception e) {
                closeCursor = true;
                throw new LdapException(e);
            }
            finally {
                if (closeCursor) {
                    try {
                        if (this.cursor != null) {
                            this.cursor.close();
                        }
                    }
                    catch (Exception e) {
                        ApacheLdapConnection.this.logger.debug("Error closing search cursor", (Throwable)e);
                    }
                }
            }
        }

        public boolean hasNext() throws LdapException {
            if (this.cursor == null || this.response != null) {
                return false;
            }
            boolean more = false;
            try {
                more = this.cursor.next();
                if (!more) {
                    SearchResultDone done = this.cursor.getSearchResultDone();
                    ApacheLdapConnection.this.logger.trace("reading search result done: {}", (Object)done);
                    ApacheLdapConnection.this.throwOperationException((Request)this.request, (ResultResponse)done);
                    LdapResult ldapResult = done.getLdapResult();
                    this.response = ApacheLdapConnection.this.createResponse((Request)this.request, null, (ResultResponse)done);
                }
            }
            catch (LdapOperationException e) {
                ApacheLdapConnection.this.processLdapOperationException(e);
            }
            catch (org.apache.directory.api.ldap.model.exception.LdapException e) {
                ApacheLdapConnection.this.processLdapException(e);
            }
            catch (RuntimeException | LdapException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LdapException(e);
            }
            return more;
        }

        public SearchItem next() throws LdapException {
            SearchItem si = null;
            try {
                org.apache.directory.api.ldap.model.message.Response curRes = (org.apache.directory.api.ldap.model.message.Response)this.cursor.get();
                if (curRes instanceof SearchResultEntry) {
                    si = this.processSearchResultEntry((SearchResultEntry)curRes);
                } else if (curRes instanceof SearchResultReference) {
                    si = this.processSearchResultReference((SearchResultReference)curRes);
                } else if (curRes instanceof IntermediateResponse) {
                    si = this.processIntermediateResponse((IntermediateResponse)curRes);
                }
            }
            catch (CursorException e) {
                throw new LdapException((Exception)((Object)e));
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new LdapException(e);
            }
            return si;
        }

        public Response<Void> getResponse() {
            return this.response;
        }

        public void close() throws LdapException {
        }
    }
}

