/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Case;
import org.neo4j.cypherdsl.core.Clause;
import org.neo4j.cypherdsl.core.Clauses;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExposesRelationships;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Finish;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Hint;
import org.neo4j.cypherdsl.core.IdentifiableElement;
import org.neo4j.cypherdsl.core.KeyValueMapEntry;
import org.neo4j.cypherdsl.core.LabelExpression;
import org.neo4j.cypherdsl.core.ListComprehension;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.MapProjection;
import org.neo4j.cypherdsl.core.MergeAction;
import org.neo4j.cypherdsl.core.NamedPath;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.PatternComprehension;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.QuantifiedPathPattern;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.Return;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.neo4j.cypherdsl.core.StringLiteral;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.ast.TypedSubtree;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.parser.DatabaseName;
import org.neo4j.cypherdsl.parser.EntityType;
import org.neo4j.cypherdsl.parser.ExpressionAsPatternElementWrapper;
import org.neo4j.cypherdsl.parser.ExpressionCreatedEventType;
import org.neo4j.cypherdsl.parser.InfinityLiteral;
import org.neo4j.cypherdsl.parser.InputPosition;
import org.neo4j.cypherdsl.parser.InvocationCreatedEventType;
import org.neo4j.cypherdsl.parser.LabelParsedEventType;
import org.neo4j.cypherdsl.parser.MatchDefinition;
import org.neo4j.cypherdsl.parser.NaNLiteral;
import org.neo4j.cypherdsl.parser.NodeAtom;
import org.neo4j.cypherdsl.parser.Options;
import org.neo4j.cypherdsl.parser.ParenthesizedPathPatternAtom;
import org.neo4j.cypherdsl.parser.PathAtom;
import org.neo4j.cypherdsl.parser.PathLength;
import org.neo4j.cypherdsl.parser.PatternAtom;
import org.neo4j.cypherdsl.parser.PatternElementAsExpressionWrapper;
import org.neo4j.cypherdsl.parser.PatternElementCreatedEventType;
import org.neo4j.cypherdsl.parser.PatternElementFunctions;
import org.neo4j.cypherdsl.parser.ReturnDefinition;
import org.neo4j.cypherdsl.parser.Statements;
import org.neo4j.cypherdsl.parser.TypeParsedEventType;
import org.neo4j.cypherdsl.parser.internal.ast.factory.ASTFactory;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.AccessType;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.ActionType;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.CallInTxsOnErrorBehaviourType;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.ConstraintType;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.CreateIndexTypes;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.HintIndexType;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.ParameterType;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.ParserCypherTypeName;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.ParserNormalForm;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.ParserTrimSpecification;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.ScopeType;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.ShowCommandFilterTypes;
import org.neo4j.cypherdsl.parser.internal.parser.common.ast.factory.SimpleEither;

@API(status=API.Status.INTERNAL, since="2021.3.0")
final class CypherDslASTFactory
implements ASTFactory<Statements, Statement, Statement, Clause, Finish, Return, Expression, List<Expression>, SortItem, PatternElement, NodeAtom, PathAtom, PathLength, Clause, Expression, Expression, Expression, Hint, Expression, LabelExpression, Expression, Parameter<?>, Expression, Property, Expression, Clause, Statement, Statement, Statement, Clause, Where, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, ASTFactory.NULL, InputPosition, EntityType, QuantifiedPathPattern.Quantifier, PatternAtom, DatabaseName, ASTFactory.NULL, ASTFactory.NULL, PatternElement> {
    private static CypherDslASTFactory instanceFromDefaultOptions;
    private final Options options;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static CypherDslASTFactory getInstance(Options options) {
        if (options != null && !options.areDefault()) {
            return new CypherDslASTFactory(options);
        }
        CypherDslASTFactory instance = instanceFromDefaultOptions;
        if (instance != null) return instance;
        Class<CypherDslASTFactory> clazz = CypherDslASTFactory.class;
        synchronized (CypherDslASTFactory.class) {
            instance = instanceFromDefaultOptions;
            if (instance != null) return instance;
            instanceFromDefaultOptions = new CypherDslASTFactory(Optional.ofNullable(options).orElseGet(Options::defaultOptions));
            return instanceFromDefaultOptions;
        }
    }

    private CypherDslASTFactory(Options options) {
        this.options = options;
    }

    private String[] computeFinalLabelList(LabelParsedEventType event, List<ASTFactory.StringPos<InputPosition>> inputLabels) {
        return inputLabels == null ? new String[]{} : this.options.getLabelFilter().apply(event, inputLabels.stream().map(v -> v.string).toList()).toArray(new String[0]);
    }

    private Optional<String[]> computeFinalLabelList(LabelParsedEventType event, LabelExpression inputLabels) {
        if (inputLabels == null) {
            return Optional.of(new String[0]);
        }
        if (inputLabels.type() == LabelExpression.Type.COLON_CONJUNCTION || inputLabels.type() == LabelExpression.Type.LEAF && inputLabels.value() != null) {
            return Optional.of(this.options.getLabelFilter().apply(event, inputLabels.value()).toArray(new String[0]));
        }
        return Optional.empty();
    }

    private String[] computeFinalTypeList(TypeParsedEventType event, LabelExpression inputTypes) {
        if (inputTypes == null) {
            return new String[0];
        }
        if (inputTypes.negated() && inputTypes.value().size() > 1 || inputTypes.type() == LabelExpression.Type.CONJUNCTION) {
            throw new UnsupportedOperationException("Expressions for relationship types are not supported in Cypher-DSL");
        }
        ArrayList<String> types = new ArrayList<String>();
        this.traverseTypeExpression(types, inputTypes);
        return this.options.getTypeFilter().apply(event, types).toArray(new String[0]);
    }

    void traverseTypeExpression(List<String> types, LabelExpression expression) {
        if (expression.type() == LabelExpression.Type.LEAF || expression.type() == LabelExpression.Type.COLON_DISJUNCTION) {
            types.addAll(expression.value());
        } else {
            this.traverseTypeExpression(types, expression.lhs());
            this.traverseTypeExpression(types, expression.rhs());
        }
    }

    static void isInstanceOf(Class<?> type, Object obj, String message) {
        if (type == null) {
            throw new IllegalArgumentException("Type to check against must not be null");
        }
        if (!type.isInstance(obj)) {
            throw new IllegalArgumentException(message);
        }
    }

    private static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private <T extends Expression> T applyCallbacksFor(ExpressionCreatedEventType type, T newExpression) {
        return this.applyCallbacksFor(type, List.of(newExpression)).get(0);
    }

    private <T extends Expression> List<T> applyCallbacksFor(ExpressionCreatedEventType type, List<T> expressions) {
        List callbacks = this.options.getOnNewExpressionCallbacks().getOrDefault((Object)type, List.of());
        if (callbacks.isEmpty()) {
            return expressions;
        }
        Function chainedCallbacks = callbacks.stream().reduce(Function.identity(), Function::andThen);
        return expressions.stream().map(e -> (Expression)chainedCallbacks.apply(e)).toList();
    }

    private <T extends Visitable> T applyCallbacksFor(InvocationCreatedEventType type, T newExpression) {
        List callbacks = this.options.getOnNewInvocationCallbacks().getOrDefault((Object)type, List.of());
        if (callbacks.isEmpty()) {
            return newExpression;
        }
        Object result = newExpression;
        for (UnaryOperator callback : callbacks) {
            result = (Visitable)callback.apply(result);
        }
        return result;
    }

    private static SymbolicName assertSymbolicName(@Nullable Expression v) {
        if (v == null) {
            return null;
        }
        CypherDslASTFactory.isInstanceOf(SymbolicName.class, v, "An invalid type has been generated where a SymbolicName was required. Generated type was " + v.getClass().getName());
        return (SymbolicName)v;
    }

    @Override
    public Statements statements(List<Statement> statements) {
        return new Statements(statements);
    }

    @Override
    public Statement newSingleQuery(InputPosition p, List<Clause> clauses) {
        return this.newSingleQuery(clauses);
    }

    @Override
    public Statement newSingleQuery(List<Clause> clauses) {
        return Statement.of(clauses);
    }

    @Override
    public Statement newUnion(InputPosition p, Statement lhs, Statement rhs, boolean all) {
        if (all) {
            return Cypher.unionAll((Statement[])new Statement[]{lhs, rhs});
        }
        return Cypher.union((Statement[])new Statement[]{lhs, rhs});
    }

    @Override
    public Clause directUseClause(InputPosition p, DatabaseName databaseName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause functionUseClause(InputPosition p, Expression function) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Finish newFinishClause(InputPosition p) {
        return Finish.create();
    }

    @Override
    public List<Expression> newReturnItems(InputPosition p, boolean returnAll, List<Expression> returnItems) {
        List<Expression> finalReturnItems = returnItems;
        if (returnAll) {
            finalReturnItems = Stream.concat(Stream.of(Cypher.asterisk()), finalReturnItems.stream()).toList();
        }
        if (finalReturnItems.isEmpty()) {
            if (!returnAll) {
                throw new IllegalArgumentException("Cannot return nothing.");
            }
            finalReturnItems = Collections.singletonList(Cypher.asterisk());
        }
        return finalReturnItems;
    }

    @Override
    public Return newReturnClause(InputPosition p, boolean distinct, List<Expression> returnItems, List<SortItem> sortItems, InputPosition orderPos, Expression skip, InputPosition skipPosition, Expression limit, InputPosition limitPosition) {
        return this.options.getReturnClauseFactory().apply(new ReturnDefinition(distinct, returnItems, sortItems, skip, limit));
    }

    @Override
    public Expression newReturnItem(InputPosition p, Expression e, Expression v) {
        SymbolicName s = CypherDslASTFactory.assertSymbolicName(v);
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_RETURN_ITEM, e.as(s));
    }

    @Override
    public Expression newReturnItem(InputPosition p, Expression e, int eStartOffset, int eEndOffset) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_RETURN_ITEM, e);
    }

    @Override
    public SortItem orderDesc(InputPosition p, Expression e) {
        return e.descending();
    }

    @Override
    public SortItem orderAsc(InputPosition p, Expression e) {
        return e.ascending();
    }

    @Override
    public Clause withClause(InputPosition p, Return returnClause, Where where) {
        return Clauses.with((Return)returnClause, (Where)where);
    }

    @Override
    public Clause matchClause(InputPosition p, boolean optional, ASTFactory.NULL matchMode, List<PatternElement> patternElements, InputPosition patternPos, List<Hint> hints, Where whereIn) {
        List<UnaryOperator<PatternElement>> patternElementCallbacks = this.options.getOnNewPatternElementCallbacks().getOrDefault((Object)PatternElementCreatedEventType.ON_MATCH, List.of());
        ArrayList<PatternElement> openForTransformation = new ArrayList<PatternElement>();
        for (PatternElement patternElement : patternElements) {
            if (patternElement instanceof NodeAtom) {
                NodeAtom nodeAtom = (NodeAtom)patternElement;
                openForTransformation.add((PatternElement)nodeAtom.value());
                continue;
            }
            openForTransformation.add(patternElement);
        }
        List<PatternElement> transformedPatternElements = this.transformIfPossible(patternElementCallbacks, openForTransformation);
        return (Clause)this.options.getMatchClauseFactory().apply(new MatchDefinition(optional, transformedPatternElements, whereIn, hints));
    }

    private List<PatternElement> transformIfPossible(List<UnaryOperator<PatternElement>> callbacks, List<PatternElement> patternElements) {
        if (callbacks.isEmpty()) {
            return patternElements;
        }
        Function transformer = Function.identity();
        for (UnaryOperator<PatternElement> callback : callbacks) {
            transformer = transformer.andThen(callback);
        }
        return patternElements.stream().map(transformer).filter(Objects::nonNull).toList();
    }

    @Override
    public Hint usingIndexHint(InputPosition p, Expression v, String labelOrRelType, List<String> properties, boolean seekOnly, HintIndexType indexType) {
        Node node = Cypher.node((String)labelOrRelType, (String[])new String[0]).named(CypherDslASTFactory.assertSymbolicName(v));
        return Hint.useIndexFor((boolean)seekOnly, (Property[])((Property[])properties.stream().map(arg_0 -> ((Node)node).property(arg_0)).toArray(Property[]::new)));
    }

    @Override
    public Hint usingJoin(InputPosition p, List<Expression> joinVariables) {
        return Hint.useJoinOn((SymbolicName[])((SymbolicName[])joinVariables.stream().map(CypherDslASTFactory::assertSymbolicName).toArray(SymbolicName[]::new)));
    }

    @Override
    public Hint usingScan(InputPosition p, Expression v, String label) {
        SymbolicName s = CypherDslASTFactory.assertSymbolicName(v);
        return Hint.useScanFor((Node)Cypher.node((String)label, (String[])new String[0]).named(s));
    }

    @Override
    public Clause createClause(InputPosition p, List<PatternElement> patternElements) {
        List<UnaryOperator<PatternElement>> callbacks = this.options.getOnNewPatternElementCallbacks().getOrDefault((Object)PatternElementCreatedEventType.ON_CREATE, List.of());
        return Clauses.create(this.transformIfPossible(callbacks, patternElements.stream().map(v -> {
            PatternElement patternElement;
            if (v instanceof NodeAtom) {
                NodeAtom n = (NodeAtom)v;
                patternElement = n.value();
            } else {
                patternElement = v;
            }
            return patternElement;
        }).toList()));
    }

    @Override
    public Clause insertClause(InputPosition p, List<PatternElement> patternElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause setClause(InputPosition p, List<Expression> setItems) {
        return Clauses.set(setItems);
    }

    @Override
    public Operation setProperty(Property property, Expression value) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_SET_PROPERTY, property.to(value));
    }

    @Override
    public Expression setDynamicProperty(Expression dynamicProperty, Expression value) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_SET_PROPERTY, Cypher.set((Expression)dynamicProperty, (Expression)value));
    }

    @Override
    public Operation setVariable(Expression v, Expression value) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_SET_VARIABLE, Cypher.set((Expression)v, (Expression)value));
    }

    @Override
    public Operation addAndSetVariable(Expression v, Expression value) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_ADD_AND_SET_VARIABLE, Cypher.mutate((Expression)v, (Expression)value));
    }

    @Override
    public Expression setLabels(Expression v, List<ASTFactory.StringPos<InputPosition>> values, List<Expression> dynamicLabels, boolean containsIs) {
        SymbolicName s = CypherDslASTFactory.assertSymbolicName(v);
        String[] labels = this.computeFinalLabelList(LabelParsedEventType.ON_SET, values);
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_SET_LABELS, Cypher.setLabel((Node)Cypher.anyNode((SymbolicName)s), (String[])labels));
    }

    @Override
    public Clause removeClause(InputPosition p, List<Expression> removeItems) {
        return Clauses.remove(removeItems);
    }

    @Override
    public Expression removeProperty(Property property) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_REMOVE_PROPERTY, property);
    }

    @Override
    public Expression removeDynamicProperty(Expression dynamicProperty) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_REMOVE_PROPERTY, dynamicProperty);
    }

    @Override
    public Expression removeLabels(Expression v, List<ASTFactory.StringPos<InputPosition>> values, List<Expression> dynamicLabels, boolean containsIs) {
        SymbolicName s = CypherDslASTFactory.assertSymbolicName(v);
        String[] labels = this.computeFinalLabelList(LabelParsedEventType.ON_REMOVE, values);
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_REMOVE_LABELS, Cypher.removeLabel((Node)Cypher.anyNode((SymbolicName)s), (String[])labels));
    }

    @Override
    public Clause deleteClause(InputPosition p, boolean detach, List<Expression> expressions) {
        return Clauses.delete((boolean)detach, this.applyCallbacksFor(ExpressionCreatedEventType.ON_DELETE_ITEM, expressions));
    }

    @Override
    public Clause unwindClause(InputPosition p, Expression e, Expression v) {
        return Clauses.unwind((Expression)e, (SymbolicName)CypherDslASTFactory.assertSymbolicName(v));
    }

    @Override
    public Clause mergeClause(InputPosition p, PatternElement patternElementIn, List<Clause> setClauses, List<ASTFactory.MergeActionType> actionTypes, List<InputPosition> positions) {
        PatternElement patternElement;
        if (patternElementIn instanceof NodeAtom) {
            NodeAtom n = (NodeAtom)patternElementIn;
            patternElement = n.value();
        } else {
            patternElement = patternElementIn;
        }
        PatternElement patternElement2 = patternElement;
        ArrayList<MergeAction> mergeActions = new ArrayList<MergeAction>();
        if (setClauses != null && !setClauses.isEmpty() && actionTypes != null && !actionTypes.isEmpty()) {
            Iterator<Clause> iteratorClauses = setClauses.iterator();
            Iterator<ASTFactory.MergeActionType> iteratorTypes = actionTypes.iterator();
            block4: while (iteratorClauses.hasNext() && iteratorTypes.hasNext()) {
                ASTFactory.MergeActionType type = iteratorTypes.next();
                switch (type) {
                    case OnCreate: {
                        mergeActions.add(MergeAction.of((MergeAction.Type)MergeAction.Type.ON_CREATE, (org.neo4j.cypherdsl.core.Set)((org.neo4j.cypherdsl.core.Set)iteratorClauses.next())));
                        continue block4;
                    }
                    case OnMatch: {
                        mergeActions.add(MergeAction.of((MergeAction.Type)MergeAction.Type.ON_MATCH, (org.neo4j.cypherdsl.core.Set)((org.neo4j.cypherdsl.core.Set)iteratorClauses.next())));
                        continue block4;
                    }
                }
                throw new IllegalArgumentException("Unsupported MergeActionType: " + String.valueOf((Object)type));
            }
        }
        List<UnaryOperator<PatternElement>> callbacks = this.options.getOnNewPatternElementCallbacks().getOrDefault((Object)PatternElementCreatedEventType.ON_MERGE, List.of());
        return Clauses.merge(this.transformIfPossible(callbacks, List.of(patternElement2)), mergeActions);
    }

    @Override
    public Clause callClause(InputPosition p, InputPosition namespacePosition, InputPosition procedureNamePosition, InputPosition procedureResultPosition, List<String> namespace, String name, List<Expression> arguments, boolean yieldAll, List<Expression> resultItems, Where where, boolean optional) {
        Clause intermediateResult = Clauses.callClause(namespace, (String)name, arguments, yieldAll && resultItems == null ? List.of(Cypher.asterisk()) : resultItems, (Where)where);
        if (optional) {
            throw new IllegalArgumentException("Cannot render optional call clause");
        }
        return this.applyCallbacksFor(InvocationCreatedEventType.ON_CALL, intermediateResult);
    }

    @Override
    public Expression callResultItem(InputPosition p, String name, Expression alias) {
        SymbolicName finalName = Cypher.name((String)name);
        if (alias != null) {
            return finalName.as(CypherDslASTFactory.assertSymbolicName(alias));
        }
        return finalName;
    }

    @Override
    public PatternElement patternWithSelector(ASTFactory.NULL aNull, PatternElement patternPart) {
        return null;
    }

    @Override
    public PatternElement namedPattern(Expression v, PatternElement patternElement) {
        return Cypher.path((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).definedBy(patternElement);
    }

    @Override
    public PatternElement shortestPathPattern(InputPosition p, PatternElement patternElement) {
        CypherDslASTFactory.isInstanceOf(RelationshipPattern.class, patternElement, "Only relationship patterns are supported for the shortestPath function.");
        return new ExpressionAsPatternElementWrapper((Expression)FunctionInvocation.create((FunctionInvocation.FunctionDefinition)PatternElementFunctions.SHORTEST_PATH, (PatternElement)patternElement));
    }

    @Override
    public PatternElement allShortestPathsPattern(InputPosition p, PatternElement patternElement) {
        CypherDslASTFactory.isInstanceOf(RelationshipPattern.class, patternElement, "Only relationship patterns are supported for the allShortestPaths function.");
        return new ExpressionAsPatternElementWrapper((Expression)FunctionInvocation.create((FunctionInvocation.FunctionDefinition)PatternElementFunctions.ALL_SHORTEST_PATHS, (PatternElement)patternElement));
    }

    @Override
    public PatternElement pathPattern(PatternElement patternElement) {
        return patternElement;
    }

    @Override
    public PatternElement insertPathPattern(List<PatternAtom> patternAtoms) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PatternElement patternElement(List<PatternAtom> atoms) {
        Object e;
        PatternAtom patternAtom;
        if (atoms.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a PatternElement from an empty list of patterns.");
        }
        if (atoms.size() == 1 && (patternAtom = atoms.get(0)) instanceof ParenthesizedPathPatternAtom) {
            ParenthesizedPathPatternAtom atom = (ParenthesizedPathPatternAtom)patternAtom;
            return atom.asPatternElement();
        }
        ArrayList<PatternElement> patternElements = new ArrayList<PatternElement>();
        NodeAtom lastNodeAtom = null;
        PathAtom lastPathAtom = null;
        ExposesRelationships<?> relationshipPattern = null;
        ArrayList<PatternElement> patternList = null;
        for (PatternAtom atom : atoms) {
            PathAtom pathAtom;
            if (atom instanceof ParenthesizedPathPatternAtom) {
                ParenthesizedPathPatternAtom specificAtom = (ParenthesizedPathPatternAtom)atom;
                if (lastNodeAtom != null) {
                    patternElements.add((PatternElement)lastNodeAtom.value());
                }
                if (relationshipPattern != null) {
                    patternElements.add((PatternElement)relationshipPattern);
                }
                if (patternList != null) {
                    patternElements.add(new PatternList((Collection<PatternElement>)patternList));
                }
                lastNodeAtom = null;
                lastPathAtom = null;
                relationshipPattern = null;
                patternList = null;
                patternElements.add(specificAtom.asPatternElement());
                continue;
            }
            if (atom instanceof NodeAtom) {
                NodeAtom nodeAtom = (NodeAtom)atom;
                if (relationshipPattern != null) {
                    relationshipPattern = lastPathAtom.asRelationshipBetween(relationshipPattern, nodeAtom, this.options.isAlwaysCreateRelationshipsLTR());
                    continue;
                }
                if (lastNodeAtom == null) {
                    lastNodeAtom = nodeAtom;
                    continue;
                }
                relationshipPattern = lastNodeAtom.value();
                lastNodeAtom = null;
                relationshipPattern = lastPathAtom.asRelationshipBetween(relationshipPattern, nodeAtom, this.options.isAlwaysCreateRelationshipsLTR());
                if (lastPathAtom.getDirection() != Relationship.Direction.RTL && patternList == null || !this.options.isAlwaysCreateRelationshipsLTR()) continue;
                if (patternList == null) {
                    patternList = new ArrayList<PatternElement>();
                }
                patternList.add((PatternElement)relationshipPattern);
                relationshipPattern = null;
                lastNodeAtom = nodeAtom;
                continue;
            }
            if (!(atom instanceof PathAtom)) continue;
            lastPathAtom = pathAtom = (PathAtom)atom;
        }
        if (relationshipPattern == null && patternList != null && patternList.size() == 1 && (e = patternList.get(0)) instanceof RelationshipPattern) {
            RelationshipPattern singleListItem = (RelationshipPattern)e;
            relationshipPattern = singleListItem;
            patternList = null;
        }
        if (relationshipPattern != null) {
            patternElements.add((PatternElement)relationshipPattern);
        } else if (patternList != null) {
            patternElements.add(new PatternList((Collection<PatternElement>)patternList));
        } else if (lastNodeAtom != null) {
            patternElements.add((PatternElement)lastNodeAtom.value());
        }
        return patternElements.size() == 1 ? (PatternElement)patternElements.get(0) : new PatternJuxtaposition(patternElements);
    }

    @Override
    public ASTFactory.NULL anyPathSelector(String count, InputPosition countPosition, InputPosition position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allPathSelector(InputPosition position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL anyShortestPathSelector(String count, InputPosition countPosition, InputPosition position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allShortestPathSelector(InputPosition position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL shortestGroupsSelector(String count, InputPosition countPosition, InputPosition position) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeAtom nodePattern(InputPosition p, Expression v, LabelExpression labels, Expression properties, Expression predicate) {
        Node node;
        if (labels == null) {
            node = Cypher.anyNode();
        } else {
            Optional<String[]> finalLabels = this.computeFinalLabelList(LabelParsedEventType.ON_NODE_PATTERN, labels);
            node = finalLabels.map(l -> {
                String primaryLabel = l[0];
                List<String> additionalLabels = Arrays.stream(l).skip(1L).toList();
                return Cypher.node((String)primaryLabel, additionalLabels);
            }).orElseGet(() -> Cypher.node((LabelExpression)labels));
        }
        if (v != null) {
            node = node.named(CypherDslASTFactory.assertSymbolicName(v));
        }
        if (properties != null) {
            node = (Node)node.withProperties((MapExpression)properties);
        }
        if (predicate != null) {
            node = (Node)node.where(predicate);
        }
        return new NodeAtom(node);
    }

    @Override
    public PathAtom relationshipPattern(InputPosition p, boolean left, boolean right, Expression v, LabelExpression relTypes, PathLength pathLength, Expression properties, Expression predicate) {
        return PathAtom.of(CypherDslASTFactory.assertSymbolicName(v), pathLength, left, right, this.computeFinalTypeList(TypeParsedEventType.ON_RELATIONSHIP_PATTERN, relTypes), (MapExpression)properties, relTypes != null && relTypes.negated(), predicate);
    }

    @Override
    public PathLength pathLength(InputPosition p, InputPosition pMin, InputPosition pMax, String minLength, String maxLength) {
        return PathLength.of(minLength, maxLength);
    }

    @Override
    public QuantifiedPathPattern.Quantifier intervalPathQuantifier(InputPosition p, InputPosition posLowerBound, InputPosition posUpperBound, String lowerBound, String upperBound) {
        return QuantifiedPathPattern.interval((Integer)(lowerBound == null ? null : Integer.valueOf(Integer.parseInt(lowerBound))), upperBound == null ? null : Integer.valueOf(Integer.parseInt(upperBound)));
    }

    @Override
    public QuantifiedPathPattern.Quantifier fixedPathQuantifier(InputPosition p, InputPosition valuePos, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QuantifiedPathPattern.Quantifier plusPathQuantifier(InputPosition p) {
        return QuantifiedPathPattern.plus();
    }

    @Override
    public QuantifiedPathPattern.Quantifier starPathQuantifier(InputPosition p) {
        return QuantifiedPathPattern.star();
    }

    @Override
    public ASTFactory.NULL repeatableElements(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL differentRelationships(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PatternAtom parenthesizedPathPattern(InputPosition p, PatternElement internalPattern, Expression where, QuantifiedPathPattern.Quantifier pathPatternQuantifier) {
        return new ParenthesizedPathPatternAtom((RelationshipPattern)internalPattern, pathPatternQuantifier, where);
    }

    @Override
    public PatternAtom quantifiedRelationship(PathAtom rel, QuantifiedPathPattern.Quantifier pathPatternQuantifier) {
        return rel.withQuantifier(pathPatternQuantifier);
    }

    @Override
    public Clause loadCsvClause(InputPosition p, boolean headers, Expression source, Expression v, String fieldTerminator) {
        CypherDslASTFactory.isInstanceOf(StringLiteral.class, source, "Only string literals are supported as source for the LOAD CSV clause.");
        return Clauses.loadCSV((boolean)headers, (StringLiteral)((StringLiteral)source), (SymbolicName)CypherDslASTFactory.assertSymbolicName(v), (String)fieldTerminator);
    }

    @Override
    public Clause foreachClause(InputPosition p, Expression v, Expression list, List<Clause> objects) {
        return Clauses.forEach((SymbolicName)CypherDslASTFactory.assertSymbolicName(v), (Expression)list, objects);
    }

    @Override
    public Clause subqueryClause(InputPosition p, Statement subquery, ASTFactory.NULL inTransactions, boolean scopeAll, boolean hasScope, List<Expression> expressions, boolean optional) {
        if (optional) {
            throw new IllegalArgumentException("Cannot render optional subquery clause");
        }
        return Clauses.callClause((Statement)subquery);
    }

    @Override
    public ASTFactory.NULL subqueryInTransactionsParams(InputPosition p, ASTFactory.NULL batchParams, ASTFactory.NULL concurrencyParams, ASTFactory.NULL errorParams, ASTFactory.NULL reportParams) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause yieldClause(InputPosition p, boolean returnAll, List<Expression> expressions, InputPosition returnItemsPosition, List<SortItem> orderBy, InputPosition orderPos, Expression skip, InputPosition skipPosition, Expression limit, InputPosition limitPosition, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause showIndexClause(InputPosition p, ShowCommandFilterTypes indexType, Where where, Clause yieldClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause showConstraintClause(InputPosition p, ShowCommandFilterTypes constraintType, Where where, Clause yieldClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause showProcedureClause(InputPosition p, boolean currentUser, String user, Where where, Clause yieldClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause showFunctionClause(InputPosition p, ShowCommandFilterTypes functionType, boolean currentUser, String user, Where where, Clause yieldClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement useGraph(Statement command, Clause useGraph) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showRoles(InputPosition p, boolean withUsers, boolean showAll, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement grantRoles(InputPosition p, List<SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>>> roles, List<SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>>> users) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement revokeRoles(InputPosition p, List<SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>>> roles, List<SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>>> users) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createUser(InputPosition p, boolean replace, boolean ifNotExists, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> username, Boolean suspended, DatabaseName homeDatabase, List<ASTFactory.NULL> nulls, List<ASTFactory.NULL> systemAuthAttributes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropUser(InputPosition p, boolean ifExists, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> username) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement renameUser(InputPosition p, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> fromUserName, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> toUserName, boolean ifExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement setOwnPassword(InputPosition p, Expression currentPassword, Expression newPassword) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL auth(String provider, List<ASTFactory.NULL> nulls, InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL authId(InputPosition s, Expression id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL password(InputPosition p, Expression password, boolean encrypted) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL passwordChangeRequired(InputPosition p, boolean changeRequired) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement alterUser(InputPosition p, boolean ifExists, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> username, Boolean suspended, DatabaseName homeDatabase, boolean removeHome, List<ASTFactory.NULL> nulls, List<ASTFactory.NULL> systemAuthAttributes, boolean removeAllAuth, List<Expression> removeAuths) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression passwordExpression(Parameter<?> password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression passwordExpression(InputPosition s, InputPosition e, String password) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showUsers(InputPosition p, Clause yieldExpr, Return returnWithoutGraph, Where where, boolean withAuth) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showCurrentUser(InputPosition p, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showSupportedPrivileges(InputPosition p, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showAllPrivileges(InputPosition p, boolean asCommand, boolean asRevoke, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showRolePrivileges(InputPosition p, List<SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>>> roles, boolean asCommand, boolean asRevoke, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showUserPrivileges(InputPosition p, List<SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>>> users, boolean asCommand, boolean asRevoke, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement grantPrivilege(InputPosition p, List<SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>>> roles, ASTFactory.NULL privilege) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement denyPrivilege(InputPosition p, List<SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>>> roles, ASTFactory.NULL privilege) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement revokePrivilege(InputPosition p, List<SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>>> roles, ASTFactory.NULL privilege, boolean revokeGrant, boolean revokeDeny) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createDatabase(InputPosition p, boolean replace, DatabaseName databaseName, boolean ifNotExists, ASTFactory.NULL aNull, SimpleEither<Map<String, Expression>, Parameter<?>> options, SimpleEither<Integer, Parameter<?>> topologyPrimaries, SimpleEither<Integer, Parameter<?>> topologySecondaries) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createCompositeDatabase(InputPosition p, boolean replace, DatabaseName compositeDatabaseName, boolean ifNotExists, SimpleEither<Map<String, Expression>, Parameter<?>> databaseOptions, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropDatabase(InputPosition p, DatabaseName databaseName, boolean ifExists, boolean composite, boolean aliasAction, boolean dumpData, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement alterDatabase(InputPosition p, DatabaseName databaseName, boolean ifExists, AccessType accessType, SimpleEither<Integer, Parameter<?>> topologyPrimaries, SimpleEither<Integer, Parameter<?>> topologySecondaries, Map<String, Expression> options, Set<String> optionsToRemove, ASTFactory.NULL aNull) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showDatabase(InputPosition p, ASTFactory.NULL scope, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement startDatabase(InputPosition p, DatabaseName databaseName, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement stopDatabase(InputPosition p, DatabaseName databaseName, ASTFactory.NULL wait) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL databaseScope(InputPosition p, DatabaseName databaseName, boolean isDefault, boolean isHome) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropAlias(InputPosition p, DatabaseName aliasName, boolean ifExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showAliases(InputPosition p, DatabaseName aliasName, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDeprecatedIdentifierUnicodeNotification(InputPosition p, Character character, String identifier) {
    }

    @Override
    public ASTFactory.NULL wait(boolean wait, long seconds) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DatabaseName databaseName(InputPosition p, List<String> names) {
        if (names.isEmpty()) {
            throw new IllegalArgumentException("No database name");
        }
        if (names.size() == 1) {
            return new DatabaseName((Expression)Cypher.literalOf((Object)names.get(0)));
        }
        return new DatabaseName((Expression)Cypher.literalOf(names));
    }

    @Override
    public DatabaseName databaseName(Parameter<?> param) {
        return new DatabaseName((Expression)param);
    }

    @Override
    public Statement createLocalDatabaseAlias(InputPosition p, boolean replace, DatabaseName aliasName, DatabaseName targetName, boolean ifNotExists, SimpleEither<Map<String, Expression>, Parameter<?>> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createRemoteDatabaseAlias(InputPosition p, boolean replace, DatabaseName aliasName, DatabaseName targetName, boolean ifNotExists, SimpleEither<String, Parameter<?>> url, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> username, Expression password, SimpleEither<Map<String, Expression>, Parameter<?>> driverSettings, SimpleEither<Map<String, Expression>, Parameter<?>> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement alterLocalDatabaseAlias(InputPosition p, DatabaseName aliasName, DatabaseName targetName, boolean ifExists, SimpleEither<Map<String, Expression>, Parameter<?>> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement alterRemoteDatabaseAlias(InputPosition p, DatabaseName aliasName, DatabaseName targetName, boolean ifExists, SimpleEither<String, Parameter<?>> url, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> username, Expression password, SimpleEither<Map<String, Expression>, Parameter<?>> driverSettings, SimpleEither<Map<String, Expression>, Parameter<?>> properties) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression newVariable(InputPosition p, String name) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_VARIABLE, Cypher.name((String)name));
    }

    @Override
    public Parameter<?> newParameter(InputPosition p, Expression v, ParameterType type) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_PARAMETER, (Expression)this.parameterFromSymbolicName(v));
    }

    @Override
    public Parameter<?> newParameter(InputPosition p, String v, ParameterType type) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_PARAMETER, (Expression)this.parameterFromSymbolicName((Expression)Cypher.name((String)v)));
    }

    @Override
    public Parameter<?> newSensitiveStringParameter(InputPosition p, Expression v) {
        throw new UnsupportedOperationException("The Cypher-DSL does not support sensitive parameters.");
    }

    @Override
    public Parameter<?> newSensitiveStringParameter(InputPosition p, String v) {
        throw new UnsupportedOperationException("The Cypher-DSL does not support sensitive parameters.");
    }

    @NotNull
    Parameter<?> parameterFromSymbolicName(Expression v) {
        SymbolicName symbolicName = CypherDslASTFactory.assertSymbolicName(v);
        if (symbolicName == null) {
            return Cypher.anonParameter((Object)Cypher.literalNull());
        }
        String name = symbolicName.getValue();
        return this.options.getParameterValues().containsKey(name) ? Cypher.parameter((String)name, (Object)this.options.getParameterValues().get(name)) : Cypher.parameter((String)name);
    }

    @Override
    public Expression newDouble(InputPosition p, String image) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalOf((Object)Double.parseDouble(image)));
    }

    @Override
    public Expression newDecimalInteger(InputPosition p, String image, boolean negated) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalOf((Object)(Long.parseUnsignedLong(image) * (long)(negated ? -1 : 1))));
    }

    @Override
    public Expression newHexInteger(InputPosition p, String image, boolean negated) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalOf((Object)(Long.parseUnsignedLong(image.replaceFirst("(?i)0x", ""), 16) * (long)(negated ? -1 : 1))));
    }

    @Override
    public Expression newOctalInteger(InputPosition p, String image, boolean negated) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalOf((Object)(Long.parseUnsignedLong(image.replaceFirst("(?i)0o", ""), 8) * (long)(negated ? -1 : 1))));
    }

    @Override
    public Expression newString(InputPosition start, InputPosition end, String image) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalOf((Object)image));
    }

    @Override
    public Expression newTrueLiteral(InputPosition p) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalTrue());
    }

    @Override
    public Expression newFalseLiteral(InputPosition p) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalFalse());
    }

    @Override
    public Expression newInfinityLiteral(InputPosition p) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_LITERAL, InfinityLiteral.INSTANCE);
    }

    @Override
    public Expression newNaNLiteral(InputPosition p) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_LITERAL, NaNLiteral.INSTANCE);
    }

    @Override
    public Expression newNullLiteral(InputPosition p) {
        return this.applyCallbacksFor(ExpressionCreatedEventType.ON_NEW_LITERAL, Cypher.literalNull());
    }

    @Override
    public Expression listLiteral(InputPosition p, List<Expression> values) {
        return Cypher.listOf((Expression[])values.toArray(new Expression[0]));
    }

    @Override
    public MapExpression mapLiteral(InputPosition p, List<ASTFactory.StringPos<InputPosition>> keys, List<Expression> values) {
        Object[] keysAndValues = new Object[keys.size() * 2];
        int i = 0;
        Iterator<Expression> valueIterator = values.iterator();
        for (ASTFactory.StringPos<InputPosition> key : keys) {
            keysAndValues[i++] = key.string;
            keysAndValues[i++] = valueIterator.next();
        }
        return this.options.isCreateSortedMaps() ? Cypher.sortedMapOf((Object[])keysAndValues) : Cypher.mapOf((Object[])keysAndValues);
    }

    @Override
    public Property property(Expression subject, ASTFactory.StringPos<InputPosition> propertyKeyName) {
        return subject.property(propertyKeyName.string);
    }

    @Override
    public Expression or(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.asCondition().or(rhs.asCondition());
    }

    @Override
    public Expression xor(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.asCondition().xor(rhs.asCondition());
    }

    @Override
    public Expression and(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.asCondition().and(rhs.asCondition());
    }

    @Override
    public LabelExpression labelConjunction(InputPosition p, LabelExpression lhs, LabelExpression rhs, boolean containsIs) {
        return lhs.and(rhs);
    }

    @Override
    public LabelExpression labelDisjunction(InputPosition p, LabelExpression lhs, LabelExpression rhs, boolean containsIs) {
        return lhs.or(rhs);
    }

    @Override
    public LabelExpression labelNegation(InputPosition p, LabelExpression e, boolean containsIs) {
        return e.negate();
    }

    @Override
    public LabelExpression labelWildcard(InputPosition p, boolean containsIs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LabelExpression labelLeaf(InputPosition p, String e, EntityType entityType, boolean containsIs) {
        return new LabelExpression(e);
    }

    @Override
    public LabelExpression labelColonConjunction(InputPosition p, LabelExpression lhs, LabelExpression rhs, boolean containsIs) {
        return CypherDslASTFactory.colonJunjction(lhs, rhs, LabelExpression.Type.COLON_CONJUNCTION);
    }

    @Override
    public LabelExpression labelColonDisjunction(InputPosition p, LabelExpression lhs, LabelExpression rhs, boolean containsIs) {
        return CypherDslASTFactory.colonJunjction(lhs, rhs, LabelExpression.Type.COLON_DISJUNCTION);
    }

    @NotNull
    private static LabelExpression colonJunjction(LabelExpression lhs, LabelExpression rhs, LabelExpression.Type colonDisjunction) {
        ArrayList value = new ArrayList();
        value.addAll(lhs.value());
        value.addAll(rhs.value());
        return new LabelExpression(colonDisjunction, false, value, null, null);
    }

    @Override
    public Expression labelExpressionPredicate(Expression subject, LabelExpression exp) {
        if (!(subject instanceof SymbolicName)) {
            throw new IllegalArgumentException("Expected an symbolic name to create a label based expression predicate!");
        }
        SymbolicName symbolicName = (SymbolicName)subject;
        ArrayList values = new ArrayList();
        for (LabelExpression current = exp; current != null; current = current.rhs()) {
            values.addAll(current.value());
        }
        return Cypher.hasLabelsOrType((SymbolicName)symbolicName, (String[])((String[])values.toArray(String[]::new)));
    }

    @Override
    public Expression ands(List<Expression> exprs) {
        return (Expression)exprs.stream().reduce(Cypher.noCondition(), (l, r) -> l.asCondition().and(r.asCondition()));
    }

    @Override
    public Expression not(InputPosition p, Expression e) {
        return e.asCondition().not();
    }

    @Override
    public Expression plus(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.add(rhs);
    }

    @Override
    public Expression minus(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.subtract(rhs);
    }

    @Override
    public Expression concatenate(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.concat(rhs);
    }

    @Override
    public Expression multiply(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.multiply(rhs);
    }

    @Override
    public Expression divide(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.divide(rhs);
    }

    @Override
    public Expression modulo(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.remainder(rhs);
    }

    @Override
    public Expression pow(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.pow(rhs);
    }

    @Override
    public Expression unaryPlus(Expression e) {
        return Cypher.plus((Expression)e);
    }

    @Override
    public Expression unaryPlus(InputPosition inputPosition, Expression expression) {
        return Cypher.plus((Expression)expression);
    }

    @Override
    public Expression unaryMinus(InputPosition inputPosition, Expression expression) {
        return Cypher.minus((Expression)expression);
    }

    @Override
    public Expression eq(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.eq(rhs);
    }

    @Override
    public Expression neq(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.ne(rhs);
    }

    @Override
    public Expression neq2(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.ne(rhs);
    }

    @Override
    public Expression lte(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.lte(rhs);
    }

    @Override
    public Expression gte(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.gte(rhs);
    }

    @Override
    public Expression lt(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.lt(rhs);
    }

    @Override
    public Expression gt(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.gt(rhs);
    }

    @Override
    public Expression regeq(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.matches(rhs);
    }

    @Override
    public Expression startsWith(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.startsWith(rhs);
    }

    @Override
    public Expression endsWith(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.endsWith(rhs);
    }

    @Override
    public Expression contains(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.contains(rhs);
    }

    @Override
    public Expression in(InputPosition p, Expression lhs, Expression rhs) {
        return lhs.in(rhs);
    }

    @Override
    public Expression isNull(InputPosition p, Expression e) {
        return e.isNull();
    }

    @Override
    public Expression isNotNull(InputPosition p, Expression e) {
        return e.isNotNull();
    }

    @Override
    public Expression isTyped(InputPosition p, Expression e, ParserCypherTypeName typeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression isNotTyped(InputPosition p, Expression e, ParserCypherTypeName typeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression isNormalized(InputPosition p, Expression e, ParserNormalForm normalForm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression isNotNormalized(InputPosition p, Expression e, ParserNormalForm normalForm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression listLookup(Expression list, Expression index) {
        return Cypher.valueAt((Expression)list, (Expression)index);
    }

    @Override
    public Expression listSlice(InputPosition p, Expression list, Expression start, Expression end) {
        return Cypher.subList((Expression)list, (Expression)start, (Expression)end);
    }

    @Override
    public Expression newCountStar(InputPosition p) {
        return Cypher.count((Expression)Cypher.asterisk());
    }

    @Override
    public Expression functionInvocation(InputPosition p, InputPosition functionNamePosition, List<String> namespace, String name, boolean distinct, List<Expression> arguments, boolean calledFromUseClause) {
        String[] parts = new String[namespace.size() + 1];
        for (int i = 0; i < namespace.size(); ++i) {
            parts[i] = namespace.get(i);
        }
        parts[parts.length - 1] = name;
        Expression expression = ((StatementBuilder.OngoingStandaloneCallWithArguments)Cypher.call((String[])parts).withArgs((Expression[])arguments.toArray(Expression[]::new))).asFunction(distinct);
        return this.applyCallbacksFor(InvocationCreatedEventType.ON_INVOCATION, expression);
    }

    @Override
    public Expression listComprehension(InputPosition p, Expression v, Expression list, Expression where, Expression projection) {
        ListComprehension.OngoingDefinitionWithList in = Cypher.listWith((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).in(list);
        if (where != null) {
            ListComprehension.OngoingDefinitionWithoutReturn ongoingComprehension = in.where(where.asCondition());
            if (projection != null) {
                return ongoingComprehension.returning(new Expression[]{projection});
            }
            return ongoingComprehension.returning();
        }
        return in.returning(new Expression[]{projection});
    }

    @Override
    public Expression patternComprehension(InputPosition p, InputPosition relationshipPatternPosition, Expression v, PatternElement patternElement, Expression where, Expression projection) {
        PatternComprehension.OngoingDefinitionWithPattern ongoingDefinitionWithPattern;
        if (patternElement instanceof RelationshipPattern) {
            RelationshipPattern relationshipPattern = (RelationshipPattern)patternElement;
            ongoingDefinitionWithPattern = v != null ? Cypher.listBasedOn((NamedPath)Cypher.path((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).definedBy((PatternElement)relationshipPattern)) : Cypher.listBasedOn((RelationshipPattern)relationshipPattern);
        } else if (patternElement instanceof NamedPath) {
            NamedPath namedPath = (NamedPath)patternElement;
            ongoingDefinitionWithPattern = Cypher.listBasedOn((NamedPath)namedPath);
        } else {
            throw new IllegalArgumentException("Cannot build a pattern comprehension around " + patternElement.getClass().getSimpleName());
        }
        if (where != null) {
            ongoingDefinitionWithPattern = ongoingDefinitionWithPattern.where(where.asCondition());
        }
        return ongoingDefinitionWithPattern.returning(new Expression[]{projection});
    }

    @Override
    public Expression reduceExpression(InputPosition p, Expression acc, Expression accExpr, Expression v, Expression list, Expression innerExpr) {
        SymbolicName variable = CypherDslASTFactory.assertSymbolicName(v);
        if (variable == null) {
            throw new IllegalArgumentException("A variable to be reduced must be present.");
        }
        return Cypher.reduce((SymbolicName)variable).in(list).map(innerExpr).accumulateOn((Expression)CypherDslASTFactory.assertSymbolicName(acc)).withInitialValueOf(accExpr);
    }

    @Override
    public Expression allExpression(InputPosition p, Expression v, Expression list, Expression where) {
        CypherDslASTFactory.notNull(where, "all(...) requires a WHERE predicate");
        return Cypher.all((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).in(list).where(where.asCondition());
    }

    @Override
    public Expression anyExpression(InputPosition p, Expression v, Expression list, Expression where) {
        CypherDslASTFactory.notNull(where, "any(...) requires a WHERE predicate");
        return Cypher.any((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).in(list).where(where.asCondition());
    }

    @Override
    public Expression noneExpression(InputPosition p, Expression v, Expression list, Expression where) {
        CypherDslASTFactory.notNull(where, "none(...) requires a WHERE predicate");
        return Cypher.none((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).in(list).where(where.asCondition());
    }

    @Override
    public Expression singleExpression(InputPosition p, Expression v, Expression list, Expression where) {
        CypherDslASTFactory.notNull(where, "single(...) requires a WHERE predicate");
        return Cypher.single((SymbolicName)CypherDslASTFactory.assertSymbolicName(v)).in(list).where(where.asCondition());
    }

    @Override
    public Expression normalizeExpression(InputPosition p, Expression i, ParserNormalForm normalForm) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression trimFunction(InputPosition inputPosition, ParserTrimSpecification parserTrimSpecification, Expression expression, Expression expression1) {
        Expression[] expressionArray;
        StatementBuilder.OngoingStandaloneCallWithoutArguments call;
        switch (parserTrimSpecification) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BOTH: {
                StatementBuilder.OngoingStandaloneCallWithoutArguments ongoingStandaloneCallWithoutArguments = Cypher.call((String)"trim");
                break;
            }
            case LEADING: {
                StatementBuilder.OngoingStandaloneCallWithoutArguments ongoingStandaloneCallWithoutArguments = Cypher.call((String)"ltrim");
                break;
            }
            case TRAILING: {
                StatementBuilder.OngoingStandaloneCallWithoutArguments ongoingStandaloneCallWithoutArguments = call = Cypher.call((String)"rtrim");
            }
        }
        if (expression == null) {
            Expression[] expressionArray2 = new Expression[1];
            expressionArray = expressionArray2;
            expressionArray2[0] = expression1;
        } else {
            Expression[] expressionArray3 = new Expression[2];
            expressionArray3[0] = expression1;
            expressionArray = expressionArray3;
            expressionArray3[1] = expression;
        }
        return ((StatementBuilder.OngoingStandaloneCallWithArguments)call.withArgs(expressionArray)).asFunction();
    }

    @Override
    public Expression patternExpression(InputPosition p, PatternElement patternElement) {
        if (patternElement instanceof ExpressionAsPatternElementWrapper) {
            ExpressionAsPatternElementWrapper wrapper = (ExpressionAsPatternElementWrapper)patternElement;
            return wrapper.getExpression();
        }
        if (patternElement instanceof RelationshipPattern) {
            RelationshipPattern relationshipPattern = (RelationshipPattern)patternElement;
            return new PatternElementAsExpressionWrapper(relationshipPattern);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression existsExpression(InputPosition p, ASTFactory.NULL matchMode, List<PatternElement> patternElements, Statement q, Where where) {
        if (q == null) {
            return Cypher.exists(patternElements, (Where)where);
        }
        return Cypher.exists((Statement)q, (IdentifiableElement[])new IdentifiableElement[0]);
    }

    @Override
    public Expression countExpression(InputPosition p, ASTFactory.NULL matchMode, List<PatternElement> patternElements, Statement q, Where where) {
        if (q == null) {
            return Cypher.count(patternElements, (Where)where);
        }
        return Cypher.count((Statement)q, (IdentifiableElement[])new IdentifiableElement[0]);
    }

    @Override
    public Expression collectExpression(InputPosition inputPosition, Statement statement) {
        return Cypher.collect((Statement)statement);
    }

    @Override
    public Expression mapProjection(InputPosition p, Expression v, List<Expression> items) {
        return this.options.isCreateSortedMaps() ? MapProjection.sorted((SymbolicName)CypherDslASTFactory.assertSymbolicName(v), (Object[])items.toArray(new Object[0])) : MapProjection.create((SymbolicName)CypherDslASTFactory.assertSymbolicName(v), (Object[])items.toArray(new Object[0]));
    }

    @Override
    public Expression mapProjectionLiteralEntry(ASTFactory.StringPos<InputPosition> property, Expression value) {
        return KeyValueMapEntry.create((String)property.string, (Expression)value);
    }

    @Override
    public Expression mapProjectionProperty(ASTFactory.StringPos<InputPosition> property) {
        return PropertyLookup.forName((String)property.string);
    }

    @Override
    public Expression mapProjectionVariable(Expression v) {
        return v;
    }

    @Override
    public Expression mapProjectionAll(InputPosition p) {
        return Cypher.asterisk();
    }

    @Override
    public Expression caseExpression(InputPosition p, Expression e, List<Expression> whens, List<Expression> thens, Expression elze) {
        if (whens != null && thens != null && whens.size() != thens.size()) {
            throw new IllegalArgumentException("Cannot combine lists of whens with a different sized list of thens.");
        }
        Case aCase = Cypher.caseExpression((Expression)e);
        if (whens != null && thens != null) {
            Iterator<Expression> iteratorWhens = whens.iterator();
            Iterator<Expression> iteratorThens = thens.iterator();
            while (iteratorWhens.hasNext() && iteratorThens.hasNext()) {
                aCase = aCase.when(iteratorWhens.next()).then(iteratorThens.next());
            }
            if (elze != null) {
                return ((Case.CaseEnding)aCase).elseDefault(elze);
            }
            return aCase;
        }
        return aCase;
    }

    @Override
    public InputPosition inputPosition(int offset, int line, int column) {
        return new InputPosition(offset, line, column);
    }

    @Override
    public EntityType nodeType() {
        return EntityType.NODE;
    }

    @Override
    public EntityType relationshipType() {
        return EntityType.RELATIONSHIP;
    }

    @Override
    public EntityType nodeOrRelationshipType() {
        return EntityType.LOLWHAT;
    }

    @Override
    public Where whereClause(InputPosition p, Expression optionalWhere) {
        return Where.from((Expression)optionalWhere);
    }

    @Override
    public ASTFactory.NULL subqueryInTransactionsBatchParameters(InputPosition p, Expression batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL subqueryInTransactionsConcurrencyParameters(InputPosition p, Expression concurrency) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL subqueryInTransactionsErrorParameters(InputPosition p, CallInTxsOnErrorBehaviourType onErrorBehaviour) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL subqueryInTransactionsReportParameters(InputPosition p, Expression v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause orderBySkipLimitClause(InputPosition inputPosition, List<SortItem> list, InputPosition pos1, Expression expression, InputPosition pos2, Expression expression1, InputPosition pos3) {
        return null;
    }

    @Override
    public Clause showTransactionsClause(InputPosition p, SimpleEither<List<String>, Expression> ids, Where where, Clause yieldClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause terminateTransactionsClause(InputPosition p, SimpleEither<List<String>, Expression> ids, Where where, Clause yieldClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause showSettingsClause(InputPosition p, SimpleEither<List<String>, Expression> names, Where where, Clause yieldClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clause turnYieldToWith(Clause yieldClause) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createConstraint(InputPosition p, ConstraintType constraintType, boolean replace, boolean ifNotExists, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> constraintName, Expression expression, ASTFactory.StringPos<InputPosition> label, List<Property> properties, ParserCypherTypeName propertyType, SimpleEither<Map<String, Expression>, Parameter<?>> constraintOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropConstraint(InputPosition p, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> name, boolean ifExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createLookupIndex(InputPosition p, boolean replace, boolean ifNotExists, boolean isNode, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> indexName, Expression expression, ASTFactory.StringPos<InputPosition> functionName, Expression functionParameter, SimpleEither<Map<String, Expression>, Parameter<?>> indexOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createIndex(InputPosition p, boolean replace, boolean ifNotExists, boolean isNode, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> indexName, Expression expression, ASTFactory.StringPos<InputPosition> label, List<Property> properties, SimpleEither<Map<String, Expression>, Parameter<?>> indexOptions, CreateIndexTypes indexType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createFulltextIndex(InputPosition p, boolean replace, boolean ifNotExists, boolean isNode, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> indexName, Expression expression, List<ASTFactory.StringPos<InputPosition>> labels, List<Property> properties, SimpleEither<Map<String, Expression>, Parameter<?>> indexOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropIndex(InputPosition p, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> name, boolean ifExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement createRole(InputPosition p, boolean replace, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> roleName, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> fromRole, boolean ifNotExists, boolean immutable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropRole(InputPosition p, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> roleName, boolean ifExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement renameRole(InputPosition p, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> fromRoleName, SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>> toRoleName, boolean ifExists) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL databasePrivilege(InputPosition p, ASTFactory.NULL aNull, ASTFactory.NULL aNull2, List<ASTFactory.NULL> qualifier, boolean immutable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL dbmsPrivilege(InputPosition p, ASTFactory.NULL aNull, List<ASTFactory.NULL> qualifier, boolean immutable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL loadPrivilege(InputPosition inputPosition, SimpleEither<String, Parameter<?>> simpleEither, SimpleEither<String, Parameter<?>> simpleEither1, boolean b) {
        return null;
    }

    @Override
    public ASTFactory.NULL graphPrivilege(InputPosition inputPosition, ASTFactory.NULL aNull, ASTFactory.NULL aNull2, ASTFactory.NULL aNull3, List<ASTFactory.NULL> qualifier, boolean immutable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL privilegeAction(ActionType action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL propertiesResource(InputPosition p, List<String> property) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allPropertiesResource(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL labelsResource(InputPosition p, List<String> label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allLabelsResource(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL databaseResource(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL noResource(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL labelQualifier(InputPosition p, String label) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL relationshipQualifier(InputPosition p, String relationshipType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL elementQualifier(InputPosition p, String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allElementsQualifier(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL patternQualifier(List<ASTFactory.NULL> list, Expression expression, Expression expression2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allLabelsQualifier(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL allRelationshipsQualifier(InputPosition p) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> allQualifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> allDatabasesQualifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> userQualifier(List<SimpleEither<ASTFactory.StringPos<InputPosition>, Parameter<?>>> users) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> allUsersQualifier() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> functionQualifier(InputPosition p, List<String> functions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> procedureQualifier(InputPosition p, List<String> procedures) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ASTFactory.NULL> settingQualifier(InputPosition inputPosition, List<String> list) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL graphScope(InputPosition inputPosition, List<DatabaseName> graphNames, ScopeType scopeType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ASTFactory.NULL databasePrivilegeScope(InputPosition inputPosition, List<DatabaseName> list, ScopeType scopeType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public LabelExpression dynamicLabelLeaf(InputPosition p, Expression e, EntityType entityType, boolean all, boolean containsIs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement enableServer(InputPosition p, SimpleEither<String, Parameter<?>> serverName, SimpleEither<Map<String, Expression>, Parameter<?>> serverOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement alterServer(InputPosition p, SimpleEither<String, Parameter<?>> serverName, SimpleEither<Map<String, Expression>, Parameter<?>> serverOptions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement renameServer(InputPosition p, SimpleEither<String, Parameter<?>> serverName, SimpleEither<String, Parameter<?>> newName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement dropServer(InputPosition p, SimpleEither<String, Parameter<?>> serverName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement showServers(InputPosition p, Clause yieldExpr, Return returnWithoutGraph, Where where) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement deallocateServers(InputPosition p, boolean dryRun, List<SimpleEither<String, Parameter<?>>> serverNames) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Statement reallocateDatabases(InputPosition p, boolean dryRun) {
        throw new UnsupportedOperationException();
    }

    static class PatternList
    extends TypedSubtree<PatternElement>
    implements PatternElement {
        PatternList(Collection<PatternElement> children) {
            super(children);
        }
    }

    static class PatternJuxtaposition
    extends TypedSubtree<PatternElement>
    implements PatternElement {
        PatternJuxtaposition(Collection<PatternElement> children) {
            super(children);
        }

        public String separator() {
            return " ";
        }
    }
}

