/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.msearch;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.ScriptField;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.search.Highlight;
import org.opensearch.client.opensearch.core.search.SourceConfig;
import org.opensearch.client.opensearch.core.search.Suggester;
import org.opensearch.client.opensearch.core.search.TrackHits;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class MultisearchBody
implements JsonpSerializable {
    private final Map<String, Aggregation> aggregations;
    @Nullable
    private final Query query;
    @Nullable
    private final Integer from;
    @Nullable
    private final Double minScore;
    @Nullable
    private final Query postFilter;
    private final List<String> searchAfter;
    @Nullable
    private final Integer size;
    private final List<SortOptions> sort;
    @Nullable
    private final Boolean trackScores;
    @Nullable
    private final TrackHits trackTotalHits;
    @Nullable
    private final Suggester suggest;
    @Nullable
    private Highlight highlight;
    @Nullable
    private SourceConfig source;
    private final Map<String, ScriptField> scriptFields;
    public static final JsonpDeserializer<MultisearchBody> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultisearchBody::setupMultisearchBodyDeserializer);

    private MultisearchBody(Builder builder) {
        this.aggregations = ApiTypeHelper.unmodifiable(builder.aggregations);
        this.query = builder.query;
        this.from = builder.from;
        this.minScore = builder.minScore;
        this.postFilter = builder.postFilter;
        this.searchAfter = ApiTypeHelper.unmodifiable(builder.searchAfter);
        this.size = builder.size;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
        this.trackScores = builder.trackScores;
        this.trackTotalHits = builder.trackTotalHits;
        this.suggest = builder.suggest;
        this.highlight = builder.highlight;
        this.source = builder.source;
        this.scriptFields = ApiTypeHelper.unmodifiable(builder.scriptFields);
    }

    public static MultisearchBody of(Function<Builder, ObjectBuilder<MultisearchBody>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, Aggregation> aggregations() {
        return this.aggregations;
    }

    @Nullable
    public final Query query() {
        return this.query;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final Double minScore() {
        return this.minScore;
    }

    @Nullable
    public final Query postFilter() {
        return this.postFilter;
    }

    public final List<String> searchAfter() {
        return this.searchAfter;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public final List<SortOptions> sort() {
        return this.sort;
    }

    @Nullable
    public final Boolean trackScores() {
        return this.trackScores;
    }

    @Nullable
    public final TrackHits trackTotalHits() {
        return this.trackTotalHits;
    }

    @Nullable
    public final Suggester suggest() {
        return this.suggest;
    }

    @Nullable
    public final Highlight highlight() {
        return this.highlight;
    }

    @Nullable
    public final SourceConfig source() {
        return this.source;
    }

    public final Map<String, ScriptField> scriptFields() {
        return this.scriptFields;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aggregations)) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry<String, Aggregation> entry : this.aggregations.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.query != null) {
            generator.writeKey("query");
            this.query.serialize(generator, mapper);
        }
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from.intValue());
        }
        if (this.minScore != null) {
            generator.writeKey("min_score");
            generator.write(this.minScore.doubleValue());
        }
        if (this.postFilter != null) {
            generator.writeKey("post_filter");
            this.postFilter.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.searchAfter)) {
            generator.writeKey("search_after");
            generator.writeStartArray();
            for (String string : this.searchAfter) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (SortOptions sortOptions : this.sort) {
                sortOptions.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.trackScores != null) {
            generator.writeKey("track_scores");
            generator.write(this.trackScores.booleanValue());
        }
        if (this.trackTotalHits != null) {
            generator.writeKey("track_total_hits");
            this.trackTotalHits.serialize(generator, mapper);
        }
        if (this.suggest != null) {
            generator.writeKey("suggest");
            this.suggest.serialize(generator, mapper);
        }
        if (this.highlight != null) {
            generator.writeKey("highlight");
            this.highlight.serialize(generator, mapper);
        }
        if (this.source != null) {
            generator.writeKey("_source");
            this.source.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.scriptFields)) {
            generator.writeKey("script_fields");
            generator.writeStartObject();
            for (Map.Entry entry : this.scriptFields.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((ScriptField)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupMultisearchBodyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(Aggregation._DESERIALIZER), "aggregations", "aggs");
        op.add(Builder::query, Query._DESERIALIZER, "query");
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from");
        op.add(Builder::minScore, JsonpDeserializer.doubleDeserializer(), "min_score");
        op.add(Builder::postFilter, Query._DESERIALIZER, "post_filter");
        op.add(Builder::searchAfter, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "search_after");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(SortOptions._DESERIALIZER), "sort");
        op.add(Builder::trackScores, JsonpDeserializer.booleanDeserializer(), "track_scores");
        op.add(Builder::trackTotalHits, TrackHits._DESERIALIZER, "track_total_hits");
        op.add(Builder::suggest, Suggester._DESERIALIZER, "suggest");
        op.add(Builder::highlight, Highlight._DESERIALIZER, "highlight");
        op.add(Builder::source, SourceConfig._DESERIALIZER, "_source");
        op.add(Builder::scriptFields, JsonpDeserializer.stringMapDeserializer(ScriptField._DESERIALIZER), "script_fields");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MultisearchBody> {
        @Nullable
        private Map<String, Aggregation> aggregations;
        @Nullable
        private Query query;
        @Nullable
        private Integer from;
        @Nullable
        private Double minScore;
        @Nullable
        private Query postFilter;
        @Nullable
        private List<String> searchAfter;
        @Nullable
        private Integer size;
        @Nullable
        private List<SortOptions> sort;
        @Nullable
        private Boolean trackScores;
        @Nullable
        private TrackHits trackTotalHits;
        @Nullable
        private Suggester suggest;
        @Nullable
        private Highlight highlight;
        @Nullable
        private SourceConfig source;
        private Map<String, ScriptField> scriptFields;

        public final Builder aggregations(Map<String, Aggregation> map) {
            this.aggregations = Builder._mapPutAll(this.aggregations, map);
            return this;
        }

        public final Builder aggregations(String key, Aggregation value) {
            this.aggregations = Builder._mapPut(this.aggregations, key, value);
            return this;
        }

        public final Builder aggregations(String key, Function<Aggregation.Builder, ObjectBuilder<Aggregation>> fn) {
            return this.aggregations(key, fn.apply(new Aggregation.Builder()).build());
        }

        public final Builder query(@Nullable Query value) {
            this.query = value;
            return this;
        }

        public final Builder query(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.query(fn.apply(new Query.Builder()).build());
        }

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder minScore(@Nullable Double value) {
            this.minScore = value;
            return this;
        }

        public final Builder postFilter(@Nullable Query value) {
            this.postFilter = value;
            return this;
        }

        public final Builder postFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.postFilter(fn.apply(new Query.Builder()).build());
        }

        public final Builder searchAfter(List<String> list) {
            this.searchAfter = Builder._listAddAll(this.searchAfter, list);
            return this;
        }

        public final Builder searchAfter(String value, String ... values) {
            this.searchAfter = Builder._listAdd(this.searchAfter, value, values);
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder sort(List<SortOptions> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(SortOptions value, SortOptions ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
            return this.sort(fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        }

        public final Builder trackScores(@Nullable Boolean value) {
            this.trackScores = value;
            return this;
        }

        public final Builder trackTotalHits(@Nullable TrackHits value) {
            this.trackTotalHits = value;
            return this;
        }

        public final Builder trackTotalHits(Function<TrackHits.Builder, ObjectBuilder<TrackHits>> fn) {
            return this.trackTotalHits(fn.apply(new TrackHits.Builder()).build());
        }

        public final Builder suggest(@Nullable Suggester value) {
            this.suggest = value;
            return this;
        }

        public final Builder suggest(Function<Suggester.Builder, ObjectBuilder<Suggester>> fn) {
            return this.suggest(fn.apply(new Suggester.Builder()).build());
        }

        public final Builder highlight(@Nullable Highlight value) {
            this.highlight = value;
            return this;
        }

        public final Builder highlight(Function<Highlight.Builder, ObjectBuilder<Highlight>> fn) {
            return this.highlight(fn.apply(new Highlight.Builder()).build());
        }

        public final Builder source(@Nullable SourceConfig value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<SourceConfig.Builder, ObjectBuilder<SourceConfig>> fn) {
            return this.source(fn.apply(new SourceConfig.Builder()).build());
        }

        public final Builder scriptFields(Map<String, ScriptField> map) {
            this.scriptFields = Builder._mapPutAll(this.scriptFields, map);
            return this;
        }

        public final Builder scriptFields(String key, ScriptField value) {
            this.scriptFields = Builder._mapPut(this.scriptFields, key, value);
            return this;
        }

        public final Builder scriptFields(String key, Function<ScriptField.Builder, ObjectBuilder<ScriptField>> fn) {
            return this.scriptFields(key, fn.apply(new ScriptField.Builder()).build());
        }

        @Override
        public MultisearchBody build() {
            this._checkSingleUse();
            return new MultisearchBody(this);
        }
    }
}

