/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.ws.wkhtmltopdf.client;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.UUID;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.opensingular.lib.commons.dto.HtmlToPdfDTO;
import org.opensingular.lib.commons.pdf.HtmlToPdfConverter;

public class MockHtmlToPdfConverter
implements HtmlToPdfConverter {
    public Optional<File> convert(HtmlToPdfDTO htmlToPdfDTO) {
        return Optional.ofNullable(this.mock()).map(Path::toFile);
    }

    public InputStream convertStream(HtmlToPdfDTO htmlToPdfDTO) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path mock() {
        try (PDDocument document = new PDDocument();){
            PDPage page = new PDPage();
            PDType1Font font = PDType1Font.COURIER;
            Path tempFile = Files.createTempFile("singular-mock" + UUID.randomUUID(), ".pdf", new FileAttribute[0]);
            int fontSize = 12;
            int tx = 100;
            int ty = 700;
            document.addPage(page);
            PDPageContentStream contentStream = new PDPageContentStream(document, page);
            contentStream.beginText();
            contentStream.setFont((PDFont)font, (float)fontSize);
            contentStream.newLineAtOffset((float)tx, (float)ty);
            contentStream.showText("Aplica\u00e7\u00e3o em modo de desenvolvimento.");
            contentStream.endText();
            contentStream.close();
            document.save(tempFile.toFile());
            Path path = tempFile;
            return path;
        }
        catch (IOException ex) {
            this.getLogger().error("N\u00e3o foi possivel escrever o pdf mock", (Throwable)ex);
            return null;
        }
    }
}

