/*
 * Decompiled with CFR 0.152.
 */
package org.opensingular.ws.wkhtmltopdf.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.opensingular.lib.commons.base.SingularProperties;
import org.opensingular.lib.commons.dto.HtmlToPdfDTO;
import org.opensingular.lib.commons.pdf.HtmlToPdfConverter;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.SimpleClientHttpRequestFactory;

public class RestfulHtmlToPdfConverter
implements HtmlToPdfConverter {
    public static final String ENDPOINT_WS_WKHTMLTOPDF_DEFAULT_VALUE = "http://localhost:8080/wkhtmltopdf-ws";
    private final String endpoint;

    public static RestfulHtmlToPdfConverter createUsingDefaultConfig() {
        return new RestfulHtmlToPdfConverter(RestfulHtmlToPdfConverter.getEndpointDefault());
    }

    public static String getEndpointDefault() {
        String baseURL = SingularProperties.get((String)"singular.ws.wkhtmltopdf.url", (String)ENDPOINT_WS_WKHTMLTOPDF_DEFAULT_VALUE);
        LoggerFactory.getLogger(RestfulHtmlToPdfConverter.class).warn("Singular property {} not set! Defaulting to {} ", (Object)"singular.ws.wkhtmltopdf.url", (Object)ENDPOINT_WS_WKHTMLTOPDF_DEFAULT_VALUE);
        String context = "/converthtmltopdf";
        return baseURL + context;
    }

    public RestfulHtmlToPdfConverter(String endpoint) {
        this.endpoint = endpoint;
    }

    public Optional<File> convert(HtmlToPdfDTO htmlToPdfDTO) {
        InputStream in = this.convertStream(htmlToPdfDTO);
        if (in != null) {
            return Optional.ofNullable(this.createTempFile(in));
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File createTempFile(InputStream in) {
        Path path = null;
        try {
            path = Files.createTempFile(RestfulHtmlToPdfConverter.generateFileName(), ".pdf", new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(path, new OpenOption[0]);){
                IOUtils.copy((InputStream)in, (OutputStream)out);
                File file = path.toFile();
                return file;
            }
            catch (IOException ex) {
                this.getLogger().error("N\u00e3o foi possivel escrever o arquivo temporario", (Throwable)ex);
                return null;
            }
        }
        catch (IOException e) {
            this.getLogger().error("N\u00e3o foi possivel criar o arquivo temporario", (Throwable)e);
        }
        return null;
    }

    public InputStream convertStream(HtmlToPdfDTO htmlToPdfDTO) {
        if (htmlToPdfDTO != null) {
            ClientHttpResponse response = null;
            try {
                SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
                ClientHttpRequest request = requestFactory.createRequest(URI.create(this.endpoint), HttpMethod.POST);
                request.getHeaders().add("content-type", "application/json");
                ObjectMapper mapper = new ObjectMapper();
                request.getBody().write(mapper.writeValueAsBytes((Object)htmlToPdfDTO));
                response = request.execute();
                return response.getBody();
            }
            catch (IOException ex) {
                this.getLogger().error("Problema ao converter HtmlToPdfDTO para pdf", (Throwable)ex);
            }
        }
        return null;
    }

    public static String generateFileName() {
        return String.format("singular-ws-html2pdf-%s.pdf", UUID.randomUUID());
    }
}

