/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveController;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveFileSystem;
import org.terracotta.agent.repkg.de.schlichtherle.io.IORunnable;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveDriver;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveEntry;

abstract class ArchiveFileSystemController
extends ArchiveController {
    private AutoMounter autoMounter = new ResetFileSystem();

    ArchiveFileSystemController(File target, ArchiveController enclController, String enclEntryName, ArchiveDriver driver) {
        super(target, enclController, enclEntryName, driver);
    }

    @Override
    final boolean isTouched() {
        ArchiveFileSystem fileSystem = this.getFileSystem();
        return fileSystem != null && fileSystem.isTouched();
    }

    void touch() throws IOException {
        assert (this.writeLock().isLocked());
        this.setScheduled(true);
    }

    @Override
    final ArchiveFileSystem autoMount(boolean autoCreate) throws IOException {
        assert (this.readLock().isLocked() || this.writeLock().isLocked());
        return this.autoMounter.autoMount(autoCreate);
    }

    final ArchiveFileSystem getFileSystem() {
        return this.autoMounter.getFileSystem();
    }

    final void setFileSystem(ArchiveFileSystem fileSystem) {
        this.autoMounter.setFileSystem(fileSystem);
    }

    abstract void mount(boolean var1) throws IOException;

    @Override
    void reset() throws IOException {
        this.setFileSystem(null);
    }

    final ArchiveEntry createArchiveEntry(String entryName, ArchiveEntry blueprint) throws CharConversionException {
        return this.getDriver().createArchiveEntry(this, entryName, blueprint);
    }

    private class FalsePositiveFileSystem
    extends AutoMounter {
        private final ArchiveController.FalsePositiveException exception;

        private FalsePositiveFileSystem(ArchiveController.FalsePositiveException exception) {
            assert (exception != null) : "It's illegal to use this state with null as the IOException!";
            this.exception = exception;
        }

        @Override
        ArchiveFileSystem autoMount(boolean create) throws IOException {
            throw this.exception;
        }

        @Override
        void setFileSystem(ArchiveFileSystem fileSystem) {
            assert (fileSystem == null) : "It's illegal to assign a file system to an archive controller for a false positive archive file!";
            ArchiveFileSystemController.this.autoMounter = new ResetFileSystem();
        }
    }

    private class MountedFileSystem
    extends AutoMounter {
        private final ArchiveFileSystem fileSystem;

        private MountedFileSystem(ArchiveFileSystem fileSystem) {
            assert (fileSystem != null) : "It's illegal to use this state with null as the file system!";
            this.fileSystem = fileSystem;
        }

        @Override
        ArchiveFileSystem autoMount(boolean create) throws IOException {
            return this.fileSystem;
        }

        @Override
        ArchiveFileSystem getFileSystem() {
            return this.fileSystem;
        }

        @Override
        void setFileSystem(ArchiveFileSystem fileSystem) {
            assert (fileSystem == null) : "It's illegal to assign a file system to an archive controller which already has its file system mounted!";
            ArchiveFileSystemController.this.autoMounter = new ResetFileSystem();
        }
    }

    private class ResetFileSystem
    extends AutoMounter {
        private ResetFileSystem() {
        }

        @Override
        ArchiveFileSystem autoMount(final boolean create) throws IOException {
            try {
                class Mounter
                implements IORunnable {
                    Mounter() {
                    }

                    @Override
                    public void run() throws IOException {
                        if (ArchiveFileSystemController.this.autoMounter == ResetFileSystem.this) {
                            ArchiveFileSystemController.this.mount(create);
                            assert (ArchiveFileSystemController.this.autoMounter instanceof MountedFileSystem);
                        } else {
                            assert (ArchiveFileSystemController.this.autoMounter != null);
                            assert (!(ArchiveFileSystemController.this.autoMounter instanceof ResetFileSystem));
                        }
                    }
                }
                ArchiveFileSystemController.this.runWriteLocked(new Mounter());
            }
            catch (ArchiveController.FalsePositiveException ex) {
                if (ex.isCacheable()) {
                    ArchiveFileSystemController.this.autoMounter = new FalsePositiveFileSystem(ex);
                }
                throw ex;
            }
            assert (ArchiveFileSystemController.this.autoMounter != this);
            return ArchiveFileSystemController.this.autoMounter.autoMount(create);
        }

        @Override
        void setFileSystem(ArchiveFileSystem fileSystem) {
            if (fileSystem != null) {
                ArchiveFileSystemController.this.autoMounter = new MountedFileSystem(fileSystem);
            }
        }
    }

    private static abstract class AutoMounter {
        private AutoMounter() {
        }

        abstract ArchiveFileSystem autoMount(boolean var1) throws IOException;

        ArchiveFileSystem getFileSystem() {
            return null;
        }

        abstract void setFileSystem(ArchiveFileSystem var1);
    }
}

