/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveController;
import org.terracotta.agent.repkg.de.schlichtherle.io.File;

public class FileOutputStream
extends FilterOutputStream {
    public FileOutputStream(String name) throws FileNotFoundException {
        super(FileOutputStream.createOutputStream(File.getDefaultArchiveDetector().createFile(name), false));
    }

    public FileOutputStream(String name, boolean append) throws FileNotFoundException {
        super(FileOutputStream.createOutputStream(File.getDefaultArchiveDetector().createFile(name), append));
    }

    public FileOutputStream(java.io.File file) throws FileNotFoundException {
        super(FileOutputStream.createOutputStream(file, false));
    }

    public FileOutputStream(java.io.File file, boolean append) throws FileNotFoundException {
        super(FileOutputStream.createOutputStream(file, append));
    }

    public FileOutputStream(FileDescriptor fd) {
        super(new java.io.FileOutputStream(fd));
    }

    private static OutputStream createOutputStream(java.io.File file, boolean append) throws FileNotFoundException {
        try {
            if (file instanceof File) {
                File smartFile = (File)file;
                smartFile.ensureNotVirtualRoot("cannot write");
                File archive = smartFile.getEnclArchive();
                String entryName = smartFile.getEnclEntryName();
                assert (archive != null == (entryName != null));
                if (archive != null) {
                    return archive.getArchiveController().createOutputStream(entryName, append);
                }
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        return new java.io.FileOutputStream(file, append);
    }

    @Override
    public void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
    }
}

