/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveBusyException;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveController;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveDetector;
import org.terracotta.agent.repkg.de.schlichtherle.io.ArchiveFileSystem;
import org.terracotta.agent.repkg.de.schlichtherle.io.ContainsFileException;
import org.terracotta.agent.repkg.de.schlichtherle.io.File;
import org.terracotta.agent.repkg.de.schlichtherle.io.FileBusyException;
import org.terracotta.agent.repkg.de.schlichtherle.io.IORunnable;
import org.terracotta.agent.repkg.de.schlichtherle.io.InputIOException;
import org.terracotta.agent.repkg.de.schlichtherle.io.Streams;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.ArchiveEntry;
import org.terracotta.agent.repkg.de.schlichtherle.io.archive.spi.RfsEntry;
import org.terracotta.agent.repkg.de.schlichtherle.io.util.Paths;

final class Files {
    private static final CopyLock copyLock = new CopyLock();

    protected Files() {
    }

    public static boolean contains(java.io.File a, java.io.File b) {
        a = Files.getCanOrAbsFile(a);
        b = Files.getCanOrAbsFile(b);
        return Files.contains(a.getPath(), b.getPath());
    }

    static boolean contains(String pathA, String pathB) {
        int lengthB;
        if (File.separatorChar == '\\') {
            pathA = pathA.toLowerCase();
            pathB = pathB.toLowerCase();
        }
        if (!pathB.startsWith(pathA)) {
            return false;
        }
        int lengthA = pathA.length();
        if (lengthA == (lengthB = pathB.length())) {
            return true;
        }
        if (lengthA < lengthB) {
            return pathB.charAt(lengthA) == File.separatorChar;
        }
        return false;
    }

    public static java.io.File getCanOrAbsFile(java.io.File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            java.io.File parent = file.getParentFile();
            return Files.normalize(parent != null ? new java.io.File(Files.getCanOrAbsFile(parent), file.getName()) : file.getAbsoluteFile());
        }
    }

    public static java.io.File normalize(java.io.File file) {
        String path = file.getPath();
        String newPath = Paths.normalize(path, File.separatorChar);
        return newPath != path ? new java.io.File(newPath) : file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWritableOrCreatable(java.io.File file) {
        try {
            if (!file.exists()) {
                boolean created = file.createNewFile();
                boolean ok = Files.isWritableOrCreatable(file);
                if (created && !file.delete()) {
                    ok = false;
                }
                return ok;
            }
            if (file.canWrite()) {
                boolean ok;
                long time = file.lastModified();
                if (!file.setLastModified(time + 1L)) {
                    return false;
                }
                try {
                    RandomAccessFile raf = new RandomAccessFile(file, "rwd");
                    try {
                        boolean empty;
                        int octet = raf.read();
                        if (octet == -1) {
                            octet = 0;
                            empty = true;
                        } else {
                            empty = false;
                        }
                        raf.seek(0L);
                        raf.write(~octet & 0xFF);
                        try {
                            raf.seek(0L);
                            raf.write(octet);
                            raf.seek(0L);
                            int check = raf.read();
                            ok = octet == check;
                        }
                        finally {
                            if (empty) {
                                raf.setLength(0L);
                            }
                        }
                    }
                    finally {
                        raf.close();
                    }
                }
                finally {
                    if (!file.setLastModified(time)) {
                        ok = false;
                    }
                }
                return ok;
            }
            return false;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static final boolean mv(java.io.File src, java.io.File dst, ArchiveDetector detector) {
        return !Files.contains(src, dst) && Files.mv0(src, dst, detector);
    }

    private static boolean mv0(java.io.File src, java.io.File dst, ArchiveDetector detector) {
        boolean ok = true;
        if (src.isDirectory()) {
            boolean srcIsGhost;
            long srcLastModified = src.lastModified();
            boolean srcIsArchived = src instanceof File && ((File)src).getInnerArchive() != null;
            boolean dstIsArchived = dst instanceof File && ((File)dst).getInnerArchive() != null;
            boolean bl = srcIsGhost = srcIsArchived && srcLastModified <= 0L;
            if (!(srcIsGhost && dstIsArchived && File.isLenient())) {
                dst.mkdir();
            }
            Object[] members = src.list();
            if (!srcIsArchived && dstIsArchived) {
                Arrays.sort(members);
            }
            for (Object member : members) {
                ok &= Files.mv0(detector.createFile(src, (String)member), detector.createFile(dst, (String)member), detector);
            }
            if (!srcIsGhost) {
                ok &= dst.setLastModified(srcLastModified);
            }
        } else if (src.isFile()) {
            try {
                Files.cp(true, src, dst);
            }
            catch (IOException ex) {
                ok = false;
            }
        } else {
            ok = false;
        }
        return ok && src.delete();
    }

    public static final void cp_r(boolean preserve, java.io.File src, java.io.File dst, ArchiveDetector srcDetector, ArchiveDetector dstDetector) throws IOException {
        if (Files.contains(src, dst)) {
            throw new ContainsFileException(src, dst);
        }
        Files.cp_r0(preserve, src, dst, srcDetector, dstDetector);
    }

    private static void cp_r0(boolean preserve, java.io.File src, java.io.File dst, ArchiveDetector srcDetector, ArchiveDetector dstDetector) throws IOException {
        if (src.isDirectory()) {
            boolean srcIsGhost;
            long srcLastModified = src.lastModified();
            boolean srcIsArchived = src instanceof File && ((File)src).getInnerArchive() != null;
            boolean dstIsArchived = dst instanceof File && ((File)dst).getInnerArchive() != null;
            boolean bl = srcIsGhost = srcIsArchived && srcLastModified <= 0L;
            if (!(srcIsGhost && dstIsArchived && File.isLenient() || dst.mkdir() || dst.isDirectory())) {
                throw new IOException("destination is not a directory");
            }
            Object[] members = src.list();
            if (!srcIsArchived && dstIsArchived) {
                Arrays.sort(members);
            }
            for (Object member : members) {
                Files.cp_r0(preserve, srcDetector.createFile(src, (String)member), dstDetector.createFile(dst, (String)member), srcDetector, dstDetector);
            }
            if (preserve && !srcIsGhost && !dst.setLastModified(srcLastModified)) {
                throw new IOException("cannot set last modification time");
            }
        } else if (src.isFile() && (!dst.exists() || dst.isFile())) {
            Files.cp0(preserve, src, dst);
        } else {
            throw new IOException("cannot copy non-existent or special files");
        }
    }

    public static final void cp(boolean preserve, java.io.File src, java.io.File dst) throws IOException {
        if (Files.contains(src, dst)) {
            throw new ContainsFileException(src, dst);
        }
        Files.cp0(preserve, src, dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp0(boolean preserve, java.io.File src, java.io.File dst) throws IOException {
        assert (src != null);
        assert (dst != null);
        try {
            try {
                if (src instanceof File) {
                    File srcFile = (File)src;
                    srcFile.ensureNotVirtualRoot("cannot read");
                    String srcEntryName = srcFile.getEnclEntryName();
                    if (srcEntryName != null) {
                        Files.cp0(preserve, srcFile.getEnclArchive().getArchiveController(), srcEntryName, dst);
                        return;
                    }
                }
            }
            catch (ArchiveController.RfsEntryFalsePositiveException srcIsNotArchive) {
                // empty catch block
            }
            FileInputStream in = new FileInputStream(src);
            try {
                Files.cp0(preserve, src, in, dst);
            }
            finally {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ex) {
                    throw new InputIOException(ex);
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw ex;
        }
        catch (ArchiveBusyException ex) {
            throw new FileBusyException(ex);
        }
        catch (ArchiveFileSystem.ArchiveFileSystemException afse) {
            FileNotFoundException fnfe = new FileNotFoundException(afse.toString());
            fnfe.initCause(afse);
            throw fnfe;
        }
        catch (IOException ex) {
            dst.delete();
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp0(boolean preserve, java.io.File src, InputStream in, java.io.File dst) throws IOException {
        try {
            if (dst instanceof File) {
                File dstFile = (File)dst;
                dstFile.ensureNotVirtualRoot("cannot write");
                String dstEntryName = dstFile.getEnclEntryName();
                if (dstEntryName != null) {
                    Files.cp0(preserve, src, in, dstFile.getEnclArchive().getArchiveController(), dstEntryName);
                    return;
                }
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException dstIsNotArchive) {
            // empty catch block
        }
        FileOutputStream out = new FileOutputStream(dst);
        try {
            Streams.cat(in, out);
        }
        finally {
            ((OutputStream)out).close();
        }
        if (preserve && !dst.setLastModified(src.lastModified())) {
            throw new IOException(dst.getPath() + " (cannot preserve last modification time)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp0(boolean preserve, ArchiveController srcController, String srcEntryName, java.io.File dst) throws IOException {
        try {
            FileOutputStream out;
            long time;
            InputStream in;
            block15: {
                try {
                    if (dst instanceof File) {
                        File dstFile = (File)dst;
                        dstFile.ensureNotVirtualRoot("cannot write");
                        String dstEntryName = dstFile.getEnclEntryName();
                        if (dstEntryName != null) {
                            Files.cp0(preserve, srcController, srcEntryName, dstFile.getEnclArchive().getArchiveController(), dstEntryName);
                            return;
                        }
                    }
                }
                catch (ArchiveController.RfsEntryFalsePositiveException isNotArchive) {
                    if (isNotArchive.getController() != srcController) break block15;
                    throw isNotArchive;
                }
            }
            srcController.readLock().lock();
            try {
                in = srcController.createInputStream0(srcEntryName);
                time = srcController.lastModified(srcEntryName);
            }
            finally {
                srcController.readLock().unlock();
            }
            try {
                out = new FileOutputStream(dst);
            }
            catch (IOException ex) {
                try {
                    in.close();
                }
                catch (IOException inFailure) {
                    throw new InputIOException(inFailure);
                }
                throw ex;
            }
            Files.cp(in, out);
            if (preserve && !dst.setLastModified(time)) {
                throw new IOException(dst.getPath() + " (cannot preserve last modification time)");
            }
        }
        catch (ArchiveController.ArchiveEntryFalsePositiveException ex) {
            assert (srcController == ex.getController());
            Files.cp0(preserve, srcController.getEnclController(), srcController.enclEntryName(srcEntryName), dst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp0(final boolean preserve, final ArchiveController srcController, final String srcEntryName, final ArchiveController dstController, final String dstEntryName) throws IOException {
        try {
            class IOStreamCreator
            implements IORunnable {
                InputStream in;
                OutputStream out;

                IOStreamCreator() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() throws IOException {
                    ArchiveEntry dstEntry;
                    ArchiveFileSystem.Delta delta;
                    ArchiveEntry srcEntry;
                    class SrcControllerUpdater
                    implements IORunnable {
                        SrcControllerUpdater() {
                        }

                        @Override
                        public void run() throws IOException {
                            srcController.autoUmount(srcEntryName);
                            srcController.readLock().lock();
                        }
                    }
                    srcController.runWriteLocked(new SrcControllerUpdater());
                    try {
                        dstController.autoUmount(dstEntryName);
                        ArchiveFileSystem srcFileSystem = srcController.autoMount(false);
                        srcEntry = srcFileSystem.get(srcEntryName);
                        boolean lenient = File.isLenient();
                        ArchiveFileSystem dstFileSystem = dstController.autoMount(lenient);
                        delta = dstFileSystem.link(dstEntryName, lenient, preserve ? srcEntry : null);
                        dstEntry = delta.getEntry();
                        this.in = srcController.createInputStream(srcEntry, dstEntry);
                    }
                    finally {
                        srcController.readLock().unlock();
                    }
                    try {
                        this.out = dstController.createOutputStream(dstEntry, srcEntry);
                        try {
                            delta.commit();
                        }
                        catch (IOException ex) {
                            this.out.close();
                            throw ex;
                        }
                    }
                    catch (IOException ex) {
                        try {
                            this.in.close();
                        }
                        catch (IOException inFailure) {
                            throw new InputIOException(inFailure);
                        }
                        throw ex;
                    }
                }
            }
            IOStreamCreator streams = new IOStreamCreator();
            CopyLock copyLock = Files.copyLock;
            synchronized (copyLock) {
                dstController.runWriteLocked(streams);
            }
            Files.cp(streams.in, streams.out);
        }
        catch (ArchiveController.ArchiveEntryFalsePositiveException ex) {
            if (dstController != ex.getController()) {
                throw ex;
            }
            Files.cp0(preserve, srcController, srcEntryName, dstController.getEnclController(), dstController.enclEntryName(dstEntryName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void cp0(final boolean preserve, final java.io.File src, InputStream in, final ArchiveController dstController, final String dstEntryName) throws IOException {
        try {
            class OStreamCreator
            implements IORunnable {
                OutputStream out;

                OStreamCreator() {
                }

                @Override
                public void run() throws IOException {
                    dstController.autoUmount(dstEntryName);
                    boolean lenient = File.isLenient();
                    RfsEntry srcEntry = new RfsEntry(src);
                    ArchiveFileSystem dstFileSystem = dstController.autoMount(lenient);
                    ArchiveFileSystem.Delta delta = dstFileSystem.link(dstEntryName, lenient, preserve ? srcEntry : null);
                    ArchiveEntry dstEntry = delta.getEntry();
                    this.out = dstController.createOutputStream(dstEntry, srcEntry);
                    delta.commit();
                }
            }
            OStreamCreator stream = new OStreamCreator();
            dstController.runWriteLocked(stream);
            OutputStream out = stream.out;
            try {
                Streams.cat(in, out);
            }
            finally {
                out.close();
            }
        }
        catch (ArchiveController.ArchiveEntryFalsePositiveException ex) {
            assert (dstController == ex.getController());
            Files.cp0(preserve, src, in, dstController.getEnclController(), dstController.enclEntryName(dstEntryName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cp(InputStream in, OutputStream out) throws IOException {
        try {
            try {
                Streams.cat(in, out);
            }
            finally {
                out.close();
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                throw new InputIOException(ex);
            }
        }
    }

    public static boolean rm_r(java.io.File file) {
        boolean ok = true;
        if (file.isDirectory()) {
            java.io.File[] members = file.listFiles();
            int i = members.length;
            while (--i >= 0) {
                ok &= Files.rm_r(members[i]);
            }
        }
        return ok && file.delete();
    }

    private static class CopyLock {
        private CopyLock() {
        }
    }
}

