/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.terracotta.agent.repkg.de.schlichtherle.io.ReadWriteLock;
import org.terracotta.agent.repkg.de.schlichtherle.io.ReentrantLock;
import org.terracotta.agent.repkg.de.schlichtherle.util.ThreadLocalCounter;

final class ReentrantReadWriteLock
implements ReadWriteLock {
    private static final String CLASS_NAME = "de/schlichtherle/io/ReentrantReadWriteLock".replace('/', '.');
    private static final Logger logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    private final ReadLock readLock = new ReadLock();
    private final WriteLock writeLock = new WriteLock();
    private int totalWriteLockCount;
    private int totalReadLockCount;

    ReentrantReadWriteLock() {
    }

    @Override
    public ReentrantLock readLock() {
        return this.readLock;
    }

    @Override
    public ReentrantLock writeLock() {
        return this.writeLock;
    }

    private synchronized void lockRead() {
        int threadWriteLockCount = this.writeLock.lockCount();
        if (threadWriteLockCount <= 0) {
            while (this.totalWriteLockCount - threadWriteLockCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    logger.log(Level.FINE, "interrupted", ex);
                    logger.log(Level.FINE, "continuing");
                }
            }
        }
        ++this.totalReadLockCount;
    }

    private synchronized void lockReadInterruptibly() throws InterruptedException {
        int threadWriteLockCount = this.writeLock.lockCount();
        if (threadWriteLockCount <= 0) {
            while (this.totalWriteLockCount - threadWriteLockCount > 0) {
                this.wait();
            }
        }
        ++this.totalReadLockCount;
    }

    private synchronized boolean tryLockRead() {
        int threadWriteLockCount = this.writeLock.lockCount();
        if (threadWriteLockCount <= 0 && this.totalWriteLockCount - threadWriteLockCount > 0) {
            return false;
        }
        ++this.totalReadLockCount;
        return true;
    }

    private synchronized void unlockRead() {
        --this.totalReadLockCount;
        this.notifyAll();
    }

    private synchronized void lockWrite() {
        int threadWriteLockCount = this.writeLock.lockCount();
        if (threadWriteLockCount <= 0) {
            while (this.totalReadLockCount > 0 || this.totalWriteLockCount - threadWriteLockCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    logger.log(Level.FINE, "interrupted", ex);
                    logger.log(Level.FINE, "continuing");
                }
            }
        }
        ++this.totalWriteLockCount;
    }

    private synchronized void lockWriteInterruptibly() throws InterruptedException {
        int threadWriteLockCount = this.writeLock.lockCount();
        if (threadWriteLockCount <= 0) {
            while (this.totalReadLockCount > 0 || this.totalWriteLockCount - threadWriteLockCount > 0) {
                this.wait();
            }
        }
        ++this.totalWriteLockCount;
    }

    private synchronized boolean tryLockWrite() {
        int threadWriteLockCount = this.writeLock.lockCount();
        if (threadWriteLockCount <= 0 && (this.totalReadLockCount > 0 || this.totalWriteLockCount - threadWriteLockCount > 0)) {
            return false;
        }
        ++this.totalWriteLockCount;
        return true;
    }

    private synchronized void unlockWrite() {
        --this.totalWriteLockCount;
        this.notifyAll();
    }

    private class WriteLock
    extends AbstractLock {
        private WriteLock() {
        }

        @Override
        public void lock() {
            ReentrantReadWriteLock.this.lockWrite();
            super.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            ReentrantReadWriteLock.this.lockWriteInterruptibly();
            super.lock();
        }

        @Override
        public boolean tryLock() {
            boolean locked = ReentrantReadWriteLock.this.tryLockWrite();
            if (locked) {
                super.lock();
            }
            return locked;
        }

        @Override
        public void unlock() {
            super.unlock();
            ReentrantReadWriteLock.this.unlockWrite();
        }
    }

    private class ReadLock
    extends AbstractLock {
        private ReadLock() {
        }

        @Override
        public void lock() {
            ReentrantReadWriteLock.this.lockRead();
            super.lock();
        }

        @Override
        public void lockInterruptibly() throws InterruptedException {
            ReentrantReadWriteLock.this.lockReadInterruptibly();
            super.lock();
        }

        @Override
        public boolean tryLock() {
            boolean locked = ReentrantReadWriteLock.this.tryLockRead();
            if (locked) {
                super.lock();
            }
            return locked;
        }

        @Override
        public void unlock() {
            super.unlock();
            ReentrantReadWriteLock.this.unlockRead();
        }
    }

    private static abstract class AbstractLock
    extends ThreadLocalCounter
    implements ReentrantLock {
        private AbstractLock() {
        }

        @Override
        public final boolean isLocked() {
            return this.getCounter() > 0;
        }

        @Override
        public final int lockCount() {
            return this.getCounter();
        }

        @Override
        public void lock() {
            this.increment();
        }

        @Override
        public void unlock() {
            int lockCount = this.getCounter();
            if (lockCount <= 0) {
                throw new IllegalMonitorStateException();
            }
            this.setCounter(lockCount - 1);
        }
    }
}

