/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.key;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import org.terracotta.agent.repkg.de.schlichtherle.key.AesKeyProvider;
import org.terracotta.agent.repkg.de.schlichtherle.key.KeyManager;
import org.terracotta.agent.repkg.de.schlichtherle.key.KeyPromptingDisabledException;
import org.terracotta.agent.repkg.de.schlichtherle.key.KeyProvider;
import org.terracotta.agent.repkg.de.schlichtherle.key.PromptingAesKeyProvider;
import org.terracotta.agent.repkg.de.schlichtherle.key.PromptingKeyProvider;
import org.terracotta.agent.repkg.de.schlichtherle.key.PromptingKeyProviderUI;

public abstract class PromptingKeyManager
extends KeyManager {
    private static volatile boolean prompting = true;
    private final Map providerUITypes = new HashMap();

    public PromptingKeyManager() {
        this.mapKeyProviderType(KeyProvider.class, PromptingKeyProvider.class);
        this.mapKeyProviderType(AesKeyProvider.class, PromptingAesKeyProvider.class);
    }

    public static boolean isPrompting() {
        KeyManager manager = PromptingKeyManager.getInstance();
        return manager instanceof PromptingKeyManager && ((PromptingKeyManager)manager).isPromptingImpl();
    }

    protected boolean isPromptingImpl() {
        return prompting;
    }

    public static void setPrompting(boolean prompting) {
        KeyManager manager = PromptingKeyManager.getInstance();
        if (manager instanceof PromptingKeyManager) {
            ((PromptingKeyManager)manager).setPromptingImpl(prompting);
        }
    }

    protected void setPromptingImpl(boolean prompting) {
        PromptingKeyManager.prompting = prompting;
    }

    static void ensurePrompting() throws KeyPromptingDisabledException {
        KeyManager manager = PromptingKeyManager.getInstance();
        if (manager instanceof PromptingKeyManager) {
            ((PromptingKeyManager)manager).ensurePromptingImpl();
        }
    }

    protected void ensurePromptingImpl() throws KeyPromptingDisabledException {
        if (!this.isPromptingImpl()) {
            throw new KeyPromptingDisabledException();
        }
    }

    public static void resetCancelledPrompts() {
        PromptingKeyManager.forEachKeyProvider(new KeyManager.KeyProviderCommand(){

            @Override
            public void run(String resourceID, KeyProvider provider) {
                if (provider instanceof PromptingKeyProvider) {
                    ((PromptingKeyProvider)provider).resetCancelledPrompt();
                }
            }
        });
    }

    protected final void register(String uiClassID, Class uiClass) {
        this.mapPromptingKeyProviderUIType(uiClassID, uiClass);
    }

    protected final synchronized void mapPromptingKeyProviderUIType(String uiClassID, Class uiClass) {
        if (uiClassID == null) {
            throw new NullPointerException("uiClassID");
        }
        if (!PromptingKeyProviderUI.class.isAssignableFrom(uiClass)) {
            throw new IllegalArgumentException(uiClass.getName() + " must be PromptingKeyProviderUI or a subclass!");
        }
        try {
            uiClass.getConstructor(null);
        }
        catch (NoSuchMethodException noPublicNullaryConstructor) {
            IllegalArgumentException iae = new IllegalArgumentException(uiClass.getName() + " (no public nullary constructor)");
            iae.initCause(noPublicNullaryConstructor);
            throw iae;
        }
        this.providerUITypes.put(uiClassID, uiClass);
    }

    @Override
    public KeyProvider getKeyProvider(String resourceID, Class keyProviderType) throws NullPointerException, ClassCastException, IllegalArgumentException {
        KeyProvider provider = super.getKeyProvider(resourceID, keyProviderType);
        if (provider instanceof PromptingKeyProvider) {
            PromptingKeyProvider pkp = (PromptingKeyProvider)provider;
            pkp.setUI(this.getUI(pkp.getUIClassID()));
        }
        return provider;
    }

    private synchronized PromptingKeyProviderUI getUI(String uiClassID) {
        PromptingKeyProviderUI pkpui;
        Object value = this.providerUITypes.get(uiClassID);
        if (value instanceof Class) {
            try {
                pkpui = (PromptingKeyProviderUI)((Class)value).newInstance();
            }
            catch (InstantiationException failure) {
                throw new UndeclaredThrowableException(failure);
            }
            catch (IllegalAccessException failure) {
                throw new UndeclaredThrowableException(failure);
            }
            this.providerUITypes.put(uiClassID, pkpui);
        } else if (value != null) {
            pkpui = (PromptingKeyProviderUI)value;
        } else {
            throw new IllegalArgumentException(uiClassID + " (unknown user interface for PromptingKeyProvider)");
        }
        return pkpui;
    }
}

