/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.engine;

import ai.djl.Device;
import ai.djl.Model;
import ai.djl.engine.Engine;
import ai.djl.ndarray.NDManager;
import ai.djl.nn.SymbolBlock;
import ai.djl.paddlepaddle.engine.PpModel;
import ai.djl.paddlepaddle.engine.PpNDManager;
import ai.djl.paddlepaddle.jni.JniUtils;
import ai.djl.paddlepaddle.jni.LibUtils;
import ai.djl.training.GradientCollector;

public final class PpEngine
extends Engine {
    public static final String ENGINE_NAME = "PaddlePaddle";
    static final int RANK = 10;
    private Engine alternativeEngine;
    private boolean initialized;
    private String version = JniUtils.getVersion();

    private PpEngine() {
    }

    static Engine newInstance() {
        LibUtils.loadLibrary();
        return new PpEngine();
    }

    public Engine getAlternativeEngine() {
        if (!this.initialized && !Boolean.getBoolean("ai.djl.paddlepaddle.disable_alternative")) {
            Engine engine = Engine.getInstance();
            if (engine.getRank() < this.getRank()) {
                this.alternativeEngine = engine;
            }
            this.initialized = true;
        }
        return this.alternativeEngine;
    }

    public String getEngineName() {
        return ENGINE_NAME;
    }

    public int getRank() {
        return 10;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasCapability(String capability) {
        return false;
    }

    public Model newModel(String name, Device device) {
        return new PpModel(name, device, this.newBaseManager(device));
    }

    public SymbolBlock newSymbolBlock(NDManager manager) {
        throw new UnsupportedOperationException("PaddlePaddle does not support empty SymbolBlock");
    }

    public NDManager newBaseManager() {
        return this.newBaseManager(null);
    }

    public NDManager newBaseManager(Device device) {
        return PpNDManager.getSystemManager().newSubManager(device);
    }

    public GradientCollector newGradientCollector() {
        throw new UnsupportedOperationException("Not supported for PaddlePaddle");
    }

    public void setRandomSeed(int seed) {
        throw new UnsupportedOperationException("Not supported for PaddlePaddle");
    }

    public String toString() {
        return this.getEngineName() + ':' + this.getVersion();
    }
}

