/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.engine;

import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDArrayAdapter;
import ai.djl.ndarray.NDManager;
import ai.djl.ndarray.types.DataType;
import ai.djl.ndarray.types.Shape;
import ai.djl.paddlepaddle.engine.PpNDManager;
import ai.djl.paddlepaddle.jni.JniUtils;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;

public class PpNDArray
extends NDArrayAdapter {
    private ByteBuffer data;
    private AtomicReference<Long> handle;

    PpNDArray(NDManager manager, NDManager alternativeManager, ByteBuffer data, long handle) {
        super(manager, alternativeManager, null, null, String.valueOf(handle));
        this.data = data;
        this.handle = new AtomicReference<Long>(handle);
        manager.attachInternal(this.uid, (AutoCloseable)((Object)this));
    }

    public void setLoD(long[][] lod) {
        JniUtils.setNdLoD(this, lod);
    }

    public long[][] getLoD() {
        return JniUtils.getNdLoD(this);
    }

    public String getName() {
        return JniUtils.getNameFromNd(this);
    }

    public void setName(String name) {
        JniUtils.setNdName(this, name);
    }

    public DataType getDataType() {
        if (this.dataType == null) {
            this.dataType = JniUtils.getDTypeFromNd(this);
        }
        return this.dataType;
    }

    public Shape getShape() {
        if (this.shape == null) {
            this.shape = JniUtils.getShapeFromNd(this);
        }
        return this.shape;
    }

    public void intern(NDArray replaced) {
        Long pointer = this.handle.getAndSet(null);
        if (pointer != null) {
            JniUtils.deleteNd(pointer);
        }
        this.data = ((PpNDArray)replaced).data;
        this.handle = ((PpNDArray)replaced).handle;
    }

    public void detach() {
        this.manager.detachInternal(this.getUid());
        this.manager = PpNDManager.getSystemManager();
    }

    public ByteBuffer toByteBuffer() {
        if (this.data == null) {
            this.data = JniUtils.getByteBufferFromNd(this);
        }
        this.data.rewind();
        return this.data;
    }

    public long getHandle() {
        Long reference = this.handle.get();
        if (reference == null) {
            throw new IllegalStateException("Native resource has been release already.");
        }
        return reference;
    }

    public void close() {
        super.close();
        Long pointer = this.handle.getAndSet(null);
        if (pointer != null) {
            JniUtils.deleteNd(pointer);
            this.data = null;
        }
    }
}

